/*
 setup-dcc.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "setup-int.h"

static gboolean sig_setup_apply(void)
{
    setup_write("dcc", dcc_options);
    return TRUE;
}

static GtkWidget *create_spin(GtkWidget *box, GtkAdjustment *adj, gchar *text, SETUP_REC *option)
{
    GtkWidget *hbox, *label, *spin;

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 0);

    label = gtk_label_new(text);
    gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    spin = gtk_spin_button_new(adj, 0, 0);
    gtk_object_set_data(GTK_OBJECT(spin), "hbox", hbox);
    option->widget = spin;
    gtk_widget_set_usize(spin, 75, -1);
    gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 0);

    return spin;
}

static void sig_dccport_clicked(GtkToggleButton *button, GtkWidget *widget)
{
    GtkWidget *hbox;
    gboolean active;

    hbox = gtk_object_get_data(GTK_OBJECT(widget), "hbox");

    active = gtk_toggle_button_get_active(button);
    gtk_widget_set_sensitive(hbox, active);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 0);
}

static void sig_autoget_clicked(GtkToggleButton *button)
{
    gboolean active;

    active = gtk_toggle_button_get_active(button);
    gtk_widget_set_sensitive(gtk_object_get_data(GTK_OBJECT(button), "autogetsize"), active);
    gtk_widget_set_sensitive(gtk_object_get_data(GTK_OBJECT(button), "autogetmasks"), active);
}

static gboolean setup_dcc(GtkWidget *dialog)
{
    GtkWidget *mainvbox, *vbox, *hbox, *frame, *checkbox, *entry, *spin;
    GtkAdjustment *adj;

    g_return_val_if_fail(dialog != NULL, FALSE);

    mainvbox = gtk_vbox_new(FALSE, 10);
    gtk_container_border_width(GTK_CONTAINER(mainvbox), 10);

    /* --- DCC GET --- */
    frame = gtk_frame_new(_("Receive"));
    gtk_box_pack_start(GTK_BOX(mainvbox), frame, FALSE, FALSE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Automatically rename file if it exists"));
    dcc_options[OPTION_DCC_AUTORENAME].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Automatically get file when offered"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), TRUE);
    gtk_signal_connect(GTK_OBJECT(checkbox), "clicked",
		       GTK_SIGNAL_FUNC(sig_autoget_clicked), NULL);
    dcc_options[OPTION_DCC_AUTOGET].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    /* add some space to start of line */
    hbox = gtk_hbox_new(FALSE, 17);
    gtk_object_set_data(GTK_OBJECT(checkbox), "autogetsize", hbox);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new(""), FALSE, FALSE, 0);
    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) dcc_options[OPTION_DCC_AUTOGET_SIZE].data),
                                                0, G_MAXINT, 100, 1000, 0);
    create_spin(hbox, adj, _("Maximum file size to autoget (kB)"), &dcc_options[OPTION_DCC_AUTOGET_SIZE]);

    hbox = gtk_hbox_new(FALSE, 17);
    gtk_object_set_data(GTK_OBJECT(checkbox), "autogetmasks", hbox);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new(""), FALSE, FALSE, 0);
    entry = gui_create_labelentry(hbox, _("Get files only from nicks (masks)"),
                                  *((gchar **) dcc_options[OPTION_DCC_AUTOGET_MASKS].data), TRUE);
    dcc_options[OPTION_DCC_AUTOGET_MASKS].widget = entry;

    entry = gui_create_labelentry(vbox, _("Download path"),
                                  *((gchar **) dcc_options[OPTION_DCC_DOWNLOAD_PATH].data), FALSE);
    dcc_options[OPTION_DCC_DOWNLOAD_PATH].widget = entry;

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) dcc_options[OPTION_DCC_FILE_CREATE_MODE].data),
                                                0, G_MAXINT, 1, 10, 0);
    create_spin(vbox, adj, _("Create files with permission"), &dcc_options[OPTION_DCC_FILE_CREATE_MODE]);


    if (*((gint *) lookandfeel_options[OPTION_DCC_AUTOGET].data) == 0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), FALSE);


    /* --- DCC SEND --- */
    hbox = gtk_hbox_new(FALSE, 10);
    gtk_box_pack_start(GTK_BOX(mainvbox), hbox, FALSE, FALSE, 0);

    frame = gtk_frame_new(_("Transmit"));
    gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Fast send"));
    dcc_options[OPTION_DCC_FAST_SEND].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    entry = gui_create_labelentry(vbox, _("Upload path"),
                                  *((gchar **) dcc_options[OPTION_DCC_UPLOAD_PATH].data), FALSE);
    dcc_options[OPTION_DCC_UPLOAD_PATH].widget = entry;

    /* --- DCC CHAT --- */
    frame = gtk_frame_new(_("Chat"));
    gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Use Mirc style CTCPs by default"));
    dcc_options[OPTION_DCC_MIRC_CTCP].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    entry = gui_create_labelentry(vbox, _("Autochat nick masks"),
                                  *((gchar **) dcc_options[OPTION_DCC_AUTOCHAT_MASKS].data), FALSE);
    dcc_options[OPTION_DCC_AUTOCHAT_MASKS].widget = entry;

    /* --- common --- */
    frame = gtk_frame_new(_("Common"));
    gtk_box_pack_start(GTK_BOX(mainvbox), frame, FALSE, FALSE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Automatically open transfer dialog"));
    dcc_options[OPTION_DCC_AUTODISPLAY_DIALOG].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    /* use specified port */
    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Use specified port for DCC"));
    /* ... -> */
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), TRUE);
    gtk_box_pack_start(GTK_BOX(hbox), checkbox, FALSE, FALSE, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) dcc_options[OPTION_DCC_PORT].data),
                                                0, G_MAXINT, 1, 100, 0);
    spin = create_spin(hbox, adj, "", &dcc_options[OPTION_DCC_PORT]);

    /* <- ... */
    gtk_signal_connect(GTK_OBJECT(checkbox), "clicked",
		       GTK_SIGNAL_FUNC(sig_dccport_clicked), spin);
    if (*((gint *) dcc_options[OPTION_DCC_PORT].data) == 0)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), FALSE);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) dcc_options[OPTION_DCC_TIMEOUT].data),
                                                0, G_MAXINT, 1, 60, 0);
    create_spin(vbox, adj, _("Timeout before rejecting DCC offers"), &dcc_options[OPTION_DCC_TIMEOUT]);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) dcc_options[OPTION_DCC_BLOCK_SIZE].data),
                                                0, G_MAXINT, 512, 5120, 0);
    create_spin(vbox, adj, _("Transfer block size"), &dcc_options[OPTION_DCC_BLOCK_SIZE]);

    setup_finish_init(dialog, dcc_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   mainvbox, gtk_label_new(_("DCC")));
    return TRUE;
}

void init_dcc(void)
{
    signal_add("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_add("setup preferences", (SIGNAL_FUNC) setup_dcc);
}

void deinit_dcc(void)
{
    signal_remove("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_remove("setup preferences", (SIGNAL_FUNC) setup_dcc);
}
