#ifndef __GTK_SPECIFIC_H
#define __GTK_SPECIFIC_H

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include "../nls.h"

#define GNOME_PROPERTY_BOX(a) GTK_WIDGET(a)
#define GNOME_DIALOG(a) GTK_DIALOG(a)
#define GNOME_APP(a) GTK_WIDGET(a)
#define GNOME_FILE_ENTRY(a) GTK_WIDGET(a)
#define GNOME_ENTRY(a) GTK_WIDGET(a)

typedef void (*APPLY_FUNC) (gpointer, gint);

typedef struct
{
    GtkDialog *dialog;

    GtkWidget *notebook;
    GtkWidget *ok_button;
    GtkWidget *apply_button;
    GtkWidget *close_button;

    APPLY_FUNC applyfunc;
    gpointer applyfuncdata;
}
GnomePropertyBox;

/* property box stuff */
GtkWidget *gnome_property_box_new(void);
void gnome_property_box_changed(GtkWidget *box);
void gnome_property_box_set_apply_func(GtkWidget *box, GtkFunction func, gpointer data);
gint gnome_property_box_append_page(GtkWidget *box, GtkWidget *child, GtkWidget *tab_label);
GtkNotebook *gnome_property_box_get_notebook(GtkWidget *box);

typedef struct
{
    gint type;
    gchar *label;
    gchar *hint;
    gpointer moreinfo;
    gpointer user_data;
    gpointer unused;
    gint pixtype;
    gpointer pixmap;
    guint acceleration;
    guint ac_mods;
    GtkWidget *widget;
}
GnomeUIInfo;

typedef enum {
	GNOME_APP_UI_ENDOFINFO,		/* No more items, use it at the end of 
					   an array */
	GNOME_APP_UI_TOGGLEITEM,	/* Toggle (check box) item */
	GNOME_APP_UI_ITEM,		/* Normal item, or radio item if it is
					   inside a radioitems group */
	GNOME_APP_UI_SUBTREE,		/* Item that defines a 
					   subtree/submenu */
	GNOME_APP_UI_SEPARATOR,		/* Separator line (menus) or blank 
					   space (toolbars) */
} GnomeUIInfoType;

typedef enum {
	GNOME_APP_PIXMAP_NONE,		/* No pixmap specified */
	GNOME_APP_PIXMAP_STOCK,		/* Use a stock pixmap (GnomeStock) */
} GnomeUIPixmapType;

/* Used to terminate an array of GnomeUIInfo structures */
#define GNOMEUIINFO_END			{ GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,		\
					  0, NULL, 0, (GdkModifierType) 0, NULL }

/* Insert a separator line (on a menu) or a blank space (on a toolbar) */
#define GNOMEUIINFO_SEPARATOR		{ GNOME_APP_UI_SEPARATOR, NULL, NULL, NULL, NULL, NULL,		\
					  0, NULL, 0, (GdkModifierType) 0, NULL }

#define GNOME_STOCK_MENU_ABOUT        NULL
#define GNOME_STOCK_MENU_QUIT         NULL
#define GNOME_STOCK_MENU_EXIT         NULL
#define GNOME_STOCK_MENU_NEW          NULL
#define GNOME_STOCK_MENU_CLOSE        NULL
#define GNOME_STOCK_MENU_OPEN         NULL
#define GNOME_STOCK_MENU_SAVE         NULL
#define GNOME_STOCK_MENU_PROP         NULL
#define GNOME_STOCK_MENU_PREF         NULL
#define GNOME_STOCK_MENU_COPY         NULL
#define GNOME_STOCK_MENU_CUT          NULL
#define GNOME_STOCK_MENU_PASTE        NULL
#define GNOME_STOCK_MENU_SEARCH       NULL
#define GNOME_STOCK_MENU_JUMP_TO      NULL
#define GNOME_STOCK_MENU_EXEC         NULL
#define GNOME_STOCK_MENU_INDEX        NULL
#define GNOME_STOCK_MENU_BOOK_YELLOW  NULL
#define GNOME_STOCK_MENU_BOOK_BLUE    NULL
#define GNOME_STOCK_MENU_BOOK_OPEN    NULL

#define GNOME_STOCK_PIXMAP_COLORSELECTOR NULL

GtkWidget *gnome_app_new(gchar *id, gchar *title);
void gnome_app_set_contents(GtkWidget *window, GtkWidget *child);

GtkWidget *gnome_popup_menu_new(GnomeUIInfo *uiinfo);
void gnome_popup_menu_attach(GtkWidget *menu, GtkWidget *widget, gpointer data);
void gnome_popup_menu_do_popup(GtkWidget *menu, GtkMenuPositionFunc posfunc, gpointer posdata, GdkEventButton *event, gpointer data);

GtkWidget *gnome_app_find_menu_pos (GtkWidget *parent, gchar *path, gint *pos);
void gnome_app_fill_menu_with_data(GtkMenuShell *menu, GnomeUIInfo *uiinfo, GtkAccelGroup *accel_group, gboolean insert_shortcuts, gint pos, gpointer data);
void gnome_app_remove_from_menu(GtkWidget *menu, gchar *path, gint items);

void gnome_app_create_menus_with_data(GtkWidget *window, GnomeUIInfo *uiinfo, gpointer data);
void gnome_app_insert_menus_with_data(GtkWidget *window, gchar *label, GnomeUIInfo *uiinfo, gpointer data);
void gnome_app_remove_menus(GtkWidget *window, gchar *path, gint items);

void gnome_app_create_toolbar_with_data(GtkWidget *window, GnomeUIInfo *uiinfo, gpointer data);

GtkWidget *gnome_file_entry_new(gchar *id, gchar *title);
gchar *gnome_file_entry_get_full_path(GtkWidget *fileentry, gboolean must_exist);
GtkWidget *gnome_file_entry_gtk_entry(GtkWidget *fileentry);
void gnome_file_entry_set_default_path(GtkWidget *widget, gchar *path);

#define GNOME_STOCK_BUTTON_OK _("OK")
#define GNOME_STOCK_BUTTON_CANCEL _("Cancel")
#define GNOME_STOCK_BUTTON_YES _("Yes")
#define GNOME_STOCK_BUTTON_NO _("No")
#define GNOME_STOCK_BUTTON_CLOSE _("Close")
#define GNOME_STOCK_BUTTON_APPLY _("Apply")

GtkWidget *gnome_dialog_new(gchar *title, ...);
void gnome_dialog_button_connect(GtkDialog *dialog, gint button, GtkSignalFunc func, gpointer data);
void gnome_dialog_button_connect_object(GtkDialog *dialog, gint button, GtkSignalFunc func, GtkObject *object);

GtkWidget *gnome_entry_new(gchar *history_id);
GtkWidget *gnome_entry_gtk_entry(GtkWidget *gentry);

#endif
