/*************************************************************************
 * $Id: tools.c,v 1.6 2001/02/18 07:15:19 dpotter Exp $
 *
 * tools.c -- Some helpful functions
 *
 * Copyright (C) by Andreas Neuhaus <andy@fasta.fh-dortmund.de>
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <string.h>

/*************************************************************************
 * GLOBAL VARIABLES
 */

extern int terminate;

/*************************************************************************
 * READ ONE LINE FROM FD
 */
int readline (int fd, char *buf, int count)
{
	int rc, c;

	buf[0] = 0;
	c = 0;
	do {
		rc = read(fd, buf+c, 1);
		if (rc <= 0)
			return rc-1;
		// CR/LF at beginning of line is ignored.
		if (!c && (*buf == '\r' || *buf == '\n')) {
			break;
		}
		// skip CR and/or LF at end of line
		if (buf[c] == 0 || buf[c] == '\r' || buf[c] == '\n')
			break;
		c++;
	} while (!terminate && c < count);
	buf[c] = 0;

	return c;
}


/*************************************************************************
 * SEND TEXT TO FD
 */
int sendtext (int fd, char *text, ...)
{
	char buf[1024];
	va_list ap;

	va_start(ap, text);
	vsnprintf(buf, sizeof(buf)-1, text, ap);
	buf[sizeof(buf)-1] = 0;
	va_end(ap);

	return write(fd, buf, strlen(buf));
}


/*************************************************************************
 * TRIM BLANKS
 */
char *trimleft (char *str)
{
	char *s = str;
	while (*s==' ' || *s=='\t')
		s++;
	strcpy(str, s);
	return str;
}

char *trimright (char *str)
{
	char *s = str + strlen(str) - 1;
	while (s>=str && (*s==' ' || *s=='\t'))
		*s-- = 0;
	return str;
}

char *trim (char *str)
{
	return trimleft(trimright(str));
}


/*************************************************************************
 * EOF
 */
