/*************************************************************************
 * $Id: config.h,v 1.3 2000/02/07 18:50:39 dpotter Exp $
 *
 * config.h -- Runtime configuration management
 *
 * Copyright (C) by Andreas Neuhaus <andy@fasta.fh-dortmund.de>
 *
 */

#ifndef __CONFIG_H__
#define __CONFIG_H__


/*************************************************************************
 * TYPES
 */
typedef struct config_entry_s {
	char *key;
	char *value;

	struct config_entry_s *next;
} config_entry_t;

extern config_entry_t *config_list;


/*************************************************************************
 * FUNCTIONS
 */
char *config_getstr (char *key, char *defaultvalue);
int config_getnum (char *key, int defaultvalue);

int config_read (char *configfile);
void config_free (void);
void config_reload (void);


#endif /* __CONFIG_H__ */

/*************************************************************************
 * EOF
 */
