/*********************************************************************
 * IP Flow Meter                                                     *
 * http://www.via.ecp.fr/~tibob/ipfm                                 *
 * ipfm@via.ecp.fr                                                   *
 *********************************************************************

 (c) 1999-2000 Robert Cheramy <tibob@via.ecp.fr>
 (c) 2000      Samuel Hocevar <sam@via.ecp.fr>
 (c) 1999      Andres Krapf <dae@via.ecp.fr>

 *********************************************************************
 * This program uses the libpap for best portability.                *
 * libpcap can be found at ftp://ftp.ee.lbl.gov/libpcap.tar.Z        *
 *********************************************************************

 200010xx: sam & tibob : clear and dump options
           sam : PID file & daemon mode handling

 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <stdlib.h>
#include <unistd.h>
// #include <pwd.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <signal.h>

#include "config.h"
#include "utils.h"
#include "pcap.h"
#include "filter.h"
#include "data.h"
#include "init.h"

// struct passwd *runas;
struct AllLogsType * pAllLogs = NULL;
extern int run_as_daemon;

int main(int argc, char *argv[])
{
  struct ip *p_packet;
  struct AllLogsType * pTempLog;
  
  ParseCmdLine(argc, argv);
  
  Init();
  
  if (run_as_daemon) {
    /* Check PID */
    if (check_pid(PIDFILE)) {
      printf ("Already running, exiting.\n");
      exit (1);
    }

    if (1 != getppid()) {
      signal (SIGTTOU, SIG_IGN);
      signal (SIGTTIN, SIG_IGN);
      signal (SIGTSTP, SIG_IGN);
    }
    daemon (0, 0);
    umask (022);

    /* Write PID file */
    if (!write_pid(PIDFILE)) {
      exit (1);
    }
  }
  
  /* Disabled because I can't close the socket as nobody.
     And I don't feel like using threads now :)
  runas = getpwnam("nobody");
  setuid(runas->pw_uid);
  */

  for(;;) {
    p_packet = (struct ip *) getnextippkt();
    
    dofilter(p_packet);

    /* Well that's an approximation. I should perhaps use an alarm() */
    for (pTempLog = pAllLogs; NULL != pTempLog; pTempLog = pTempLog->Next)
    {
      if (time(NULL) > pTempLog->NextDump) {
	data_dump(pTempLog);
        /* Check if we have to clear the logs as well */
        if (pTempLog->ClearInterval) {
          pTempLog->ClearCounter--;
          if (0 >= pTempLog->ClearCounter) {
            data_clear(pTempLog);
            pTempLog->ClearCounter = pTempLog->ClearInterval;
          }
        }
	pTempLog->NextDump += pTempLog->DumpInterval;
      }
    }
  }

  Exit(0);
}
