/***************************************************************************
                        viewXY.h  -  description          
                            -------------------                     
   begin                : Thu Apr 8 1999                    
   copyright            : (C) 1999 by Jonathan E. Anderson           
   email                : janderson@onelink.com            
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef VIEWXY_H
#define VIEWXY_H

#include "glview.h"


/** ViewXY is a XY openGL view.
 *  
 *@author Jonathan E. Anderson
 */

class ViewXY : public GLView
{
      Q_OBJECT
   public:
      ViewXY( QWidget *parent, const char *name = 0, QGLWidget *sharer = 0 );
      virtual ~ViewXY();

      void initView();
      virtual void display();
      virtual void setCamera();
      virtual void setProjection();

      void moveCamera( float x, float y );
      void rotateCamera( float x, float y );
      void zoomCamera( float x, float y );

      int getViewType() { return VXY;};

      void setWireframe2D( bool b );

      virtual void drawBackground();
      void drawGrid();

      Vector4 &unProjectPoint( int x, int y );

      Grid * m_grid;

};

#endif











































































