/***************************************************************************
                          fileplugin.cpp  -  description
                             -------------------
    begin                : Thu Feb 10 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfiledialog.h>

#include <Plugins/fileplugin.h>
#include <Entities/entitylib.h>
#include <Commands/commandlib.h>
#include <iostream.h>

FilePlugin::FilePlugin(QString name, QString ext):PluginBase(name)
{
	setPluginType(IPlugin::FILE);
	extension = ext;
	importable=false;
	exportable=false;
	binary = false;
}
FilePlugin::~FilePlugin()
{
}

void FilePlugin::beginImport()
{
  c = new TransactionCommand();
}

void FilePlugin::addEntity(Entity *e)
{
	c->addCommand(new DBCommand(e, ADD));
}

void FilePlugin::endImport()
{
  c->execute();
  c->save();
  I3D::updateViews();
}

void FilePlugin::fileExport()
{
  QString f = QFileDialog::getSaveFileName( 0, "*."+extension, 0 );
	if (f.isEmpty() )
		return;
	
	ofstream *out;
		
	if(binary)
		out = new ofstream(f.ascii(), ios::out | ios::binary);
	else
		out = new ofstream(f.ascii(), ios::out);
	
	if(!(*out))
		return;
	
	exportData(*out);	
	out->close();
	delete out;

}

void FilePlugin::fileImport()
{
  QString f = QFileDialog::getOpenFileName( 0, "*."+extension, 0 );
	if (f.isEmpty() )
		return;

	ifstream *in;
		
	if(binary)
		in = new ifstream(f.ascii(), ios::in | ios::binary);
	else
		in = new ifstream(f.ascii(), ios::in);
	
	if(!(*in))
		return;
	
	
	beginImport();
	importData(*in);	
	endImport();
	in->close();
	delete in;
}

bool FilePlugin::isExportable()
{
 return exportable;
}
bool FilePlugin::isImportable()
{
	return importable;
}

bool FilePlugin::isBinary()
{
	return binary;
}

void FilePlugin::setImportable(bool f)
{
	importable = f;
}
void FilePlugin::setExportable(bool f)
{
 exportable = f;
}
void FilePlugin::setBinary(bool f)
{
	binary = f;
}
