/***************************************************************************
                         splinemodifier.cpp  -  description
                            -------------------
   begin                : Mon Apr 23 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "splinemodifier.h"
#include "crevolvedlg.h"

#include <Entities/spline.h>
#include <Entities/nurbscurve.h>
#include <Entities/polyskin.h>
#include <Entities/mesh.h>
#include <Entities/nurbssurface.h>
#include "modetoolbar.h"
#include "psplinedlg.h"

#include <i3d.h>
#include <i3dworkspace.h>


#define BEGIN(c,n) \
  if(assertSelected(n)){ \
    setStatus( c ); \
    TransactionCommand *tc = new TransactionCommand(); \
    SelectionIterator it = m_selection -> begin(); \
    while( it != m_selection -> end() ) {\
      CheckPointCmd *pc = new CheckPointCmd( static_cast<Entity *> (*it ) );

#define END() \
      tc -> addCommand( pc ); \
      ++it; \
    } \
    tc -> save(); \
    setStatusDone(); \
  } \
  updateViews();

#define SPLINE() static_cast<Spline *>( *it )


int SplineModifier::TYPE = IControl::getUID();

SplineModifier::SplineModifier() : ObjectModifier( "Splines", Spline::TYPE )
{
   setName( "&Splines" );
   m_popup -> insertSeparator( );
   m_popup -> insertItem( "Reverse", this, SLOT( slotReverse() ) );
   m_popup -> insertItem( "Revolve", this, SLOT( slotRevolve() ) );
   m_popup -> insertItem( "Custom Revolve", this, SLOT( slotCustomRevolve() ) );
   m_popup -> insertItem( "Sweep", this, SLOT( slotSweep() ) );
   m_popup -> insertItem( "Skin", this, SLOT( slotSkin() ) );
	 m_popup -> insertSeparator();
 	 m_popup -> insertItem( "Properties", this, SLOT( slotProperties() ) );


}

SplineModifier::~SplineModifier()
{
}


void SplineModifier::activate()
{
   clearSelection();
   I3D::getWorkspace() -> setCurrentControl( this );
   I3D::setModeMsg( " Spline Mode " );
   SelectMode::set( Spline::TYPE );
   //change to select mode immediately.
   ModeToolbar::setMode( ModeToolbar::MODE_SELECT );

   updateViews();
}

void SplineModifier::deactivate()
{}

void SplineModifier::slotReverse()
{
   BEGIN( "Reversing Splines...", 1 );
   SPLINE() -> reverse();
   END();
}


void SplineModifier::slotSkin()
{

   if ( assertSelected( 2 ) )
   {

      setStatus( "Skinning splines..." );

      Entity *e;

      vector<Spline *> splines;

      SelectionIterator it = m_selection -> begin();

      while ( it != m_selection -> end() )
      {

         Spline * s = static_cast<Spline *>( *it );
         splines.push_back( s );
         ++it;

      }


      PolySkin ps;

      bool curves = true;

      for ( int i = 0; i < ( int ) splines.size(); i++ )
      {
         if ( ! splines[ i ] -> isA( NurbsCurve::TYPE ) )
         {
            curves = false;
            break;
         }
      }

      if ( curves )
      {
         cerr << "All curves" << endl;
         e = ps.getSurface( splines );
      }

      else
         e = ps.getMesh( splines );

      DBCommand *dc = new DBCommand( e, ADD );

      dc->execute();

      dc->save();

      updateViews();

      setStatusDone();
   }
}

void SplineModifier::slotCustomRevolve()
{
   if ( assertSelectedExactly( 2 ) )
   {

      setStatus( "Revolving splines..." );

      CRevolveDlg *dlg = new CRevolveDlg( 0, "Custom Revolve", true );

      if ( dlg -> exec() )
      {
         SelectionIterator it = m_selection -> begin();

         Spline *profile = static_cast<Spline *>( *it );
         ++it;
         Spline *path = static_cast<Spline *>( *it );


         Entity *e = path -> revolve( *profile, dlg -> getDegrees(), dlg -> getSegments() );

         DBCommand *dc = new DBCommand( e, ADD );
         dc->execute();
         dc->save();
      }

      setStatusDone();

   }

   updateViews();
}

void SplineModifier::slotRevolve()
{
   if ( assertSelectedExactly( 2 ) )
   {

      setStatus( "Revolving splines..." );
      SelectionIterator it = m_selection -> begin();

      Spline *profile = static_cast<Spline *>( *it );
      ++it;
      Spline *path = static_cast<Spline *>( *it );


      Entity *e = path -> revolve( *profile, 360, 16 );

      DBCommand *dc = new DBCommand( e, ADD );
      dc->execute();
      dc->save();

      setStatusDone();

   }

   updateViews();

}

void SplineModifier::slotSweep()
{

   if ( assertSelectedExactly( 2 ) )
   {

      setStatus( "Revolving splines..." );
      SelectionIterator it = m_selection -> begin();

      Spline *profile = static_cast<Spline *>( *it );
      ++it;
      Spline *path = static_cast<Spline *>( *it );


      Entity *e = profile -> sweep( *path );

      DBCommand *dc = new DBCommand( e, ADD );
      dc->execute();
      dc->save();

      setStatusDone();
   }

   updateViews();

}

void SplineModifier::slotProperties()
{
 if ( assertSelected( 1 ) )
   {

   setStatus( "Editing properties..." );

   /* Popup custom dialog here.
    */
   PSplineDlg *dlg = new PSplineDlg( 0, "Spline Properties", true );

   SelectionIterator it = m_selection -> begin();

   dlg -> setEnableAll( true );
   dlg -> setSpline( static_cast<Spline *>( *it ) );

   if ( dlg -> exec() )
   {
      cerr << "Done with properties " << endl;
      Spline *m = static_cast<Spline *>( *it );
      CheckPointCmd *pc = new CheckPointCmd( m );
      pc -> save();
      Vector4 pos = dlg -> getPosition();
      Quat ori = dlg -> getOrientation();

      m -> setName( dlg -> getName() );
      m -> setNotes( dlg -> getNotes() );
      m -> setPosition( pos );
      m -> setOrientation( ori );

      updateViews();
      setStatusDone();
   }

   else
   {
      updateViews();
      setStatusDone();
   }
   }
}
