/***************************************************************************
                         edgemodifier.cpp  -  description
                            -------------------
   begin                : Mon Apr 23 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "edgemodifier.h"
#include <Entities/edge.h>
#include <Entities/mesh.h>

#include <i3d.h>
#include <i3dworkspace.h>
#include "modetoolbar.h"

#define BEGINEXACT(c,x) \
  if( assertSelectedExactly(x) && assertSameParent() ) { \
    setStatus( c ); \
    Mesh *m = getSubObjectParent(); \
    vector<int> zzlist = getSubObjectList(); \
    CheckPointCmd *chc = new CheckPointCmd( m );


#define BEGIN(c,x) \
  if( assertSelected(x) && assertSameParent() ) { \
    setStatus( c ); \
    Mesh *m = getSubObjectParent(); \
    vector<int> zzlist = getSubObjectList(); \
    CheckPointCmd *chc = new CheckPointCmd( m );

#define END() \
    chc -> save(); \
    setStatusDone(); \
  } \
  updateViews();

#define SUBOBJECTS() zzlist

int EdgeModifier::TYPE = IControl::getUID();

EdgeModifier::EdgeModifier() : SubObjectModifier( Edge::TYPE )
{
   setName( "&Edges" );
   m_popup -> insertSeparator();
   m_popup -> insertItem( "Divide", this, SLOT( slotDivide() ) );
   m_popup -> insertItem( "Connect", this, SLOT( slotConnect() ) );
   m_popup -> insertItem( "Loop", this, SLOT( slotLoop() ) );
   m_popup -> insertItem( "Delete", this, SLOT( slotDelete() ) );
   m_popup -> insertSeparator();
   m_popup -> insertItem( "Bevel", this, SLOT( slotBevel() ) );
   m_popup -> insertItem( "Extrude", this, SLOT( slotExtrude() ) );
   m_popup -> insertSeparator();
   m_popup -> insertItem( "Toggle Hardness", this, SLOT( slotToggleHardness() ) );

}

EdgeModifier::~EdgeModifier()
{}

void EdgeModifier::activate()
{
   clearSelection();
   I3D::getWorkspace() -> setCurrentControl( this );
   I3D::setModeMsg( " Edge Mode " );
   SelectMode::set( Edge::TYPE );
   //change to select mode immediately.
   ModeToolbar::setMode( ModeToolbar::MODE_SELECT );

   updateViews();
}

void EdgeModifier::deactivate()
{
}

void EdgeModifier::slotConnect()
{

   BEGIN( "Connecting edges...", 2 );
   getSubObjectParent() -> connectEdges( SUBOBJECTS() );
   END();
   clearSelection();

}

void EdgeModifier::slotLoop()
{
   BEGIN( "Connecting edges...", 3 );
   getSubObjectParent() -> loopEdges( SUBOBJECTS() );
   END();

}

void EdgeModifier::slotDivide()
{

   BEGIN( "Dividing edges...", 1 );
   getSubObjectParent() -> divideEdges( SUBOBJECTS() );
   END();
   clearSelection();
}

void EdgeModifier::slotExtrude()
{
   Vector4 p;
   BEGINEXACT( "Extruding edges...", 1 );
   getSubObjectParent() -> extrudeEdges( SUBOBJECTS(), p );
   END();

   slotMoveMode();

}

void EdgeModifier::slotToggleHardness()
{
   BEGIN( "Toggling hardness...", 1 );
   getSubObjectParent() -> toggleEdgeHardness( SUBOBJECTS() );
   END();

}

void EdgeModifier::slotBevel()
{

   BEGINEXACT( "Beveling edges...", 1 );
   getSubObjectParent() -> bevelEdges( SUBOBJECTS(), 1 );
   END();

   clearSelection();
}

void EdgeModifier::slotDelete()
{

   BEGIN( "Deleting edges...", 1 );
   getSubObjectParent() -> deleteEdges( SUBOBJECTS() );
   END();

   clearSelection();
}

