#ifndef CMESHDLG_H
#define CMESHDLG_H

#include "icmeshdlg.h"

#include <qlabel.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qfiledialog.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qmultilineedit.h>

class CMeshDlg : public ICMeshDlg
{
      Q_OBJECT

   public:

      enum { CUBE, SPHERE, HEIGHTMAP, CYLINDER, PLANE };

      CMeshDlg( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
      ~CMeshDlg();

      void enable( bool, bool, bool, bool );
      void setLabels( char *, char *, char * );
      void setValues( int, int, int );

      int getA() { return spnA -> value(); };
      int getB() { return spnB -> value(); };
      int getC() { return spnC -> value(); };
      int getD() { return spnD -> value(); };
      int getE() { return spnE -> value(); };
      int getF() { return spnF -> value(); };

      int getType() { return chType -> currentItem(); };

      QString getFileName() { return fldFile -> text(); };

      QString getName() { return fldName -> text(); };

      QString getNotes() { return fldNotes -> text(); };

   public slots:
      void slotAccept();
      void slotBrowse();
      void slotTypeChanged( int );

};

#endif // CMESHDLG_H
