/***************************************************************************
                         keyframe.h  -  description                              
                            -------------------                                         
   begin                : Sat Aug 14 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KEYFRAME_H
#define KEYFRAME_H

#include <list>

//Math
#include <Math/vector4.h>

/** A channel is an ecapsulation of an attribute, id pair.
  */

class Channel
{
   public:
      Channel( int s, const Vector4 &p ) {m_channel_id = s; value = p;};

      int m_channel_id;
      Vector4 value;
};

/**A Keyframe is a snapshot of the state of the entity for a time.
 *It basically provides as as fast as possible lookup of a collection
 *of attributes, such as position, orientation
 *color, texture coords, texture maps, etc...
 *@author Jonathan E. Anderson
 */

class Keyframe
{
   public:

      Keyframe( int time = 1 );
      Keyframe( const Keyframe & );
      ~Keyframe();

      void set( int s, const Vector4 &v );
      Vector4 get( int s );

      void setTime( int t ) { time = t;};

      int getTime() { return time;};

      void save();
      void open();

      bool operator<( const Keyframe &f );
      bool operator<=( const Keyframe &f );
      bool operator==( const Keyframe &f );
      Keyframe & operator=( const Keyframe &f );

   private:
      void copy( const Keyframe &s );


   private:
      list<Channel> channels;
      int time;


};


#endif













