/***************************************************************************
                         cylinder.cpp  -  description                              
                            -------------------                                         
   begin                : Sun Sep 26 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cylinder.h"
#include "vertex.h"
#include "face.h"

Cylinder::Cylinder( float x = 0, float y = 0, float z = 0, float hx = 0, float hy = 0, float hz = 0 )
      : Mesh( x, y, z )
{
   //create mesh here.
   //create along the y-axis, then rotate it.
   //hz is the radius.
   //hy is both the height,and the number of segments.
   //hx is the number of times around.

   //center vertices for the caps.
   Vertex * tv = createVertex( 0, hy / 2, 0 );
   Vertex *bv = createVertex( 0, -hy / 2, 0 );

   float seg_amount = 2 * M_PI / hx;

   vector<VertexList > segs;

   segs.reserve( ( int ) hx + 1 );
   //create the vertices
   for ( float i = 0; i < hx; i++ )
   {
      float rad1 = seg_amount * i;
      VertexList vlist;
      vlist.reserve( hy );

      for ( float j = -hy / 2; j <= hy / 2; j++ )
      {
         //rotate about the y axis;
         float x = cos( rad1 ) * hz;
         float z = sin( rad1 ) * hz;
         Vertex *v1 = createVertex( x, j, z );
         vlist.push_back( v1 );
      }

      segs.push_back( vlist );
   }

   segs.push_back( segs[ 0 ] );



   for ( int i = 0; i < hx; i++ )
   {
      createFace( bv->getParentIndex(),
                  segs[ i ][ 0 ] ->getParentIndex(),
                  segs[ i + 1 ][ 0 ] ->getParentIndex() );

      for ( int j = 0; j < hy; j++ )
      {
         createFace( segs[ i + 1 ][ j ] ->getParentIndex(),
                     segs[ i ][ j ] ->getParentIndex(),
                     segs[ i ][ j + 1 ] ->getParentIndex(),
                     segs[ i + 1 ][ j + 1 ] ->getParentIndex() );
      }

      createFace( tv->getParentIndex(),
                  segs[ i + 1 ][ hy ] ->getParentIndex(),
                  segs[ i ][ hy ] ->getParentIndex() );
   }


   normalize();


}

Cylinder::~Cylinder()
{}

