/***************************************************************************
                         boundingbox.cpp  -  description
                            -------------------
   begin                : Tue Jan 4 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "boundingbox.h"

BoundingBox::BoundingBox() :
      min( 0, 0, 0, 0 ),
      max( 0, 0, 0, 0 ),
      m_color( 0, 0, 1, 1 )
{
}

BoundingBox::~BoundingBox()
{
}

void BoundingBox::setColor( Vector4 & p_color )
{
   m_color = p_color;
}

void BoundingBox::move( Vector4 &v )
{
   min += v;
   max += v;
}

void BoundingBox::rotate( Vector4 &v )
{
}

void BoundingBox::scale( Vector4 &v )
{
}

void BoundingBox::setBounds( Vector4 &_min, Vector4 &_max )
{
   min = _min;
   max = _max;
   y3 = ( max.y - min.y ) / 3;
   x3 = ( max.x - min.x ) / 3;
   z3 = ( max.z - min.z ) / 3;
}

/** Determines if a point is contained within
  * the bounding box.
  */
bool BoundingBox::contains( Vector4 &p )
{
   if ( p.x < min.x || p.x > max.x )
      return false;

   if ( p.y < min.y || p.y > max.y )
      return false;

   if ( p.z < min.z || p.z > max.z )
      return false;

   return true;

}

void BoundingBox::draw( int d_options = 0 )
{

   glPushMatrix();
   glPushAttrib( GL_LIGHTING_BIT | GL_COLOR_BUFFER_BIT | GL_TEXTURE_BIT );
   glDisable( GL_LIGHTING );
   glDisable( GL_TEXTURE_2D );
   glColor4f( m_color.x, m_color.y, m_color.z, m_color.w );
   glBegin( GL_LINES ); //front
   //min corner
   glVertex3f( min.x, min.y, min.z );
   glVertex3f( min.x + x3, min.y, min.z );

   glVertex3f( min.x, min.y, min.z );
   glVertex3f( min.x, min.y + y3, min.z );

   glVertex3f( min.x, min.y, min.z );
   glVertex3f( min.x, min.y, min.z + z3 );

   //max X,min all
   glVertex3f( max.x, min.y, min.z );
   glVertex3f( max.x - x3, min.y, min.z );

   glVertex3f( max.x, min.y, min.z );
   glVertex3f( max.x, min.y + y3, min.z );

   glVertex3f( max.x, min.y, min.z );
   glVertex3f( max.x, min.y, min.z + z3 );

   //max X,Max Y min z
   glVertex3f( max.x, max.y, min.z );
   glVertex3f( max.x - x3, max.y, min.z );

   glVertex3f( max.x, max.y, min.z );
   glVertex3f( max.x, max.y - y3, min.z );

   glVertex3f( max.x, max.y, min.z );
   glVertex3f( max.x, max.y, min.z + z3 );

   //max X,Max Y max z
   glVertex3f( max.x, max.y, max.z );
   glVertex3f( max.x - x3, max.y, max.z );

   glVertex3f( max.x, max.y, max.z );
   glVertex3f( max.x, max.y - y3, max.z );

   glVertex3f( max.x, max.y, max.z );
   glVertex3f( max.x, max.y, max.z - z3 );

   //min X max Y min Z
   glVertex3f( min.x, max.y, min.z );
   glVertex3f( min.x + x3, max.y, min.z );

   glVertex3f( min.x, max.y, min.z );
   glVertex3f( min.x, max.y - y3, min.z );

   glVertex3f( min.x, max.y, min.z );
   glVertex3f( min.x, max.y, min.z + z3 );

   //min X min Y max Z
   glVertex3f( min.x, min.y, max.z );
   glVertex3f( min.x + x3, min.y, max.z );

   glVertex3f( min.x, min.y, max.z );
   glVertex3f( min.x, min.y + y3, max.z );

   glVertex3f( min.x, min.y, max.z );
   glVertex3f( min.x, min.y, max.z - z3 );

   //max X min Y max Z
   glVertex3f( max.x, min.y, max.z );
   glVertex3f( max.x - x3, min.y, max.z );

   glVertex3f( max.x, min.y, max.z );
   glVertex3f( max.x, min.y + y3, max.z );

   glVertex3f( max.x, min.y, max.z );
   glVertex3f( max.x, min.y, max.z - z3 );

   //min X max Y max Z
   glVertex3f( min.x, max.y, max.z );
   glVertex3f( min.x + x3, max.y, max.z );

   glVertex3f( min.x, max.y, max.z );
   glVertex3f( min.x, max.y - y3, max.z );

   glVertex3f( min.x, max.y, max.z );
   glVertex3f( min.x, max.y, max.z - z3 );
   glEnd();
   glPopAttrib();
   glPopMatrix();

}
