/***************************************************************************
                          MD2file.h  -  description
                             -------------------
    begin                : Sun Aug 20 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MD2FILE_H
#define MD2FILE_H

#include "Plugins/fileplugin.h"


typedef struct
{
	int magic;
	int version;
	int skinWidth;
	int skinHeight;
	int frameSize;
	int numSkins;
	int numVertices;
	int numTexCoords;
	int numTriangles;
	int numGlCommands;
	int numFrames;
	int offsetSkins;
	int offsetTexCoords;
	int offsetTriangles;
	int offsetFrames;
	int offsetGlCommands;
	int offsetEnd;
} model_t;

typedef struct
{
	unsigned char vertex[3];
	unsigned char lightNormalIndex;
} vertex_t;



typedef struct
{
	short vertexIndices[3];
	short textureIndices[3];

} triangle_t;
		
typedef struct
{
	short s, t;
} tcoord_t;

typedef struct
{
	float s, t;
	int vertexIndex;
} glCommandVertex_t;

typedef struct
	{
		float scale[3];
		float translate[3];
		char name[16];
//		vertex_t verts[header.numVertices];
} frame_t;
/**
  *@author Jon Anderson
  */

class MD2File : public FilePlugin  {
public: 
	MD2File();
	~MD2File();
	
	void importData(ifstream &);
	void exportData(ofstream &);

protected:
	void createObject();

	void readHeader(ifstream &);
	void writeHeader(ofstream &);
	
	void readFrames(int offset, ifstream &);
	void readTexCoords(int offset, ifstream &);
	void readTriangles(int offset, ifstream &);
	void readSkins(int offset, ifstream &);
	void readGlCommands(int offset, ifstream &);

	vector<Vector4> uvs;
	vector< vector<Vector4> > verts;
	vector<triangle_t> triangles;
	model_t header;
	Object *o;

};

#endif
