#!/usr/bin/python

"""
Module Nmap Fingerprinting for Inguma
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""

"""
NOTE: It works depending on the moon.
"""

import os
import sys

from lib.libexploit import CIngumaModule

try:
    if os.name == "nt":
        import winscapy as scapy
    else:
        import scapy

    hasScapy = True
except:
    hasScapy = False

name = "nmapfp"
brief_description = "Os detect with Nmap fingerprinting"
type = "gather"

globals = ["oport", "cport"]

class CNmapFp(CIngumaModule):

    target = ""  # Main target
    port = 0 # Port to be used
    waitTime = 0 # Time to wait between step and step
    timeout = 1 # Default timeout
    exploitType = 1
    services = {}
    results = {}
    dict = None
    oport = 80
    cport = 81

    def help(self):
        print "target = <target host or network>"
        print "oport = <opened port>"
        print "cport = <closed port>"

    def run(self):
        if not hasScapy:
            print "[!] No scapy support :( "
            return False
        
        res = scapy.nmap_fp(target=self.target, oport = self.oport, cport = self.cport)
        self.accuracy = res[0]
        data = res[1]
        self.results = data

        return True

    def printSummary(self):
        print "Possible Operative System List"
        print "------------------------------"
        print
        for os in self.results:
            print "  " + os
        
        print 
        print 'Accuracy: %f' % (self.accuracy * 100) + " %"
        print
