/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * OutputTable.java
 *
 * Created on Mar 5, 2011, 10:02:17 PM
 */
package com.ggasoftware.indigo.chemdiff;

import com.ggasoftware.indigo.IndigoException;
import com.ggasoftware.indigo.IndigoObject;
import com.ggasoftware.indigo.controls.*;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

/**
 *
 * @author achurinov
 */
public class OutputTable extends TitledBorderPanel
{
   private ArrayList<? extends RenderableObjectWithId> _molecules;
   private String _common_canonical_code;
   private CanonicalCodeGenerator _canonical_generator;

   public OutputTable ()
   {
      initComponents();
   }

   public void setIdColumnCount (int count)
   {
      molecules_table.setIdColumnCount(count);
   }
   
   public int getIdColumnCount ()
   {
      return molecules_table.getIdColumnCount();
   }
   
   public void setCommonCanonicalCode (String code)
   {
      _common_canonical_code = code;
   }

   public void setCanonicalCodeGenerator (CanonicalCodeGenerator canonical_generator)
   {
      _canonical_generator = canonical_generator;
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   @SuppressWarnings("unchecked")
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {
      java.awt.GridBagConstraints gridBagConstraints;

      molecules_table = new com.ggasoftware.indigo.chemdiff.MoleculeTableWithIdPanel();
      save_button = new javax.swing.JButton();
      filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0), new java.awt.Dimension(32767, 0));
      filler2 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0), new java.awt.Dimension(32767, 0));

      setLayout(new java.awt.GridBagLayout());

      molecules_table.addTableCellMouseListener(new com.ggasoftware.indigo.controls.TableCellMouseListener() {
         public void cellMouseDoubleClick(com.ggasoftware.indigo.controls.TableCellMouseEvent evt) {
            molecules_tableCellMouseDoubleClick(evt);
         }
         public void cellShowPopupMenu(com.ggasoftware.indigo.controls.TableCellMouseEvent evt) {
            molecules_tableCellShowPopupMenu(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.gridwidth = 3;
      gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints.ipadx = 200;
      gridBagConstraints.ipady = 100;
      gridBagConstraints.weightx = 1.0;
      gridBagConstraints.weighty = 1.0;
      add(molecules_table, gridBagConstraints);

      save_button.setText("Save");
      save_button.setMargin(new java.awt.Insets(2, 30, 2, 30));
      save_button.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            save_buttonActionPerformed(evt);
         }
      });
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
      add(save_button, gridBagConstraints);
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.weightx = 1.0;
      add(filler1, gridBagConstraints);
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.weightx = 1.0;
      add(filler2, gridBagConstraints);
   }// </editor-fold>//GEN-END:initComponents

    private void molecules_tableCellMouseDoubleClick (com.ggasoftware.indigo.controls.TableCellMouseEvent evt)//GEN-FIRST:event_molecules_tableCellMouseDoubleClick
    {//GEN-HEADEREND:event_molecules_tableCellMouseDoubleClick
      RenderableObjectWithId item = _molecules.get(evt.row);
      showMolecule(item);
    }

   private void showSingleMolecule (RenderableObjectWithId item, 
           boolean normalized, String canonical_code)
   {
      Frame parent = (Frame)getTopLevelAncestor();
      IndigoObject obj = item.getRenderableObject();
      if (obj == null)
      {
         String message = String.format("Exception:\n%s", item.getErrorMessageToRender());
         MessageBox.show(parent, message, 
                 "Error during loading this molecule", MessageBox.ICON_ERROR);
         return;
      }
      if (normalized)
      {
         try
         {
            obj = _canonical_generator.createPreparedObject(obj);
         }
         catch (IndigoCheckedException ex)
         {
            MessageBox.show(parent, ex.getMessage(), 
                    "Error during normalizing this molecule", MessageBox.ICON_ERROR);
            return;
         }
         try
         {
            obj.markEitherCisTrans();
         }
         catch (IndigoException ex)
         {
         }
      }
      // Show details window for single molecule
      SingleIndigoObjectWindow details = new SingleIndigoObjectWindow(parent, 
              obj, item.getIndigoRenderer(), false);
      if (item.getErrorMessageToRender() != null)
         details.setInformationMessage(item.getErrorMessageToRender());
      else
         details.setInformationMessage(canonical_code);
      String title = item.getId(0);
      if (normalized)
         title += " (normalized)";
      details.setTitle(title);
      details.setVisible(true);
      
   }
   
   private void showMolecule (RenderableObjectWithId item)
   {
      Frame parent = (Frame)getTopLevelAncestor();
      MoleculeItem single = null;
      MultipleMoleculeItem mul_item = null;
      String canonical_code;
      if (item instanceof MoleculeItem)
      {
         single = (MoleculeItem)item;
         canonical_code = _common_canonical_code;
      }
      else
      {
         mul_item = (MultipleMoleculeItem)item;
         if (mul_item.isSingleMolecule())
            single = mul_item.getGroup(0).get(0);
         canonical_code = mul_item.getCanonicalCode();
      }
      if (single != null)
         showSingleMolecule(item, false, canonical_code);
      else
      {
         // Show window with multiple molecules
         MultipleMoleculeWindow details = new MultipleMoleculeWindow(parent, mul_item);
         details.setCommonCanonicalCode(canonical_code);
         details.setRowHeight(getRowHeight());
         details.setCanonicalCodeGenerator(_canonical_generator);
         details.setVisible(true);
      }
    }//GEN-LAST:event_molecules_tableCellMouseDoubleClick

    private void molecules_tableCellShowPopupMenu (com.ggasoftware.indigo.controls.TableCellMouseEvent evt)//GEN-FIRST:event_molecules_tableCellShowPopupMenu
    {//GEN-HEADEREND:event_molecules_tableCellShowPopupMenu
      final TableCellMouseEvent evt_final = evt;
      
      JPopupMenu _popup_menu = new JPopupMenu();
      JMenuItem show_mi = new JMenuItem("Open in a new window");
      show_mi.addActionListener(new ActionListener()
      {
         public void actionPerformed (ActionEvent e)
         {
            molecules_tableCellMouseDoubleClick(evt_final);
         }
      });
      _popup_menu.add(show_mi);
      JMenuItem show_normalized_mi = new JMenuItem("Show normalized molecule");
      show_normalized_mi.addActionListener(new ActionListener()
      {
         public void actionPerformed (ActionEvent e)
         {
            RenderableObjectWithId item = _molecules.get(evt_final.row);
            String canonical_code;
            if (item instanceof MoleculeItem)
               canonical_code = _common_canonical_code;
            else
               canonical_code = ((MultipleMoleculeItem)item).getCanonicalCode();
            showSingleMolecule(item, true, canonical_code);
         }
      });
      _popup_menu.add(show_normalized_mi);
      
      _popup_menu.show((Component)evt.mouse_event.getSource(), evt.mouse_event.getX(), evt.mouse_event.getY());
    }//GEN-LAST:event_molecules_tableCellShowPopupMenu

    private void save_buttonActionPerformed (java.awt.event.ActionEvent evt)//GEN-FIRST:event_save_buttonActionPerformed
    {//GEN-HEADEREND:event_save_buttonActionPerformed
       // TODO: save with progress bar!
       // TODO: if no properties then add ID
       if (_molecules.isEmpty())
       {
          JOptionPane.showMessageDialog(this, "Set is empty");
          return;
       }
       MolSaver saver = new MolSaver(Global.indigo);
       saver.addExtension("cml");
       saver.addExtension("smi");
       saver.addExtension("sdf", "sd");
       String s = saver.saveMols(_molecules);

       ArrayList<RenderableObject> invalid = saver.getInvalidObjects();
       if (!invalid.isEmpty())
       {
          StringBuilder error_messages = new StringBuilder();
          for (RenderableObject abstract_obj : invalid)
          {
             RenderableObjectWithId obj = (RenderableObjectWithId)abstract_obj;
             error_messages.append(String.format("%s: %s\n",
                     obj.getId(0), obj.getErrorMessageToRender()));
          }

          Frame parent = (Frame)getTopLevelAncestor();
          String message = String.format("Cannot save the following molecules:\n%s", 
                  error_messages.toString());
          MessageBox.show(parent, message, "Some molecules cannot be saved", MessageBox.ICON_WARNING);
       }
    }//GEN-LAST:event_save_buttonActionPerformed

   public void clear ()
   {
      molecules_table.clear();
   }

   public void setMolecules (ArrayList<? extends RenderableObjectWithId> molecules)
   {
      _molecules = molecules;
      molecules_table.setObjects(_molecules);
      
      int errors_count = 0;
      for (RenderableObjectWithId obj: molecules)
         if (obj.getErrorMessageToRender() != null)
            errors_count++;
      
      StringBuilder subtitle = new StringBuilder();
      subtitle.append(String.format(": %d molecule%s", molecules.size(),
              molecules.size() != 1 ? "s" : ""));
      if (errors_count != 0)
         subtitle.append(String.format(" (with %d not valid)", errors_count));
      setSubtitle(subtitle.toString());
   }

   public void setRowHeight (int height)
   {
      molecules_table.setRowHeight(height);
   }
   
   public int getRowHeight ()
   {
      return molecules_table.getRowHeight();
   }
   
   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.Box.Filler filler1;
   private javax.swing.Box.Filler filler2;
   private com.ggasoftware.indigo.chemdiff.MoleculeTableWithIdPanel molecules_table;
   private javax.swing.JButton save_button;
   // End of variables declaration//GEN-END:variables
}
