-- date_before()
function date_before(days)
    check_type(days, 'number')

    return os.date("%d-%b-%Y", os.time() - days * 60 * 60 * 24)
end


-- get_pass()
function get_pass(prompt)
    if (prompt ~= nil) then
	check_type(prompt, 'string')
	io.write(prompt)
    else
	io.write('Password: ')
    end

    ifsys.noecho()
    local pass = io.read()
    ifsys.echo()

    return pass
end


-- pipe_to()
function pipe_to(command, data)
    check_type(command, 'string')
    check_type(data, 'string')

    f = ifsys.popen(command, "w")

    ifsys.write(f, data)

    return ifsys.pclose(f)
end


-- pipe_from()
function pipe_from(command)
    check_type(command, 'string')

    f = ifsys.popen(command, "r")

    local string = ''
    while (true) do
	s = ifsys.read(f)
	if (s ~= nil) then
	    string = string .. s
	else
	    break
	end
    end

    return ifsys.pclose(f), string
end


-- daemon_mode()
function daemon_mode(interval, commands)
    check_type(interval, 'number')
    check_type(commands, 'function')

    ifsys.daemon()

    repeat
	pcall(commands)
    until (ifsys.sleep(interval) ~= 0)
end
