/* $Id: im-register-trigger-keys.c,v 1.1.1.1 2002/08/31 04:18:06 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_register_trigger_keys_new(
    IIIMP_data_s *		data_s,
    IIIMP_card16		im_id,
    IIIMP_keyevent_list *	trigger_on,
    IIIMP_keyevent_list *	trigger_off)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_REGISTER_TRIGGER_KEYS;
    m->im_id = im_id;
    m->ic_id = -1;
    m->v.register_trigger_keys.trigger_on = trigger_on;
    m->v.register_trigger_keys.trigger_off = trigger_off;
    return m;
}



void
iiimp_register_trigger_keys_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_keyevent_list_delete(data_s, m->v.register_trigger_keys.trigger_on);
    iiimp_keyevent_list_delete(data_s, m->v.register_trigger_keys.trigger_off);
    free(m);
}


uchar_t *
iiimp_register_trigger_keys_pack(
    IIIMP_data_s *		data_s,
    IIIMP_card16		im_id,
    IIIMP_keyevent_list *	trigger_on,
    IIIMP_keyevent_list *	trigger_off,
    size_t *			buf_size)
{
    size_t			nbyte;
    int				length;
    uchar_t *			buf;
    size_t			rest;
    uchar_t *			p;

    nbyte = 0;
    nbyte += 2;				/* input method id */
    nbyte += 2;				/* PAD(2) */
    nbyte += 4;				/* byte length of on-keys */
    if (NULL != trigger_on) {
	nbyte += trigger_on->nbyte;	/* trigger keys to turn on */
    }
    nbyte += 4;				/* byte length of off-keys */
    if (NULL != trigger_off) {
	nbyte += trigger_off->nbyte;	/* trigger keys to turn off */
    }

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_REGISTER_TRIGGER_KEYS, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(0, rest, p, data_s->byte_swap);
    if (NULL == trigger_on) {
	PUTU32(0, rest, p, data_s->byte_swap);
    } else {
	PUTU32(trigger_on->nbyte, rest, p, data_s->byte_swap);
	iiimp_keyevent_list_pack(data_s, trigger_on, &rest, &p);
    }
    if (NULL == trigger_off) {
	PUTU32(0, rest, p, data_s->byte_swap);
    } else {
	PUTU32(trigger_off->nbyte, rest, p, data_s->byte_swap);
	iiimp_keyevent_list_pack(data_s, trigger_off, &rest, &p);
    }

    return buf;
}


IIIMP_message *
iiimp_register_trigger_keys_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *			m;
    IIIMP_register_trigger_keys_v *	v;
    size_t				rest;
    const uchar_t *			p;
    int					len;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4 + 0 + 4 + 0)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.register_trigger_keys);

    m->opcode = opcode;
    v->trigger_on = NULL;
    v->trigger_off = NULL;

    GET16(m->im_id, rest, p, data_s->byte_swap);
    m->ic_id = -1;
    SKIP16(rest, p);

    GET32(len, rest, p, data_s->byte_swap);
    if ((len < 0) || (rest < len)) {
	iiimp_register_trigger_keys_delete(data_s, m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    v->trigger_on = iiimp_keyevent_list_unpack(data_s, &rest, &p, len);
    if (NULL == v->trigger_on) {
	iiimp_register_trigger_keys_delete(data_s, m);
	return NULL;
    }

    GET32(len, rest, p, data_s->byte_swap);
    if ((len < 0) || (rest < len)) {
	iiimp_register_trigger_keys_delete(data_s, m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    v->trigger_off = iiimp_keyevent_list_unpack(data_s, &rest, &p, len);
    if (NULL == v->trigger_off) {
	iiimp_register_trigger_keys_delete(data_s, m);
	return NULL;
    }

    *nbyte = rest;
    *ptr = p;

    return (IIIMP_message *)m;
}


void
iiimp_register_trigger_keys_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, -1);
    (void)fprintf(data_s->print_fp, "\ttrigger key to turn on =\n");
    iiimp_keyevent_list_print(data_s, m->v.register_trigger_keys.trigger_on);
    (void)fprintf(data_s->print_fp, "\ttrigger key to turn off =\n");
    iiimp_keyevent_list_print(data_s, m->v.register_trigger_keys.trigger_off);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
