/*
 * Copyright (C) 2003   Choe Hwanjin <krisna@kldp.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

/*
 * hangul le specific data
 */
typedef struct _Desktop               Desktop;
typedef struct _Session               Session;
typedef struct _HangulCombination     HangulCombination;

typedef enum {
    HANGUL_STATE_NONE,
    HANGUL_STATE_ENGLISH,
    HANGUL_STATE_HANGUL,
    HANGUL_STATE_HANJA,
} HangulState;

struct _Desktop {
    HangulState	state;
};

struct _HangulCombination {
    uint32_t key;
    UTFCHAR code;
};

struct _Session {
    const UTFCHAR *keyboard;
    Bool (*composer)(iml_session_t *s, IMKeyEventStruct *key);
    int compose_table_size;
    const HangulCombination *compose_table;

    HangulState	 state;

    int	         stack_index;
    UTFCHAR      stack[12];

    int	         lindex;			/* leading consonant */
    UTFCHAR      choseong[4];

    int          vindex;			/* vowel */
    UTFCHAR      jungseong[4];

    int          tindex;			/* trailing consonant */
    UTFCHAR      jongseong[4];

    /* candidate */
    int	           candidate;
    UTFCHAR        candidate_char;
    int            candidate_index;
    int            candidate_length;

    iml_inst *rrv;
};

void hangul_le_init(void);
void hangul_desktop_init(iml_desktop_t *desktop);
void hangul_desktop_finalize(iml_desktop_t *desktop);
void hangul_session_init(iml_session_t *s);
void hangul_session_finalize(iml_session_t *s);
IMText* hangul_session_reset(iml_session_t *s);

void hangul_prep(iml_session_t *s);
void hangul_exec(iml_session_t *s);
void hangul_foward_keyevent(iml_session_t *s, IMKeyEventStruct *key);

void hangul_focus(iml_session_t *s);
void hangul_unfocus(iml_session_t *s);
void hangul_conversion_on(iml_session_t *s);
void hangul_conversion_off(iml_session_t *s);
Bool hangul_composer(iml_session_t *s, IMKeyEventStruct *key);

/* vim: set ts=8 sw=4 : */
