#include <qapplication.h>
#include "lookup.h"

IIIMQCFLookup::IIIMQCFLookup(QWidget *w, IIIMInputContext *ic)
{
  //int flags = Qt::WType_TopLevel | Qt::WStyle_NoBorder;
  //int flags = Qt::WType_Popup;
  int flags = Qt::WType_Dialog | Qt::WStyle_NoBorder;
  flags &= ~Qt::WStyle_Title;
  //flags &= ~Qt::WStyle_Title;
  iiimqc = ic;
  lw = new QListBox (w, 0, flags);
  lw->setFocusPolicy (QWidget::NoFocus);
  //lw->setFrameStyle (QFrame::PopupPanel | QFrame::Sunken);
}


IIIMQCFLookup::~IIIMQCFLookup()
{
  delete lw;
}

void
IIIMQCFLookup::showLookupWindow (QWidget *w)
{
  if (lw->count() > 0)
    lw->show ();
  qDebug ("giving input focus back to %s", w->name ());
  w->setFocus ();
}

void
IIIMQCFLookup::hideLookupWindow (void)
{
  lw->hide ();
}

void
IIIMQCFLookup::setLookupChoices (QStringList &lc,
				 int size,
				 int first_index,
				 int last_index,
				 int current_index)

{
  clearLookupChoices ();
  lw->insertStringList (lc);
  lw->setCurrentItem (current_index);
}

void
IIIMQCFLookup::clearLookupChoices (void)
{
  lw->clear ();
}

bool
IIIMQCFLookup::isVisible () const
{
  return lw->isVisible ();
}
