/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ITEXTACTOR_H
#define ITEXTACTOR_H


#include <vtkProp.h>


#include "itextbitmap.h"
#include "itextvector.h"


class iTextActor: public vtkProp
{
	
public:

	static iTextActor* New(iRenderTool *rv){ return new iTextActor(rv); }
	
	virtual int RenderOverlay(vtkViewport *v);
	virtual int RenderOpaqueGeometry(vtkViewport *v);
	
	virtual void ReleaseGraphicsResources(vtkWindow *w);

	inline void GetSize(vtkViewport *v, float s[2]) const { mText[mFontIndex]->GetSize(v,s); }
	inline void GetSize(float s[2]) const { s[0] = mText[mFontIndex]->GetSize()[0]; s[1] = mText[mFontIndex]->GetSize()[1]; }

	void SetFontType(int s){ s += iParameter::__OffTextTypes; if(s>=0 && s<iParameter::__NumTextTypes) mFontIndex = s; }
	inline int GetFontType() const { return mFontIndex - iParameter::__OffTextTypes; }

	void SetFontScale(int s){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetFontScale(s); }
	inline int GetFontScale() const { return mText[0]->GetFontScale(); }

	void SetBold(bool s){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetBold(s); }
	inline bool GetBold() const { return mText[0]->GetBold(); }

	void SetHJustification(int s){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetHJustification(s); }
	void SetVJustification(int s){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetVJustification(s); }

	void SetPosition(float p[2]){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetPosition(p); }
	void SetPosition(float p0, float p1){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetPosition(p0,p1); }
	inline const float* GetPosition() const { return mText[0]->GetPosition(); }

	void Rotate(float a){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->Rotate(a); }

	virtual void SetText(const iString &t){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetText(t);} 

protected:
	
	virtual ~iTextActor();

private:

	iTextActor(iRenderTool *rv);

	int mFontIndex;
	iText *mText[iParameter::__NumTextTypes];
};

#endif // ITEXTACTOR_H
