/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iqtwidgetbuttonsubject.h"


#include "ierror.h"
#include "iimage.h"
#include "istring.h"

#include "iggwidget.h"

#include "iqtassistant.h"
#include "iqtwidgethelper.h"

#ifdef IQT_3
#include <qcheckbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#else
#include <QtGui/QCheckBox>
#include <QtGui/QGridLayout>
#include <QtGui/QImage>
#include <QtGui/QLabel>
#include <QtGui/QPixmap>
#include <QtGui/QPushButton>
#include <QtGui/QToolButton>
#endif


#include "iggparameter.h"
using namespace iggParameter;


iqtWidgetButtonSubject::iqtWidgetButtonSubject(iggWidget *owner, int type, const iString &text, int slot) : QWidget(iqtAssistant::Convert(owner->GetParent())), ibgWidgetButtonSubject(owner,type,text,slot)
{
	mWidgetHelper = new iqtWidgetHelper(this,owner); IERROR_ASSERT(mWidgetHelper);

	//
	//  Create a layout
	//
	if(this->layout() != 0) delete this->layout();
	QGridLayout *l = iqtAssistant::NewLayout(this,1);

	mType = type;
	switch(mType)
	{
	case _ButtonTypePushButton:
		{
			mButton = new QPushButton(this);
			break;
		}
	case _ButtonTypeToolButton:
	case _ButtonTypeToggleButton:
		{
			mButton = new QToolButton(this);
#ifdef IQT_3
			iPointerCast<QToolButton,QAbstractButton>(mButton)->setToggleButton(mType==_ButtonTypeToggleButton);
#else
			iPointerCast<QToolButton,QAbstractButton>(mButton)->setCheckable(mType==_ButtonTypeToggleButton);
#endif
			mButton->setMinimumSize(25,25);
			break;
		}
	case _ButtonTypeCheckBox:
		{
			mButton = new QCheckBox(this);
			break;
		}
	default: IERROR_REPORT("Incorrect button type.");
	}

	mButton->setText(iqtAssistant::ConvertWithModifiers(mButton,text));
	mButton->setSizePolicy(QSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum));
	l->addWidget(mButton,0,0);

	this->setSizePolicy(QSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum));

	switch(slot)
	{
	case 1:
		{
			if(!this->connect(mButton,SIGNAL(clicked()),iPointerCast<iqtWidgetHelper,ibgWidgetHelper>(mWidgetHelper),SLOT(OnVoid1()))) IERROR_REPORT("Missed connection.");
			break;
		}
	case 2:
		{
			if(!this->connect(mButton,SIGNAL(clicked()),iPointerCast<iqtWidgetHelper,ibgWidgetHelper>(mWidgetHelper),SLOT(OnVoid2()))) IERROR_REPORT("Missed connection.");
			break;
		}
	case 3:
		{
			if(!this->connect(mButton,SIGNAL(clicked()),iPointerCast<iqtWidgetHelper,ibgWidgetHelper>(mWidgetHelper),SLOT(OnVoid3()))) IERROR_REPORT("Missed connection.");
			break;
		}
	default:
		{
			IERROR_FINISH("Incorrect slot number.");
		}
	}
}


iqtWidgetButtonSubject::~iqtWidgetButtonSubject()
{
}


void iqtWidgetButtonSubject::SetSize(int w, int h)
{
	mButton->setFixedSize(w,h);
}


void iqtWidgetButtonSubject::SetFlat(bool s)
{
	switch(mType)
	{
	case _ButtonTypePushButton:
		{
			iPointerCast<QPushButton,QAbstractButton>(mButton)->setFlat(s);
			break;
		}
	case _ButtonTypeToolButton:
	case _ButtonTypeToggleButton:
		{
			iPointerCast<QToolButton,QAbstractButton>(mButton)->setAutoRaise(s);
			break;
		}
	}
}


void iqtWidgetButtonSubject::SetAutoRepeat(bool s)
{
	mButton->setAutoRepeat(s);
}


bool iqtWidgetButtonSubject::IsDown() const
{
	switch(mType)
	{
	case _ButtonTypePushButton:
		{
			return false;
		}
	case _ButtonTypeToolButton:
	case _ButtonTypeToggleButton:
	case _ButtonTypeCheckBox:
		{
#ifdef IQT_3
			return mButton->isOn();
#else
			return mButton->isChecked();
#endif
		}
	default:
		{
			IERROR_REPORT("Incorrect button type.");
			return false;
		}
	}
}


void iqtWidgetButtonSubject::SetDown(bool s)
{
	mButton->blockSignals(true);
	switch(mType)
	{
	case _ButtonTypePushButton:
		{
			break;
		}
	case _ButtonTypeToolButton:
	case _ButtonTypeToggleButton:
		{
#ifdef IQT_3
			iPointerCast<QToolButton,QAbstractButton>(mButton)->setOn(s);
#else
			iPointerCast<QToolButton,QAbstractButton>(mButton)->setChecked(s);
#endif
			break;
		}
	case _ButtonTypeCheckBox:
		{
			iPointerCast<QCheckBox,QAbstractButton>(mButton)->setChecked(s);
			break;
		}
	default: IERROR_REPORT("Incorrect button type.");
	}
	mButton->blockSignals(false);
}


void iqtWidgetButtonSubject::SetIcon(const iImage &icon)
{
#ifdef IQT_3
	mButton->setPixmap(iqtAssistant::ConvertToPixmap(icon));
#else
	QIcon ic = iqtAssistant::ConvertToIcon(icon);
	mButton->setIcon(ic);
#endif
}


void iqtWidgetButtonSubject::SetText(const iString &text)
{
	mButton->setText(iqtAssistant::ConvertWithModifiers(mButton,text));
}

