/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggframematerialproperties.h"


#include "ierror.h"
#include "iviewsubject.h"

#include "iggwidgetkeybutton.h"
#include "iggwidgetkeyslider.h"
#include "iggwidgetotherbutton.h"

#include "iggparameter.h"
using namespace iggParameter;

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"
#include "iggwidgetkeyslidertemplate.h"


iggFrameMaterialProperties::iggFrameMaterialProperties(bool withShading, bool withAllInstances, const iObjectType &type, iggFrame *parent, int index, const iObjectKey *indkey) : iggFrame(parent,1)
{
	const iObjectKey *key;

	iggFrame *box = new iggFrame("Material properties",this);
	this->AddLine(box);

	if(withShading)
	{
		key = iObjectKeyRegistry::FindKey(iViewSubject::KeyShading().RetypedKey(type)); IERROR_ASSERT(key);
		mShadingBox = new iggWidgetKeyCheckBox("Use shading",*key,box,index,indkey);
		mShadingBox->AddDependent(this);
		box->AddLine(mShadingBox);
	}
	else mShadingBox = 0;

	iggWidgetAllInstancesCheckBox *cb = 0;
	if(withAllInstances)
	{
		cb = new iggWidgetAllInstancesCheckBox(this);
		this->AddLine(cb);
		if(mShadingBox != 0) cb->AddDependent(mShadingBox);
	}

	key = iObjectKeyRegistry::FindKey(iViewSubject::KeyAmbient().RetypedKey(type)); IERROR_ASSERT(key);
	mSlider[0] = new iggWidgetKeyFloatSlider(0.0,1.0,100,0,3,"Ambient",*key,_RenderModeUseGlobal,box,index,indkey);
	mSlider[0]->SetStretch(10,15);
	if(cb != 0) cb->AddDependent(mSlider[0]);

	key = iObjectKeyRegistry::FindKey(iViewSubject::KeyDiffuse().RetypedKey(type)); IERROR_ASSERT(key);
	mSlider[1] = new iggWidgetKeyFloatSlider(0.0,1.0,100,0,3,"Diffuse",*key,_RenderModeUseGlobal,box,index,indkey);
	mSlider[1]->SetStretch(10,15);
	if(cb != 0) cb->AddDependent(mSlider[1]);

	key = iObjectKeyRegistry::FindKey(iViewSubject::KeySpecular().RetypedKey(type)); IERROR_ASSERT(key);
	mSlider[2] = new iggWidgetKeyFloatSlider(0.0,1.0,100,0,3,"Specular",*key,_RenderModeUseGlobal,box,index,indkey);
	mSlider[2]->SetStretch(10,15);
	if(cb != 0) cb->AddDependent(mSlider[2]);

	key = iObjectKeyRegistry::FindKey(iViewSubject::KeySpecularPower().RetypedKey(type)); IERROR_ASSERT(key);
	mSlider[3] = new iggWidgetKeyFloatSlider(0.0,127.0,128,0,3,"Specular power",*key,_RenderModeUseGlobal,box,index,indkey);
	mSlider[3]->SetStretch(10,15);
	if(cb != 0) cb->AddDependent(mSlider[3]);

	box->AddLine(mSlider[0]);
	box->AddLine(mSlider[1]);
	box->AddLine(mSlider[2]);
	box->AddLine(mSlider[3]);
}


void iggFrameMaterialProperties::UpdateChildren()
{
	int i;
	bool b;

	iggFrame::UpdateChildren();

	if(mShadingBox != 0)
	{
		mShadingBox->QueryValue(b);
		for(i=0; i<4; i++) mSlider[i]->Enable(b);
	}
}
