/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iclshell.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "iinteractoreventrecorder.h"
#include "iviewmodule.h"

#include "iclcommandinterpreter.h"

#include <vtkToolkits.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>


iclShell::iclShell(int argc, char **argv) : iShell(argc,argv)
{
	mType = "cl";

	mInterpreter = 0; // must be constructed when the shell is complete.
	mContinue = false;
}


iclShell::~iclShell()
{
}


void iclShell::DefineSpecificCommandLineOptions()
{
}


void iclShell::PrepareForConstruction()
{
	cout << "IFrIT is being initialized...\r";
	cout.flush();
}


void iclShell::ConstructorBody()
{
	mInterpreter = new iclCommandInterpreter(this); IERROR_ASSERT(mInterpreter);
}

  
void iclShell::DestructorBody()
{
	delete mInterpreter;
}


void iclShell::LoadStateFile(const iString &fname)
{
	if(fname.IsEmpty()) return;

	if(!mControlModule->LoadStateFromFile(fname)) this->OutputStartupMessage("Unable to load the state file.\nDefault values of parameters will be used.");
}


void iclShell::OutputStartupMessage(const iString &message)
{
	cerr << message.ToCharPointer() << endl;
}


void iclShell::Start()
{
	int i;
	for(i=0; i<mControlModule->GetNumberOfViewModules(); i++)
	{
		mControlModule->GetViewModule(i)->GetInteractor()->Disable();
		mControlModule->GetViewModule(i)->SetAntialiasing(true);
	}
	mControlModule->Render();  // render all windows
	mInterpreter->Start();

	mContinue = true;
}


void iclShell::Exit()
{
	mContinue = false;
}


void iclShell::RunBody()
{
	//
	//  This is our event loop
	//
	while(mContinue && mInterpreter->Exec()==0)
	{
		mControlModule->GetViewModule()->GetInteractor()->Enable();
		mControlModule->GetViewModule()->GetEventRecorder()->SetInteractor(0); // does not work with this shell
		mControlModule->GetViewModule()->GetInteractor()->Start();
		mControlModule->GetViewModule()->GetInteractor()->Disable();
	}
}


bool iclShell::AnalyseOneExtendedCommandLineOption(const struct Option&)
{
	return false;
}


//
//  State saving
//
bool iclShell::LoadShellStateFromFile(iFile &)
{
	//
	//  Nothing to do here
	//
	return true;
}


bool iclShell::SaveShellStateToFile(iFile &) const
{
	//
	//  Nothing to do here
	//
	return true;
}


#ifdef I_DEBUG
void iclShell::OutputDebugMessage(const iString &message) const
{
	cout << message.ToCharPointer() << endl;
}

#endif

