/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  A base class for widget helpers - classes that provide toolkit-dependent functionality and callbacks
//

#ifndef IBGWIDGETHELPER_H
#define IBGWIDGETHELPER_H


class iColor;
class iString;

class iggWidget;


class ibgWidgetHelper
{

public:

	virtual ~ibgWidgetHelper();

	virtual void SetBaloonHelp(const iString &tooltip, const iString &whatsthis) = 0;
	virtual bool SupportsHTMLHelp() const = 0;
	virtual bool HasBaloonHelp() const = 0;

	virtual void Show(bool s) = 0;
	virtual bool IsVisible() const = 0;

	virtual void Enable(bool s) = 0;
	virtual bool IsEnabled() const = 0;

	virtual void SetBackgroundColor(const iColor &c) = 0;
	virtual void UnSetBackgroundColor() = 0;

	void OpenHelpPage(const iString &tag);

protected:

	ibgWidgetHelper(iggWidget *owner);

	//
	//  Generic slots
	//
	void OnInt1Body(int);
	void OnInt2Body(int);
	void OnVoid1Body();
	void OnVoid2Body();
	void OnVoid3Body();
	void OnBool1Body(bool);
	void OnString1Body(const iString &);

	iggWidget *mOwner;
};

#endif  // IBGWIDGETHELPER_H

