/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ITENSORFIELDVIEWSUBJECT_H
#define ITENSORFIELDVIEWSUBJECT_H


#include "ifieldviewsubject.h"


class iPolyDataExtender;


class iTensorFieldViewSubject : public iFieldViewSubject
{
	
	friend class iExtensionFactory;

public:
	
	IOBJECT_DECLARE_SELF(iTensorFieldViewSubject,iFieldViewSubject);

	static const iObjectType& Type();
		
	IOBJECT_DECLARE_GETSET1(ScalingOn,bool);
	//virtual void SetScalingOn(bool s);
	//inline bool isScalingOn() const { return mScalingOn; }
	
	IOBJECT_DECLARE_GET1(Method,int);
	//inline int GetMethod() const { return mMethod; }

	//
	//  Inherited members
	//
	virtual iViewSubjectPipeline* CreatePipeline(int id);
	IFIELDVIEWSUBJECT_DECLARE_INHERITED_KEYS;
	IFIELDVIEWSUBJECT_DECLARE_INHERITED_MEMBERS;

protected:
	
	iTensorFieldViewSubject(iViewModule *vm, const iDataType &type, const iString &name);
	virtual ~iTensorFieldViewSubject();
	virtual void ConfigureBody();
	virtual void ConfigureMainPipeline(iViewSubjectPipeline *p, int id);

	bool mScalingOn;
	int mMethod;
};

#endif // ITENSORFIELDVIEWSUBJECT_H

