/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iprobefilter.h"


#include "idata.h"
#include "idatalimits.h"
#include "ierror.h"
#include "itune.h"
#include "iuniformgriddatasubject.h"
#include "iviewmodule.h"

#include <vtkFloatArray.h>
#include <vtkImageData.h>
#include <vtkPointData.h>
#include <vtkPolyData.h>

//
//  Templates (needed for some compilers)
//
#include "igenericfiltertemplate.h"


iProbeFilter::iProbeFilter(iViewSubject *vo) : iGenericFilter<vtkProbeFilter,vtkDataSet,vtkDataSet>(vo,1,true,true)
{
}


void iProbeFilter::ProduceOutput()
{
	vtkDataObject *input = this->GetInput();
	vtkDataSet *output = this->GetOutput();
	vtkDataObject *source = this->GetSource();

	if(source->IsA("vtkImageData") && input->IsA("vtkPointSet") && output->IsA("vtkPointSet"))
	{
		this->ProduceOutputForImageData(vtkPointSet::SafeDownCast(input),vtkPointSet::SafeDownCast(output),vtkImageData::SafeDownCast(source));
	}
	else
	{
#ifdef IVTK_4
		this->vtkProbeFilter::ExecuteData(output);
#else
		output->ShallowCopy(input); // Probe does not copy normals...
		this->vtkProbeFilter::Probe(vtkDataSet::SafeDownCast(input),vtkDataSet::SafeDownCast(source),output);
#endif
	}
}


void iProbeFilter::ProduceOutputForImageData(vtkPointSet *input, vtkPointSet *output, vtkImageData *source)
{
	output->ShallowCopy(input);

	vtkPoints *inpts = input->GetPoints();
	if(inpts == 0) return;

	vtkIdType numPts = inpts->GetNumberOfPoints();

	if(!this->ScalarsInit(source->GetPointData(),numPts)) return;
	
	int j, dims[3], ijk1[3], ijk2[3];
	double org[3], spa[3];
	source->GetDimensions(dims);
	source->GetSpacing(spa);
	source->GetOrigin(org);

	vtkIdType l, loff, loff111, loff112, loff121, loff122, loff211, loff212, loff221, loff222;
	double x[3];
	double d1[3], d2[3];

	bool per[3];
	this->GetLimits()->GetPeriodicities(per);

	//	
	// Loop over all input points, interpolating source data
	//
	for(l=0; l<numPts; l++)
    {
		if(l%1000 == 0)
		{
			this->UpdateProgress((float)l/numPts);
			if(this->GetAbortExecute()) break;
		}
		
		// Get the xyz coordinate of the point in the input dataset
		inpts->GetPoint(l,x);

		// Find the cell that contains xyz and get it
		iUniformGridDataSubject::GetCICInterpolation(per,dims,org,spa,x,ijk1,ijk2,d1,d2);
		loff111	= wScalarDimIn*(ijk1[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk1[2]));
		loff112	= wScalarDimIn*(ijk1[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk2[2]));
		loff121	= wScalarDimIn*(ijk1[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk1[2]));
		loff122	= wScalarDimIn*(ijk1[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk2[2]));
		loff211	= wScalarDimIn*(ijk2[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk1[2]));
		loff212	= wScalarDimIn*(ijk2[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk2[2]));
		loff221	= wScalarDimIn*(ijk2[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk1[2]));
		loff222	= wScalarDimIn*(ijk2[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk2[2]));
		
		loff = l*wScalarDimOut;
		for(j=0; j<wScalarDimOut; j++)
		{
			wScalarPtrOut[loff+j] = 
				wScalarPtrIn[loff111+j]*d1[0]*d1[1]*d1[2] +
				wScalarPtrIn[loff112+j]*d1[0]*d1[1]*d2[2] +
				wScalarPtrIn[loff121+j]*d1[0]*d2[1]*d1[2] +
				wScalarPtrIn[loff122+j]*d1[0]*d2[1]*d2[2] +
				wScalarPtrIn[loff211+j]*d2[0]*d1[1]*d1[2] +
				wScalarPtrIn[loff212+j]*d2[0]*d1[1]*d2[2] +
				wScalarPtrIn[loff221+j]*d2[0]*d2[1]*d1[2] +
				wScalarPtrIn[loff222+j]*d2[0]*d2[1]*d2[2];
		}
    }

    this->ScalarsDone(output->GetPointData());
}
