/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Class for reporting and monitoring of execution errors
//

#ifndef IERRORSTATUS_H
#define IERRORSTATUS_H


#include "istring.h"


#include "imath.h"

class iErrorStatusHolder;


class iErrorStatus
{

	friend class iErrorStatusHolder;

public:

	inline const iString& GetMessage() const { return mData.Message; }
	inline const iString& GetErrorMessage() const { return mData.Message; } // to fix a VC++7 bug
	inline int GetLevel() const { return mData.Level; }

	inline bool NoError() const { return mData.Message.IsEmpty(); }
	inline bool IsError() const { return !mData.Message.IsEmpty(); }
	inline bool IsAborted() const { return mData.Message == mAbortMessage; }

	void Clear();
	void Set(const iString &msg, int lev = iMath::_IntMax);
	void SetAbort(int lev = iMath::_IntMax);

	void Monitor(iErrorStatusHolder *parent, const iString &prefix = "");
	void Monitor(iErrorStatus *object, const iString &prefix = "");
	void SetSupervisorPrefix(const iString &prefix);

protected:

	iErrorStatus(iErrorStatusHolder *parent);

private:

	struct ErrorInfo
	{
		iString Message;
		int Level;
	};

	bool mInUpdate;
	iErrorStatus *mSupervisor, *mLastSupervisor;
	iString mSupervisorPrefix;
	ErrorInfo mData;

	static const iString mAbortMessage;
};

#endif  // IERRORSTATUS_H
