/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Base class for shell-specific interpreters for ControlScript
//
#ifndef ICOMMANDINTERPRETER_H
#define ICOMMANDINTERPRETER_H


#include "ishellcomponent.h"


#include "istring.h"

class iControlScript;


class iCommandInterpreter : public iShellComponent
{

public:

	iCommandInterpreter(iShell *s);
	virtual ~iCommandInterpreter();

	void Start();
	int Exec();
	void ExecLine(iString &line);
	void Break(int ret);
	void Stop();

	virtual void DislayLineOfText(const iString &text, int type) const = 0;

	inline bool GetExecFlag() const { return mExecFlag; }
	inline bool GetWorkFlag() const { return mWorkFlag; }
	inline const iString& GetLastExecutedScriptText() const { return mLastExecutedScriptText; }
	virtual iControlScript* Script() const; // just in case... (to allow script substitutions)

protected:

	void ExecLineBody(iString &line);

	virtual bool IsHelpRequest(const iString &line) const;

	virtual void Initialize() = 0;
	virtual void DisplayPrompt() const = 0;
	virtual void ReadLineOfText(iString &line) const = 0;
	virtual void AnalyseSpecialCommands(const iString &line) = 0;
	virtual void CheckBreak() = 0;
	virtual void Finalize() = 0;

private:

	//
	//  Private, to make sure they are not changed accidentally
	//
	bool mBreakFlag, mExecFlag, mWorkFlag;
	int mReturnState;
	iString mScriptText, mLastExecutedScriptText;
};

#endif  // ICOMMANDINTERPRETER_H
