/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include <string.h>
#include "itune.h"


#include "iconsole.h"
#include "ifile.h"


//#include <iostream.h>


#ifndef ITUNE_INLINE

#define ITUNEDEFS_H
#include "itunedefs.h"
#undef ITUNEDEFS_H

#endif


#if ITUNE_INLINE == 0

#define ITUNEWORK_H
#include "itunework.h"
#undef ITUNEWORK_H

#elif ITUNE_INLINE != 1

#error "iTune class is configured incorrectly."
!TERMINATE!

#endif // ITUNE_INLINE


//
//  This function does self-tuning
//
void iTune::Tune()
{
	//
	//  Are we already tuned?
	//
#if ITUNE_DONE != 0
	return;
#endif
	//
	//  Find the file "core/itunedefs.h". If it is not there, then we are not in the
	//  build directory, so we cannot tune. Report a non-intrusive warning and exit.
	//
	iFile F("core/itunedefs.h");
	if(!F.Open(iFile::_Read,iFile::_Text))
	{
		iConsole::Instance()->DisplayTextMessage("IFrIT has not been tuned up. You can tune it to improve performance by:");
		iConsole::Instance()->DisplayTextMessage("  1. Starting IFrIT once from the build directory.");
		iConsole::Instance()->DisplayTextMessage("  2. Recompiling it after that again.");
		return;
	}

	iConsole::Instance()->DisplayTextMessage("Tuning IFrIT up. Please, wait...");

	iConsole::Instance()->DisplayTextMessage("IFrIT is fully tuned up. Enjoy.");
	F.Close();
}

