/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qdialog.h>

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qtable.h>

//#include "ifp.h"
#include "ifpinterface.h"

class RadioFreqWindow: public QDialog
{
   Q_OBJECT

   public:
      RadioFreqWindow(QWidget *parent=0, const char *name=0, bool modal=FALSE, WFlags f=0);
      ~RadioFreqWindow();

   public slots:
      virtual void btnDone_clicked();
      virtual void btnCancel_clicked();
      virtual void tableValueChanged(int row, int col);

   private:
      char buf[IFP_TUNER_PRESET_DATA];
      QTable *freqTable;

      QPushButton *btnDone;
      QPushButton *btnCancel;

      void initalizeDisplaySettings(void);
      void finalizeDisplaySettings(void);
};

