/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef __IFPINTERFACE_H__
#define __IFPINTERFACE_H__

#include <usb.h>
#include <qlibrary.h>
#include <ifp.h>


#ifdef __cplusplus
extern "C" {
#endif

/* Return codes */
#define IFP_OK  0

extern int cancel_progress;
extern QLibrary *ifpLib;
extern bool usingLibrary;
extern bool errorInLibrary;
extern QString ifpLibraryVersion;
// ifp_init
typedef int (*my_ifp_init)(struct ifp_device * dev, void * dev_handle);
extern my_ifp_init ifpgui_ifp_init;
// ifp_finalize
typedef int (*my_ifp_finalize)(struct ifp_device * dev);
extern my_ifp_finalize ifpgui_ifp_finalize;
// ifp_find_device
typedef void * (*my_ifp_find_device)(void);
extern my_ifp_find_device ifpgui_ifp_find_device;
// ifp_release_device;
typedef int (*my_ifp_release_device)(void *);
extern my_ifp_release_device ifpgui_ifp_release_device;
// ifp_format
typedef int (*my_ifp_format)(struct ifp_device * dev);
extern my_ifp_format ifpgui_ifp_format;
// ifp_update_firmware
typedef int (*my_ifp_update_firmware)(struct ifp_device * dev, const char * localfile, ifp_progress fn, void * context);
extern my_ifp_update_firmware ifpgui_ifp_update_firmware;
// ifp_device_info
typedef int (*my_ifp_device_info)(struct ifp_device * dev, char * b, int n);
extern my_ifp_device_info ifpgui_ifp_device_info;
// ifp_battery
typedef int (*my_ifp_battery)(struct ifp_device * dev);
extern my_ifp_battery ifpgui_ifp_battery;
// ifp_capacity
typedef int (*my_ifp_capacity)(struct ifp_device * dev);
extern my_ifp_capacity ifpgui_ifp_capacity;
// ifp_freespace
typedef int (*my_ifp_freespace)(struct ifp_device * dev);
extern my_ifp_freespace ifpgui_ifp_freespace;
// ifp_model
typedef int (*my_ifp_model)(struct ifp_device * dev, char * b, int n);
extern my_ifp_model ifpgui_ifp_model;
// ifp_delta
typedef int (*my_ifp_delta)(struct ifp_device * dev, int * values);
extern my_ifp_delta ifpgui_ifp_delta;
// ifp_firmware_version
typedef int (*my_ifp_firmware_version)(struct ifp_device * dev);
extern my_ifp_firmware_version ifpgui_ifp_firmware_version;
// ifp_error_message
typedef const char * (*my_ifp_error_message)(int n);
extern my_ifp_error_message ifpgui_ifp_error_message;

// ifp_rename
typedef int (*my_ifp_rename)(struct ifp_device * dev, const char * old_path, const char * new_path);
extern my_ifp_rename ifpgui_ifp_rename;
// ifp_delete
typedef int (*my_ifp_delete)(struct ifp_device * dev, const char * f);
extern my_ifp_delete ifpgui_ifp_delete;
// ifp_mkdir
typedef int (*my_ifp_mkdir)(struct ifp_device * dev, const char * f);
extern my_ifp_mkdir ifpgui_ifp_mkdir;
// ifp_rmdir
typedef int (*my_ifp_rmdir)(struct ifp_device * dev, const char * f);
extern my_ifp_rmdir ifpgui_ifp_rmdir;
// ifp_list_dirs
typedef int (*my_ifp_list_dirs)(struct ifp_device * dev, const char * dirname,
        int(*callbk)(void *, int, const char *, int),
        void * context);
extern my_ifp_list_dirs ifpgui_ifp_list_dirs;
// ifp_read_file_progress
typedef int (*my_ifp_read_file_progress)(struct ifp_device * dev, FILE * dst, const char * f,
        int(*progress)(void *, int), void * context);
extern my_ifp_read_file_progress ifpgui_ifp_read_file_progress;
// ifp_write_file_progress
typedef int (*my_ifp_write_file_progress)(struct ifp_device * dev, FILE * src,
        int filesize, const char * f,
        int(*progress)(void *, int), void * context);
extern my_ifp_write_file_progress ifpgui_ifp_write_file_progress;
// ifp_download_file
typedef int (*my_ifp_download_file)(struct ifp_device * dev,
        const char * remotefile, const char * localfile,
        ifp_progress fn, void * fn_context);
extern my_ifp_download_file ifpbase_ifp_download_file;
extern int ifpgui_ifp_download_file(struct ifp_device * dev,
        const char * remotefile, const char * localfile,
        ifp_progress fn, void * fn_context);
// ifp_upload_file
typedef int (*my_ifp_upload_file)(struct ifp_device * dev,
        const char * localfile, const char * remotefile,
        ifp_progress fn, void * fn_context);
extern my_ifp_upload_file ifpgui_ifp_upload_file;
// ifp_delete_dir_recursive
typedef int (*my_ifp_delete_dir_recursive)(struct ifp_device * dev, const char * f);
extern my_ifp_delete_dir_recursive ifpgui_ifp_delete_dir_recursive;
// ifp_download_dir
typedef int (*my_ifp_download_dir)(struct ifp_device * dev,
        const char * remotedir, const char * localdir,
        ifp_progress fn, void * fn_context);
extern my_ifp_download_dir ifpgui_ifp_download_dir;
// ifp_upload_dir
typedef int (*my_ifp_upload_dir)(struct ifp_device * dev,
        const char * localdir, const char * remotedir,
        ifp_progress fn, void * fn_context);
extern my_ifp_upload_dir ifpgui_ifp_upload_dir;
// ifp_is_file
typedef int (*my_ifp_is_file)(struct ifp_device * dev, const char * f);
extern my_ifp_is_file ifpgui_ifp_is_file;
// ifp_is_dir
typedef int (*my_ifp_is_dir)(struct ifp_device * dev, const char * f);
extern my_ifp_is_dir ifpgui_ifp_is_dir;
// ifp_exists
typedef int (*my_ifp_exists)(struct ifp_device * dev, const char * f);
extern my_ifp_exists ifpgui_ifp_exists;
// ifp_get_tuner_presets
typedef int (*my_ifp_get_tuner_presets)(struct ifp_device * dev, void * data, int n);
extern my_ifp_get_tuner_presets ifpgui_ifp_get_tuner_presets;
// ifp_set_tuner_presets
typedef int (*my_ifp_set_tuner_presets)(struct ifp_device * dev, void * data, int n);
extern my_ifp_set_tuner_presets ifpgui_ifp_set_tuner_presets;
// ifp_get_station
typedef int (*my_ifp_get_station)(int n, void * b, char * callsign, int * freq);
extern my_ifp_get_station ifpgui_ifp_get_station;
// ifp_set_station
typedef int (*my_ifp_set_station)(int n, void * data, const char * callsign, int freq);
extern my_ifp_set_station ifpgui_ifp_set_station;



extern usb_dev_handle    *ifp_dh;
extern struct ifp_device ifp_dev;
extern struct usb_device *usb_dev;

extern int initialize_ifp_device(void);
extern int release_ifp_device(void);

#ifdef __cplusplus
}
#endif

#endif //__IFPINTERFACE_H__
