/* icoutils - A set of programs dealing with MS Windows icons and cursors.
 * Copyright (C) 1998-1999 Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <config.h>

#include <features.h>
#include <unistd.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <getopt.h>
#include "../common/win32.h"
#include "../common/fileread.h"
#include "../common/util.h"
#include "../common/common.h"
#include "../common/messages.h"

/*
 * External Variables
 */

extern char *prgname;
extern boolean arg_raw;

/*
 * Structures 
 */

typedef struct _WinLibrary {
	char *name;
	FILE *file;
	byte *memory;
	byte *first_resource;
	boolean is_PE_binary;
	int total_size;
} WinLibrary;

typedef struct _WinResource {
	char id[256];
	void *this;
	void *children;
	int level;
	boolean numeric_id;
	boolean is_directory;
} WinResource;

#define WINRES_ID_MAXLEN (256)

/*
 * Definitions
 */

#define ACTION_LIST 				1	/* command: list resources */
#define ACTION_EXTRACT				2	/* command: extract resources */
#define CALLBACK_STOP				0	/* results of ResourceCallback */
#define CALLBACK_CONTINUE			1
#define CALLBACK_CONTINUE_RECURS	2

#define MZ_HEADER(x)	((DOSImageHeader *)(x))
#define NE_HEADER(x)	((OS2ImageHeader *)PE_HEADER(x))
#define NE_TYPEINFO_NEXT(x) ((Win16NETypeInfo *)((byte *)(x) + sizeof(Win16NETypeInfo) + \
						    ((Win16NETypeInfo *)x)->count * sizeof(Win16NENameInfo)))
#define NE_RESOURCE_NAME_IS_NUMERIC (0x8000)

#define STRIP_RES_ID_FORMAT(x) (x != NULL && (x[0] == '-' || x[0] == '+') ? ++x : x)

typedef void (*DoResourceCallback) (WinLibrary *, WinResource *, WinResource *, WinResource *, WinResource *);

/*
 * Function Prototypes
 */

/* resource.c */
WinResource *list_resources (WinLibrary *, WinResource *, int *);
boolean read_library (WinLibrary *);
WinResource *find_resource (WinLibrary *, char *, char *, char *, int *);
void *get_resource_entry (WinLibrary *, WinResource *, int *);
void do_resources (WinLibrary *, char *, char *, char *, DoResourceCallback);
void print_resources_callback (WinLibrary *, WinResource *, WinResource *, WinResource *, WinResource *);
boolean compare_resource_id (WinResource *, char *);

/* main.c */
char *res_type_id_to_string (int);
char *get_destination_name (WinLibrary *, char *, char *, char *);

/* extract.c */
void *extract_resource (WinLibrary *, WinResource *, int *, boolean *, char *, char *, boolean);
void extract_resources_callback (WinLibrary *, WinResource *, WinResource *, WinResource *, WinResource *);
