/* icoutils - A set of programs dealing with MS Windows icons and cursors.
 * Copyright (C) 1998-1999 Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <config.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

/* arg_verbosity: Determines what is printed by {verbose,debug}_printf */
extern int arg_verbosity;
/* arg_output: Name of file/directory to output to. If NULL, assume STDOUT */
extern char *arg_output;
/* prgname: Basename of the application */
extern char *prgname;
/* verbose_file: Where to output verbose messages */
extern FILE *verbose_file;

#define P_OBJ_ERROR(obj, msg) error_printf("%s: %s\n", (obj), (msg))
#define P_OBJ_SYS_ERROR(obj) error_printf("%s: %s\n", (obj), strerror(errno))
#define P_GEN_SYS_ERROR() error_printf("%s\n", strerror(errno))
#define P_GEN_ERROR(msg) error_printf("%s\n", (msg))
#define P_OBJ_WARN(obj, msg) warn_printf("%s: %s\n", (obj), (msg))

/* verbose_printf: Print message if verbosity >= 1, -v option specified */
void verbose_printf (const char *, ...);
/* debug_printf: Print message if verbosity >= 2, -vv option specified */
void debug_printf (const char *, ...);
/* error_printf: print an error message to STDERR. Prepend prgname. */
void error_printf (const char *, ...);
/* warn_printf: print a warning to STDERR */
void warn_printf (const char *, ...);
/* malloc_failure: print a message that memory allocation has failed, and exit() */
void malloc_failure ();
