/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGGElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGGElement.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGGElement);

/* Hash table */

static const HashTableValue JSSVGGElementTableValues[12] =
{
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGGElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGGElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGGElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGGElementXmllang, (intptr_t)setJSSVGGElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGGElementXmlspace, (intptr_t)setJSSVGGElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGGElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGGElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGGElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGGElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGGElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGGElementFarthestViewportElement, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGGElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGGElementTableValues, 0 };
#else
    { 33, 31, JSSVGGElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGGElementPrototypeTableValues[7] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGGElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGGElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGGElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGGElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGGElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGGElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGGElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGGElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGGElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGGElementPrototype::s_info = { "SVGGElementPrototype", 0, &JSSVGGElementPrototypeTable, 0 };

JSObject* JSSVGGElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGGElement>(exec, globalObject);
}

bool JSSVGGElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGGElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGGElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGGElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGGElement::s_info = { "SVGGElement", &JSSVGElement::s_info, &JSSVGGElementTable, 0 };

JSSVGGElement::JSSVGGElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGGElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGGElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGGElementPrototype(JSSVGGElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGGElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGGElement, Base>(exec, &JSSVGGElementTable, this, propertyName, slot);
}

bool JSSVGGElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGGElement, Base>(exec, &JSSVGGElementTable, this, propertyName, descriptor);
}

JSValue jsSVGGElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValue jsSVGGElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValue jsSVGGElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->systemLanguage()), imp);
}

JSValue jsSVGGElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    return jsString(exec, imp->xmllang());
}

JSValue jsSVGGElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue jsSVGGElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGGElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGGElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

JSValue jsSVGGElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGGElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nearestViewportElement()));
}

JSValue jsSVGGElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGGElement* castedThis = static_cast<JSSVGGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGGElement* imp = static_cast<SVGGElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->farthestViewportElement()));
}

void JSSVGGElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGGElement, Base>(exec, propertyName, value, &JSSVGGElementTable, this, slot);
}

void setJSSVGGElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGGElement* imp = static_cast<SVGGElement*>(static_cast<JSSVGGElement*>(thisObject)->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGGElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGGElement* imp = static_cast<SVGGElement*>(static_cast<JSSVGGElement*>(thisObject)->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGGElement* castedThisObj = static_cast<JSSVGGElement*>(asObject(thisValue));
    SVGGElement* imp = static_cast<SVGGElement*>(castedThisObj->impl());
    const UString& extension = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGGElement* castedThisObj = static_cast<JSSVGGElement*>(asObject(thisValue));
    SVGGElement* imp = static_cast<SVGGElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGGElement* castedThisObj = static_cast<JSSVGGElement*>(asObject(thisValue));
    SVGGElement* imp = static_cast<SVGGElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGGElement* castedThisObj = static_cast<JSSVGGElement*>(asObject(thisValue));
    SVGGElement* imp = static_cast<SVGGElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGGElement* castedThisObj = static_cast<JSSVGGElement*>(asObject(thisValue));
    SVGGElement* imp = static_cast<SVGGElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGGElement* castedThisObj = static_cast<JSSVGGElement*>(asObject(thisValue));
    SVGGElement* imp = static_cast<SVGGElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
