/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSCanvasRenderingContext3D_h
#define JSCanvasRenderingContext3D_h

#if ENABLE(3D_CANVAS)

#include "JSCanvasRenderingContext.h"

namespace WebCore {

class CanvasRenderingContext3D;

class JSCanvasRenderingContext3D : public JSCanvasRenderingContext {
    typedef JSCanvasRenderingContext Base;
public:
    JSCanvasRenderingContext3D(NonNullPassRefPtr<JSC::Structure>, JSDOMGlobalObject*, PassRefPtr<CanvasRenderingContext3D>);
    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags));
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);

    // Custom functions
    JSC::JSValue bufferData(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue bufferSubData(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue texImage2D(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue texSubImage2D(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform1fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform1iv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform2fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform2iv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform3fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform3iv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform4fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform4iv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniformMatrix2fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniformMatrix3fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniformMatrix4fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue vertexAttrib1fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue vertexAttrib2fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue vertexAttrib3fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue vertexAttrib4fv(JSC::ExecState*, const JSC::ArgList&);
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};


class JSCanvasRenderingContext3DPrototype : public JSC::JSObject {
    typedef JSC::JSObject Base;
public:
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags));
    }
    JSCanvasRenderingContext3DPrototype(NonNullPassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionSizeInBytes(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionActiveTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionAttachShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBindAttribLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBindBuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBindFramebuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBindRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBindTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBlendColor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBlendEquation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBlendEquationSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBlendFunc(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBlendFuncSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBufferData(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionBufferSubData(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCheckFramebufferStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionClear(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionClearColor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionClearDepth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionClearStencil(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionColorMask(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCompileShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCopyTexImage2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCopyTexSubImage2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCreateBuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCreateFramebuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCreateProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCreateRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCreateShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCreateTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionCullFace(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDeleteBuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDeleteFramebuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDeleteProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDeleteRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDeleteShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDeleteTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDepthFunc(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDepthMask(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDepthRange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDetachShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDisable(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDisableVertexAttribArray(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDrawArrays(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionDrawElements(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionEnable(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionEnableVertexAttribArray(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionFinish(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionFlush(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionFramebufferRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionFramebufferTexture2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionFrontFace(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGenerateMipmap(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetActiveAttrib(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetActiveUniform(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetAttribLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetBoolean(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetBooleanv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetBufferParameteri(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetBufferParameteriv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetError(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetFloat(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetFloatv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetFramebufferAttachmentParameteri(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetFramebufferAttachmentParameteriv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetInteger(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetIntegerv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetProgrami(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetProgramiv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetProgramInfoLog(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetRenderbufferParameteri(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetRenderbufferParameteriv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetShaderi(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetShaderiv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetShaderInfoLog(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetShaderSource(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetString(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetTexParameterf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetTexParameterfv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetTexParameteri(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetTexParameteriv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetUniformf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetUniformfv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetUniformi(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetUniformiv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetUniformLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetVertexAttribf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetVertexAttribfv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetVertexAttribi(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetVertexAttribiv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionGetVertexAttribOffset(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionHint(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionIsBuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionIsEnabled(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionIsFramebuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionIsProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionIsRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionIsShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionIsTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionLineWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionLinkProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionPixelStorei(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionPolygonOffset(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionReadPixels(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionReleaseShaderCompiler(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionRenderbufferStorage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionSampleCoverage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionScissor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionShaderSource(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionStencilFunc(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionStencilFuncSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionStencilMask(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionStencilMaskSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionStencilOp(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionStencilOpSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionTexParameterf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionTexParameteri(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionTexImage2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionTexSubImage2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform1f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform1fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform1i(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform1iv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform2f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform2fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform2i(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform2iv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform3f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform3fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform3i(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform3iv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform4f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform4fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform4i(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniform4iv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniformMatrix2fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniformMatrix3fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUniformMatrix4fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionUseProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionValidateProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionVertexAttrib1f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionVertexAttrib1fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionVertexAttrib2f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionVertexAttrib2fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionVertexAttrib3f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionVertexAttrib3fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionVertexAttrib4f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionVertexAttrib4fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionVertexAttribPointer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsCanvasRenderingContext3DPrototypeFunctionViewport(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
// Attributes

JSC::JSValue jsCanvasRenderingContext3DConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
// Constants

JSC::JSValue jsCanvasRenderingContext3DDEPTH_BUFFER_BIT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_BUFFER_BIT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCOLOR_BUFFER_BIT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFALSE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTRUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DPOINTS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLINES(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLINE_LOOP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLINE_STRIP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTRIANGLES(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTRIANGLE_STRIP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTRIANGLE_FAN(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DZERO(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DONE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSRC_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DONE_MINUS_SRC_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSRC_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DONE_MINUS_SRC_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDST_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DONE_MINUS_DST_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDST_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DONE_MINUS_DST_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSRC_ALPHA_SATURATE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFUNC_ADD(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLEND_EQUATION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLEND_EQUATION_RGB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLEND_EQUATION_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFUNC_SUBTRACT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFUNC_REVERSE_SUBTRACT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLEND_DST_RGB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLEND_SRC_RGB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLEND_DST_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLEND_SRC_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCONSTANT_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DONE_MINUS_CONSTANT_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCONSTANT_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DONE_MINUS_CONSTANT_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLEND_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DARRAY_BUFFER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DELEMENT_ARRAY_BUFFER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DARRAY_BUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DELEMENT_ARRAY_BUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTREAM_DRAW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTATIC_DRAW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDYNAMIC_DRAW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBUFFER_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBUFFER_USAGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCURRENT_VERTEX_ATTRIB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRONT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBACK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRONT_AND_BACK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_2D(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCULL_FACE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLEND(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDITHER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_TEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDEPTH_TEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSCISSOR_TEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DPOLYGON_OFFSET_FILL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSAMPLE_ALPHA_TO_COVERAGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSAMPLE_COVERAGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNO_ERROR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINVALID_ENUM(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINVALID_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINVALID_OPERATION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DOUT_OF_MEMORY(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCCW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLINE_WIDTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DALIASED_POINT_SIZE_RANGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DALIASED_LINE_WIDTH_RANGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCULL_FACE_MODE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRONT_FACE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDEPTH_RANGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDEPTH_WRITEMASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDEPTH_CLEAR_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDEPTH_FUNC(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_CLEAR_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_FUNC(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_FAIL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_PASS_DEPTH_FAIL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_PASS_DEPTH_PASS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_REF(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_VALUE_MASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_WRITEMASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_BACK_FUNC(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_BACK_FAIL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_BACK_PASS_DEPTH_FAIL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_BACK_PASS_DEPTH_PASS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_BACK_REF(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_BACK_VALUE_MASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_BACK_WRITEMASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVIEWPORT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSCISSOR_BOX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCOLOR_CLEAR_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCOLOR_WRITEMASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DUNPACK_ALIGNMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DPACK_ALIGNMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_TEXTURE_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_VIEWPORT_DIMS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSUBPIXEL_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRED_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DGREEN_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBLUE_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DALPHA_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDEPTH_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DPOLYGON_OFFSET_UNITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DPOLYGON_OFFSET_FACTOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_BINDING_2D(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSAMPLE_BUFFERS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSAMPLES(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSAMPLE_COVERAGE_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSAMPLE_COVERAGE_INVERT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNUM_COMPRESSED_TEXTURE_FORMATS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCOMPRESSED_TEXTURE_FORMATS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDONT_CARE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFASTEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNICEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DGENERATE_MIPMAP_HINT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBYTE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DUNSIGNED_BYTE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSHORT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DUNSIGNED_SHORT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DUNSIGNED_INT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFLOAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFIXED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDEPTH_COMPONENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRGB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRGBA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLUMINANCE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLUMINANCE_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DUNSIGNED_SHORT_4_4_4_4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DUNSIGNED_SHORT_5_5_5_1(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DUNSIGNED_SHORT_5_6_5(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAGMENT_SHADER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVERTEX_SHADER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_VERTEX_ATTRIBS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_VERTEX_UNIFORM_VECTORS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_VARYING_VECTORS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_COMBINED_TEXTURE_IMAGE_UNITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_VERTEX_TEXTURE_IMAGE_UNITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_TEXTURE_IMAGE_UNITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_FRAGMENT_UNIFORM_VECTORS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSHADER_TYPE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDELETE_STATUS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLINK_STATUS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVALIDATE_STATUS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DATTACHED_SHADERS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DACTIVE_UNIFORMS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DACTIVE_UNIFORM_MAX_LENGTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DACTIVE_ATTRIBUTES(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DACTIVE_ATTRIBUTE_MAX_LENGTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSHADING_LANGUAGE_VERSION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCURRENT_PROGRAM(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNEVER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLESS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DEQUAL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLEQUAL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DGREATER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNOTEQUAL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DGEQUAL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DALWAYS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DKEEP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DREPLACE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINCR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDECR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINVERT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINCR_WRAP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDECR_WRAP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVENDOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVERSION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DEXTENSIONS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNEAREST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLINEAR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNEAREST_MIPMAP_NEAREST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLINEAR_MIPMAP_NEAREST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNEAREST_MIPMAP_LINEAR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLINEAR_MIPMAP_LINEAR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_MAG_FILTER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_MIN_FILTER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_WRAP_S(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_WRAP_T(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_CUBE_MAP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_BINDING_CUBE_MAP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_CUBE_MAP_POSITIVE_X(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_CUBE_MAP_NEGATIVE_X(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_CUBE_MAP_POSITIVE_Y(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_CUBE_MAP_NEGATIVE_Y(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_CUBE_MAP_POSITIVE_Z(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE_CUBE_MAP_NEGATIVE_Z(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_CUBE_MAP_TEXTURE_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE0(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE1(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE5(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE6(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE7(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE8(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE9(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE10(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE11(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE12(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE13(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE14(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE15(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE16(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE17(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE18(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE19(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE20(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE21(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE22(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE23(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE24(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE25(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE26(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE27(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE28(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE29(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE30(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DTEXTURE31(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DACTIVE_TEXTURE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DREPEAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCLAMP_TO_EDGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMIRRORED_REPEAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFLOAT_VEC2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFLOAT_VEC3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFLOAT_VEC4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINT_VEC2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINT_VEC3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINT_VEC4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBOOL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBOOL_VEC2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBOOL_VEC3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DBOOL_VEC4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFLOAT_MAT2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFLOAT_MAT3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFLOAT_MAT4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSAMPLER_2D(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSAMPLER_CUBE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVERTEX_ATTRIB_ARRAY_ENABLED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVERTEX_ATTRIB_ARRAY_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVERTEX_ATTRIB_ARRAY_STRIDE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVERTEX_ATTRIB_ARRAY_TYPE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVERTEX_ATTRIB_ARRAY_NORMALIZED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVERTEX_ATTRIB_ARRAY_POINTER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DVERTEX_ATTRIB_ARRAY_BUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DIMPLEMENTATION_COLOR_READ_TYPE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DIMPLEMENTATION_COLOR_READ_FORMAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCOMPILE_STATUS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINFO_LOG_LENGTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSHADER_SOURCE_LENGTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSHADER_COMPILER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSHADER_BINARY_FORMATS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNUM_SHADER_BINARY_FORMATS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLOW_FLOAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMEDIUM_FLOAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DHIGH_FLOAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DLOW_INT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMEDIUM_INT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DHIGH_INT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRGBA4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRGB5_A1(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRGB565(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDEPTH_COMPONENT16(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_INDEX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_INDEX8(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_WIDTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_HEIGHT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_INTERNAL_FORMAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_RED_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_GREEN_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_BLUE_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_ALPHA_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_DEPTH_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_STENCIL_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_ATTACHMENT_OBJECT_TYPE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_ATTACHMENT_OBJECT_NAME(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DCOLOR_ATTACHMENT0(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DDEPTH_ATTACHMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DSTENCIL_ATTACHMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DNONE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_COMPLETE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_INCOMPLETE_ATTACHMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_INCOMPLETE_DIMENSIONS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_UNSUPPORTED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DFRAMEBUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DRENDERBUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DMAX_RENDERBUFFER_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsCanvasRenderingContext3DINVALID_FRAMEBUFFER_OPERATION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);

} // namespace WebCore

#endif // ENABLE(3D_CANVAS)

#endif
