/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#include "module.h"
#include "engine.h"
#include "hs_compat.h"

#include <athapascan-1>

static unsigned long ctr;

unsigned long get_status()
{
    return ctr;
}

int init_module(va_list * ap)
{
    int res = 0;
    try
    {
        int *argc = va_arg(*ap, int *);
        char **argv = va_arg(*ap, char **);
        a1::System::join_community(*argc, argv);
    }
    catch(...)
    {
        res = 1;
    }
    return res;
}

static const struct make_pot_param *g_param = NULL;

/*
 * functor
 */
struct mpot
{
    static const size_t threshold;
    void operator() (a1::remote < hs_potential_t * >begin,
       a1::remote < hs_potential_t * >end)
    {
        size_t n = end - begin;
        if(n > threshold)
        {
            a1::Fork < mpot > ()(begin, begin + n / 2);
            a1::Fork < mpot > () (begin + n / 2, end);
        }
        else
        {
            a1::fetch(begin, end);
            for(; begin < end; ++begin)
                make_pot((hs_potential_t *) begin, g_param);
            ctr += n;
        }
    }
};

const size_t mpot::threshold = 100;


/*
 * module entry point
 */
int make_all_pot(hs_potential_t * iter, size_t nb_iter,
   const struct make_pot_param *param)
{
    int res;
    g_param = param;

    WS::Community * com = a1::System::com;
    if(com != 0)
    {
        if(com->is_leader())
        {
            // for read-write access
            a1::remote < hs_potential_t * >begin, end;
            a1::init(begin, end, iter, iter + nb_iter);
            a1::Fork < mpot > ()(begin, end);
        }
        com->leave();
        ctr = (unsigned long) nb_iter;
        res = 1;
    }
    else
    {
        ctr = (unsigned long) nb_iter;
        res = 0;
    }

    g_param = NULL;

    return res;
}

/*
 * stream operators
 */

a1::IStream & operator>>(a1::IStream & i, hs_potential_t & p)
{
    return i >> p.lat >> p.lon >> p.pot;
}

a1::OStream & operator<<(a1::OStream & o, const hs_potential_t & p)
{
    return o << p.lat << p.lon << p.pot;
}
