/*
 *  hubcot_ctl.c: controling Hubcot
 *
 *  Copyright (C) 2001 Tomoaki MITSUYOSHI <micchan@geocities.co.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  This source made use of the result of uhubcot driver for NetBSD
 *  by Takuya SHIOZAKI <tshiozak@netbsd.org>.
 *
 *  "Hubcot" is trademarked by Dreams come true co.,Ltd.
 */

/* $Id: hubcot_ctl.c,v 1.3 2001/06/30 08:18:27 mitsu Exp mitsu $ */

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include "hubcot.h"

#define HUBCOT_DEVICE_NAME  "/dev/usb/hubcot"

static void usage (void)
{
  fprintf (stderr, "usage: hubcot_ctl -r <Request Type> -s <Speed>\n");
  fprintf (stderr, "Request Type: 0x00 ... HUBCOT_REQ_NOOP\n");
  fprintf (stderr, "              0x01 ... HUBCOT_REQ_RIGHT\n");
  fprintf (stderr, "              0x02 ... HUBCOT_REQ_LEFT\n");
  fprintf (stderr, "              0x03 ... HUBCOT_REQ_BOTH\n");
  fprintf (stderr, "              0x04 ... HUBCOT_REQ_BOTH_QUAD\n");
  fprintf (stderr, "              0x05 ... HUBCOT_REQ_LRLRLR\n");
  fprintf (stderr, "              0x06 ... HUBCOT_REQ_RIGHT_TRIPLE\n");
  fprintf (stderr, "              0x08 ... HUBCOT_REQ_BOTH_TRIPLE\n");
  fprintf (stderr, "              0x0B ... HUBCOT_REQ_RL\n");
  fprintf (stderr, "              0x0C ... HUBCOT_REQ_RLRLRL\n");
  fprintf (stderr, "       Speed: 0 (Fast) <---> ??? (Slow)\n");
  fprintf (stderr, "\nExample: hubcot_ctl -r 5 -s 100\n");

  exit (0);
}

/*---------------------------------------------------------------------------*
 * hubcot_send_request:
 *   send the request to hubcot
 *---------------------------------------------------------------------------*/
static void hubcot_send_request (unsigned int reqtype, unsigned long speed)
{
  int fd;

  fd = open (HUBCOT_DEVICE_NAME, O_RDWR);
  if (fd == -1) {
    perror ("open:" HUBCOT_DEVICE_NAME);
    return;
  }

  if (ioctl (fd, reqtype, speed) == -1) {
    perror ("ioctl:hubcot");
  }
  close (fd);
}


/***************************************************************************
 * main
 ***************************************************************************/
main (int argc, char** argv)
{
  unsigned int reqtype;
  unsigned long speed;

  /* check the command line (very poor method, needless to say ^^;; ) */
  if (argc != 5 ||
      strcmp (argv[1], "-r") ||
      strcmp (argv[3], "-s")) {
    usage ();
  }

  reqtype = strtol (argv[2], NULL, 0);
  speed   = strtol (argv[4], NULL, 0);


  printf ("reqtype = 0x%2.2x / speed = %d\n", reqtype, speed);
  hubcot_send_request (reqtype, speed);

  exit (0);
}
