/*
 * This file is part of Hubbub.
 * Licensed under the MIT License,
 *                http://www.opensource.org/licenses/mit-license.php
 * Copyright 2007 John-Mark Bell <jmb@netsurf-browser.org>
 */

#include "utils/dict.h"
#include "utils/utils.h"
#include "tokeniser/entities.h"

typedef struct hubbub_entity hubbub_entity;

/**
 * Entity mapping table
 */
static const struct hubbub_entity {
	const char *name;		/**< Entity name */
	uint32_t ucs4;			/**< UCS-4 codepoint */
} entities[] = {
	{ "Aacute;", 0x000C1 },
	{ "Aacute", 0x000C1 },
	{ "aacute;", 0x000E1 },
	{ "aacute", 0x000E1 },
	{ "Abreve;", 0x00102 },
	{ "abreve;", 0x00103 },
	{ "ac;", 0x0223E },
	{ "acd;", 0x0223F },
	{ "Acirc;", 0x000C2 },
	{ "Acirc", 0x000C2 },
	{ "acirc;", 0x000E2 },
	{ "acirc", 0x000E2 },
	{ "acute;", 0x000B4 },
	{ "acute", 0x000B4 },
	{ "Acy;", 0x00410 },
	{ "acy;", 0x00430 },
	{ "AElig;", 0x000C6 },
	{ "AElig", 0x000C6 },
	{ "aelig;", 0x000E6 },
	{ "aelig", 0x000E6 },
	{ "af;", 0x02061 },
	{ "Afr;", 0x1D504 },
	{ "afr;", 0x1D51E },
	{ "Agrave;", 0x000C0 },
	{ "Agrave", 0x000C0 },
	{ "agrave;", 0x000E0 },
	{ "agrave", 0x000E0 },
	{ "alefsym;", 0x02135 },
	{ "aleph;", 0x02135 },
	{ "Alpha;", 0x00391 },
	{ "alpha;", 0x003B1 },
	{ "Amacr;", 0x00100 },
	{ "amacr;", 0x00101 },
	{ "amalg;", 0x02A3F },
	{ "amp;", 0x00026 },
	{ "amp", 0x00026 },
	{ "AMP;", 0x00026 },
	{ "AMP", 0x00026 },
	{ "and;", 0x02227 },
	{ "And;", 0x02A53 },
	{ "andand;", 0x02A55 },
	{ "andd;", 0x02A5C },
	{ "andslope;", 0x02A58 },
	{ "andv;", 0x02A5A },
	{ "ang;", 0x02220 },
	{ "ange;", 0x029A4 },
	{ "angle;", 0x02220 },
	{ "angmsd;", 0x02221 },
	{ "angmsdaa;", 0x029A8 },
	{ "angmsdab;", 0x029A9 },
	{ "angmsdac;", 0x029AA },
	{ "angmsdad;", 0x029AB },
	{ "angmsdae;", 0x029AC },
	{ "angmsdaf;", 0x029AD },
	{ "angmsdag;", 0x029AE },
	{ "angmsdah;", 0x029AF },
	{ "angrt;", 0x0221F },
	{ "angrtvb;", 0x022BE },
	{ "angrtvbd;", 0x0299D },
	{ "angsph;", 0x02222 },
	{ "angst;", 0x0212B },
	{ "angzarr;", 0x0237C },
	{ "Aogon;", 0x00104 },
	{ "aogon;", 0x00105 },
	{ "Aopf;", 0x1D538 },
	{ "aopf;", 0x1D552 },
	{ "ap;", 0x02248 },
	{ "apacir;", 0x02A6F },
	{ "ape;", 0x0224A },
	{ "apE;", 0x02A70 },
	{ "apid;", 0x0224B },
	{ "apos;", 0x00027 },
	{ "ApplyFunction;", 0x02061 },
	{ "approx;", 0x02248 },
	{ "approxeq;", 0x0224A },
	{ "Aring;", 0x000C5 },
	{ "Aring", 0x000C5 },
	{ "aring;", 0x000E5 },
	{ "aring", 0x000E5 },
	{ "Ascr;", 0x1D49C },
	{ "ascr;", 0x1D4B6 },
	{ "Assign;", 0x02254 },
	{ "ast;", 0x0002A },
	{ "asymp;", 0x02248 },
	{ "asympeq;", 0x0224D },
	{ "Atilde;", 0x000C3 },
	{ "Atilde", 0x000C3 },
	{ "atilde;", 0x000E3 },
	{ "atilde", 0x000E3 },
	{ "Auml;", 0x000C4 },
	{ "Auml", 0x000C4 },
	{ "auml;", 0x000E4 },
	{ "auml", 0x000E4 },
	{ "awconint;", 0x02233 },
	{ "awint;", 0x02A11 },
	{ "backcong;", 0x0224C },
	{ "backepsilon;", 0x003F6 },
	{ "backprime;", 0x02035 },
	{ "backsim;", 0x0223D },
	{ "backsimeq;", 0x022CD },
	{ "Backslash;", 0x02216 },
	{ "Barv;", 0x02AE7 },
	{ "barvee;", 0x022BD },
	{ "barwed;", 0x02305 },
	{ "Barwed;", 0x02306 },
	{ "barwedge;", 0x02305 },
	{ "bbrk;", 0x023B5 },
	{ "bbrktbrk;", 0x023B6 },
	{ "bcong;", 0x0224C },
	{ "Bcy;", 0x00411 },
	{ "bcy;", 0x00431 },
	{ "bdquo;", 0x0201E },
	{ "becaus;", 0x02235 },
	{ "because;", 0x02235 },
	{ "Because;", 0x02235 },
	{ "bemptyv;", 0x029B0 },
	{ "bepsi;", 0x003F6 },
	{ "bernou;", 0x0212C },
	{ "Bernoullis;", 0x0212C },
	{ "Beta;", 0x00392 },
	{ "beta;", 0x003B2 },
	{ "beth;", 0x02136 },
	{ "between;", 0x0226C },
	{ "Bfr;", 0x1D505 },
	{ "bfr;", 0x1D51F },
	{ "bigcap;", 0x022C2 },
	{ "bigcirc;", 0x025EF },
	{ "bigcup;", 0x022C3 },
	{ "bigodot;", 0x02A00 },
	{ "bigoplus;", 0x02A01 },
	{ "bigotimes;", 0x02A02 },
	{ "bigsqcup;", 0x02A06 },
	{ "bigstar;", 0x02605 },
	{ "bigtriangledown;", 0x025BD },
	{ "bigtriangleup;", 0x025B3 },
	{ "biguplus;", 0x02A04 },
	{ "bigvee;", 0x022C1 },
	{ "bigwedge;", 0x022C0 },
	{ "bkarow;", 0x0290D },
	{ "blacklozenge;", 0x029EB },
	{ "blacksquare;", 0x025AA },
	{ "blacktriangle;", 0x025B4 },
	{ "blacktriangledown;", 0x025BE },
	{ "blacktriangleleft;", 0x025C2 },
	{ "blacktriangleright;", 0x025B8 },
	{ "blank;", 0x02423 },
	{ "blk12;", 0x02592 },
	{ "blk14;", 0x02591 },
	{ "blk34;", 0x02593 },
	{ "block;", 0x02588 },
	{ "bnot;", 0x02310 },
	{ "bNot;", 0x02AED },
	{ "Bopf;", 0x1D539 },
	{ "bopf;", 0x1D553 },
	{ "bot;", 0x022A5 },
	{ "bottom;", 0x022A5 },
	{ "bowtie;", 0x022C8 },
	{ "boxbox;", 0x029C9 },
	{ "boxdl;", 0x02510 },
	{ "boxdL;", 0x02555 },
	{ "boxDl;", 0x02556 },
	{ "boxDL;", 0x02557 },
	{ "boxdr;", 0x0250C },
	{ "boxdR;", 0x02552 },
	{ "boxDr;", 0x02553 },
	{ "boxDR;", 0x02554 },
	{ "boxh;", 0x02500 },
	{ "boxH;", 0x02550 },
	{ "boxhd;", 0x0252C },
	{ "boxHd;", 0x02564 },
	{ "boxhD;", 0x02565 },
	{ "boxHD;", 0x02566 },
	{ "boxhu;", 0x02534 },
	{ "boxHu;", 0x02567 },
	{ "boxhU;", 0x02568 },
	{ "boxHU;", 0x02569 },
	{ "boxminus;", 0x0229F },
	{ "boxplus;", 0x0229E },
	{ "boxtimes;", 0x022A0 },
	{ "boxul;", 0x02518 },
	{ "boxuL;", 0x0255B },
	{ "boxUl;", 0x0255C },
	{ "boxUL;", 0x0255D },
	{ "boxur;", 0x02514 },
	{ "boxuR;", 0x02558 },
	{ "boxUr;", 0x02559 },
	{ "boxUR;", 0x0255A },
	{ "boxv;", 0x02502 },
	{ "boxV;", 0x02551 },
	{ "boxvh;", 0x0253C },
	{ "boxvH;", 0x0256A },
	{ "boxVh;", 0x0256B },
	{ "boxVH;", 0x0256C },
	{ "boxvl;", 0x02524 },
	{ "boxvL;", 0x02561 },
	{ "boxVl;", 0x02562 },
	{ "boxVL;", 0x02563 },
	{ "boxvr;", 0x0251C },
	{ "boxvR;", 0x0255E },
	{ "boxVr;", 0x0255F },
	{ "boxVR;", 0x02560 },
	{ "bprime;", 0x02035 },
	{ "breve;", 0x002D8 },
	{ "Breve;", 0x002D8 },
	{ "brvbar;", 0x000A6 },
	{ "brvbar", 0x000A6 },
	{ "Bscr;", 0x0212C },
	{ "bscr;", 0x1D4B7 },
	{ "bsemi;", 0x0204F },
	{ "bsim;", 0x0223D },
	{ "bsime;", 0x022CD },
	{ "bsol;", 0x0005C },
	{ "bsolb;", 0x029C5 },
	{ "bull;", 0x02022 },
	{ "bullet;", 0x02022 },
	{ "bump;", 0x0224E },
	{ "bumpe;", 0x0224F },
	{ "bumpE;", 0x02AAE },
	{ "Bumpeq;", 0x0224E },
	{ "bumpeq;", 0x0224F },
	{ "Cacute;", 0x00106 },
	{ "cacute;", 0x00107 },
	{ "cap;", 0x02229 },
	{ "Cap;", 0x022D2 },
	{ "capand;", 0x02A44 },
	{ "capbrcup;", 0x02A49 },
	{ "capcap;", 0x02A4B },
	{ "capcup;", 0x02A47 },
	{ "capdot;", 0x02A40 },
	{ "CapitalDifferentialD;", 0x02145 },
	{ "caret;", 0x02041 },
	{ "caron;", 0x002C7 },
	{ "Cayleys;", 0x0212D },
	{ "ccaps;", 0x02A4D },
	{ "Ccaron;", 0x0010C },
	{ "ccaron;", 0x0010D },
	{ "Ccedil;", 0x000C7 },
	{ "Ccedil", 0x000C7 },
	{ "ccedil;", 0x000E7 },
	{ "ccedil", 0x000E7 },
	{ "Ccirc;", 0x00108 },
	{ "ccirc;", 0x00109 },
	{ "Cconint;", 0x02230 },
	{ "ccups;", 0x02A4C },
	{ "ccupssm;", 0x02A50 },
	{ "Cdot;", 0x0010A },
	{ "cdot;", 0x0010B },
	{ "cedil;", 0x000B8 },
	{ "cedil", 0x000B8 },
	{ "Cedilla;", 0x000B8 },
	{ "cemptyv;", 0x029B2 },
	{ "cent;", 0x000A2 },
	{ "cent", 0x000A2 },
	{ "centerdot;", 0x000B7 },
	{ "CenterDot;", 0x000B7 },
	{ "Cfr;", 0x0212D },
	{ "cfr;", 0x1D520 },
	{ "CHcy;", 0x00427 },
	{ "chcy;", 0x00447 },
	{ "check;", 0x02713 },
	{ "checkmark;", 0x02713 },
	{ "Chi;", 0x003A7 },
	{ "chi;", 0x003C7 },
	{ "cir;", 0x025CB },
	{ "circ;", 0x002C6 },
	{ "circeq;", 0x02257 },
	{ "circlearrowleft;", 0x021BA },
	{ "circlearrowright;", 0x021BB },
	{ "circledast;", 0x0229B },
	{ "circledcirc;", 0x0229A },
	{ "circleddash;", 0x0229D },
	{ "CircleDot;", 0x02299 },
	{ "circledR;", 0x000AE },
	{ "circledS;", 0x024C8 },
	{ "CircleMinus;", 0x02296 },
	{ "CirclePlus;", 0x02295 },
	{ "CircleTimes;", 0x02297 },
	{ "cire;", 0x02257 },
	{ "cirE;", 0x029C3 },
	{ "cirfnint;", 0x02A10 },
	{ "cirmid;", 0x02AEF },
	{ "cirscir;", 0x029C2 },
	{ "ClockwiseContourIntegral;", 0x02232 },
	{ "CloseCurlyDoubleQuote;", 0x0201D },
	{ "CloseCurlyQuote;", 0x02019 },
	{ "clubs;", 0x02663 },
	{ "clubsuit;", 0x02663 },
	{ "colon;", 0x0003A },
	{ "Colon;", 0x02237 },
	{ "colone;", 0x02254 },
	{ "Colone;", 0x02A74 },
	{ "coloneq;", 0x02254 },
	{ "comma;", 0x0002C },
	{ "commat;", 0x00040 },
	{ "comp;", 0x02201 },
	{ "compfn;", 0x02218 },
	{ "complement;", 0x02201 },
	{ "complexes;", 0x02102 },
	{ "cong;", 0x02245 },
	{ "congdot;", 0x02A6D },
	{ "Congruent;", 0x02261 },
	{ "conint;", 0x0222E },
	{ "Conint;", 0x0222F },
	{ "ContourIntegral;", 0x0222E },
	{ "Copf;", 0x02102 },
	{ "copf;", 0x1D554 },
	{ "coprod;", 0x02210 },
	{ "Coproduct;", 0x02210 },
	{ "copy;", 0x000A9 },
	{ "copy", 0x000A9 },
	{ "COPY;", 0x000A9 },
	{ "COPY", 0x000A9 },
	{ "copysr;", 0x02117 },
	{ "CounterClockwiseContourIntegral;", 0x02233 },
	{ "crarr;", 0x021B5 },
	{ "cross;", 0x02717 },
	{ "Cross;", 0x02A2F },
	{ "Cscr;", 0x1D49E },
	{ "cscr;", 0x1D4B8 },
	{ "csub;", 0x02ACF },
	{ "csube;", 0x02AD1 },
	{ "csup;", 0x02AD0 },
	{ "csupe;", 0x02AD2 },
	{ "ctdot;", 0x022EF },
	{ "cudarrl;", 0x02938 },
	{ "cudarrr;", 0x02935 },
	{ "cuepr;", 0x022DE },
	{ "cuesc;", 0x022DF },
	{ "cularr;", 0x021B6 },
	{ "cularrp;", 0x0293D },
	{ "cup;", 0x0222A },
	{ "Cup;", 0x022D3 },
	{ "cupbrcap;", 0x02A48 },
	{ "CupCap;", 0x0224D },
	{ "cupcap;", 0x02A46 },
	{ "cupcup;", 0x02A4A },
	{ "cupdot;", 0x0228D },
	{ "cupor;", 0x02A45 },
	{ "curarr;", 0x021B7 },
	{ "curarrm;", 0x0293C },
	{ "curlyeqprec;", 0x022DE },
	{ "curlyeqsucc;", 0x022DF },
	{ "curlyvee;", 0x022CE },
	{ "curlywedge;", 0x022CF },
	{ "curren;", 0x000A4 },
	{ "curren", 0x000A4 },
	{ "curvearrowleft;", 0x021B6 },
	{ "curvearrowright;", 0x021B7 },
	{ "cuvee;", 0x022CE },
	{ "cuwed;", 0x022CF },
	{ "cwconint;", 0x02232 },
	{ "cwint;", 0x02231 },
	{ "cylcty;", 0x0232D },
	{ "dagger;", 0x02020 },
	{ "Dagger;", 0x02021 },
	{ "daleth;", 0x02138 },
	{ "darr;", 0x02193 },
	{ "Darr;", 0x021A1 },
	{ "dArr;", 0x021D3 },
	{ "dash;", 0x02010 },
	{ "dashv;", 0x022A3 },
	{ "Dashv;", 0x02AE4 },
	{ "dbkarow;", 0x0290F },
	{ "dblac;", 0x002DD },
	{ "Dcaron;", 0x0010E },
	{ "dcaron;", 0x0010F },
	{ "Dcy;", 0x00414 },
	{ "dcy;", 0x00434 },
	{ "DD;", 0x02145 },
	{ "dd;", 0x02146 },
	{ "ddagger;", 0x02021 },
	{ "ddarr;", 0x021CA },
	{ "DDotrahd;", 0x02911 },
	{ "ddotseq;", 0x02A77 },
	{ "deg;", 0x000B0 },
	{ "deg", 0x000B0 },
	{ "Del;", 0x02207 },
	{ "Delta;", 0x00394 },
	{ "delta;", 0x003B4 },
	{ "demptyv;", 0x029B1 },
	{ "dfisht;", 0x0297F },
	{ "Dfr;", 0x1D507 },
	{ "dfr;", 0x1D521 },
	{ "dHar;", 0x02965 },
	{ "dharl;", 0x021C3 },
	{ "dharr;", 0x021C2 },
	{ "DiacriticalAcute;", 0x000B4 },
	{ "DiacriticalDot;", 0x002D9 },
	{ "DiacriticalDoubleAcute;", 0x002DD },
	{ "DiacriticalGrave;", 0x00060 },
	{ "DiacriticalTilde;", 0x002DC },
	{ "diam;", 0x022C4 },
	{ "diamond;", 0x022C4 },
	{ "Diamond;", 0x022C4 },
	{ "diamondsuit;", 0x02666 },
	{ "diams;", 0x02666 },
	{ "die;", 0x000A8 },
	{ "DifferentialD;", 0x02146 },
	{ "digamma;", 0x003DD },
	{ "disin;", 0x022F2 },
	{ "div;", 0x000F7 },
	{ "divide;", 0x000F7 },
	{ "divide", 0x000F7 },
	{ "divideontimes;", 0x022C7 },
	{ "divonx;", 0x022C7 },
	{ "DJcy;", 0x00402 },
	{ "djcy;", 0x00452 },
	{ "dlcorn;", 0x0231E },
	{ "dlcrop;", 0x0230D },
	{ "dollar;", 0x00024 },
	{ "Dopf;", 0x1D53B },
	{ "dopf;", 0x1D555 },
	{ "Dot;", 0x000A8 },
	{ "dot;", 0x002D9 },
	{ "DotDot;", 0x020DC },
	{ "doteq;", 0x02250 },
	{ "doteqdot;", 0x02251 },
	{ "DotEqual;", 0x02250 },
	{ "dotminus;", 0x02238 },
	{ "dotplus;", 0x02214 },
	{ "dotsquare;", 0x022A1 },
	{ "doublebarwedge;", 0x02306 },
	{ "DoubleContourIntegral;", 0x0222F },
	{ "DoubleDot;", 0x000A8 },
	{ "DoubleDownArrow;", 0x021D3 },
	{ "DoubleLeftArrow;", 0x021D0 },
	{ "DoubleLeftRightArrow;", 0x021D4 },
	{ "DoubleLeftTee;", 0x02AE4 },
	{ "DoubleLongLeftArrow;", 0x027F8 },
	{ "DoubleLongLeftRightArrow;", 0x027FA },
	{ "DoubleLongRightArrow;", 0x027F9 },
	{ "DoubleRightArrow;", 0x021D2 },
	{ "DoubleRightTee;", 0x022A8 },
	{ "DoubleUpArrow;", 0x021D1 },
	{ "DoubleUpDownArrow;", 0x021D5 },
	{ "DoubleVerticalBar;", 0x02225 },
	{ "downarrow;", 0x02193 },
	{ "DownArrow;", 0x02193 },
	{ "Downarrow;", 0x021D3 },
	{ "DownArrowBar;", 0x02913 },
	{ "DownArrowUpArrow;", 0x021F5 },
	{ "DownBreve;", 0x00311 },
	{ "downdownarrows;", 0x021CA },
	{ "downharpoonleft;", 0x021C3 },
	{ "downharpoonright;", 0x021C2 },
	{ "DownLeftRightVector;", 0x02950 },
	{ "DownLeftTeeVector;", 0x0295E },
	{ "DownLeftVector;", 0x021BD },
	{ "DownLeftVectorBar;", 0x02956 },
	{ "DownRightTeeVector;", 0x0295F },
	{ "DownRightVector;", 0x021C1 },
	{ "DownRightVectorBar;", 0x02957 },
	{ "DownTee;", 0x022A4 },
	{ "DownTeeArrow;", 0x021A7 },
	{ "drbkarow;", 0x02910 },
	{ "drcorn;", 0x0231F },
	{ "drcrop;", 0x0230C },
	{ "Dscr;", 0x1D49F },
	{ "dscr;", 0x1D4B9 },
	{ "DScy;", 0x00405 },
	{ "dscy;", 0x00455 },
	{ "dsol;", 0x029F6 },
	{ "Dstrok;", 0x00110 },
	{ "dstrok;", 0x00111 },
	{ "dtdot;", 0x022F1 },
	{ "dtri;", 0x025BF },
	{ "dtrif;", 0x025BE },
	{ "duarr;", 0x021F5 },
	{ "duhar;", 0x0296F },
	{ "dwangle;", 0x029A6 },
	{ "DZcy;", 0x0040F },
	{ "dzcy;", 0x0045F },
	{ "dzigrarr;", 0x027FF },
	{ "Eacute;", 0x000C9 },
	{ "Eacute", 0x000C9 },
	{ "eacute;", 0x000E9 },
	{ "eacute", 0x000E9 },
	{ "easter;", 0x02A6E },
	{ "Ecaron;", 0x0011A },
	{ "ecaron;", 0x0011B },
	{ "ecir;", 0x02256 },
	{ "Ecirc;", 0x000CA },
	{ "Ecirc", 0x000CA },
	{ "ecirc;", 0x000EA },
	{ "ecirc", 0x000EA },
	{ "ecolon;", 0x02255 },
	{ "Ecy;", 0x0042D },
	{ "ecy;", 0x0044D },
	{ "eDDot;", 0x02A77 },
	{ "Edot;", 0x00116 },
	{ "edot;", 0x00117 },
	{ "eDot;", 0x02251 },
	{ "ee;", 0x02147 },
	{ "efDot;", 0x02252 },
	{ "Efr;", 0x1D508 },
	{ "efr;", 0x1D522 },
	{ "eg;", 0x02A9A },
	{ "Egrave;", 0x000C8 },
	{ "Egrave", 0x000C8 },
	{ "egrave;", 0x000E8 },
	{ "egrave", 0x000E8 },
	{ "egs;", 0x02A96 },
	{ "egsdot;", 0x02A98 },
	{ "el;", 0x02A99 },
	{ "Element;", 0x02208 },
	{ "elinters;", 0x023E7 },
	{ "ell;", 0x02113 },
	{ "els;", 0x02A95 },
	{ "elsdot;", 0x02A97 },
	{ "Emacr;", 0x00112 },
	{ "emacr;", 0x00113 },
	{ "empty;", 0x02205 },
	{ "emptyset;", 0x02205 },
	{ "EmptySmallSquare;", 0x025FB },
	{ "emptyv;", 0x02205 },
	{ "EmptyVerySmallSquare;", 0x025AB },
	{ "emsp;", 0x02003 },
	{ "emsp13;", 0x02004 },
	{ "emsp14;", 0x02005 },
	{ "ENG;", 0x0014A },
	{ "eng;", 0x0014B },
	{ "ensp;", 0x02002 },
	{ "Eogon;", 0x00118 },
	{ "eogon;", 0x00119 },
	{ "Eopf;", 0x1D53C },
	{ "eopf;", 0x1D556 },
	{ "epar;", 0x022D5 },
	{ "eparsl;", 0x029E3 },
	{ "eplus;", 0x02A71 },
	{ "epsi;", 0x003F5 },
	{ "Epsilon;", 0x00395 },
	{ "epsilon;", 0x003B5 },
	{ "epsiv;", 0x003B5 },
	{ "eqcirc;", 0x02256 },
	{ "eqcolon;", 0x02255 },
	{ "eqsim;", 0x02242 },
	{ "eqslantgtr;", 0x02A96 },
	{ "eqslantless;", 0x02A95 },
	{ "Equal;", 0x02A75 },
	{ "equals;", 0x0003D },
	{ "EqualTilde;", 0x02242 },
	{ "equest;", 0x0225F },
	{ "Equilibrium;", 0x021CC },
	{ "equiv;", 0x02261 },
	{ "equivDD;", 0x02A78 },
	{ "eqvparsl;", 0x029E5 },
	{ "erarr;", 0x02971 },
	{ "erDot;", 0x02253 },
	{ "escr;", 0x0212F },
	{ "Escr;", 0x02130 },
	{ "esdot;", 0x02250 },
	{ "esim;", 0x02242 },
	{ "Esim;", 0x02A73 },
	{ "Eta;", 0x00397 },
	{ "eta;", 0x003B7 },
	{ "ETH;", 0x000D0 },
	{ "ETH", 0x000D0 },
	{ "eth;", 0x000F0 },
	{ "eth", 0x000F0 },
	{ "Euml;", 0x000CB },
	{ "Euml", 0x000CB },
	{ "euml;", 0x000EB },
	{ "euml", 0x000EB },
	{ "euro;", 0x020AC },
	{ "excl;", 0x00021 },
	{ "exist;", 0x02203 },
	{ "Exists;", 0x02203 },
	{ "expectation;", 0x02130 },
	{ "exponentiale;", 0x02147 },
	{ "ExponentialE;", 0x02147 },
	{ "fallingdotseq;", 0x02252 },
	{ "Fcy;", 0x00424 },
	{ "fcy;", 0x00444 },
	{ "female;", 0x02640 },
	{ "ffilig;", 0x0FB03 },
	{ "fflig;", 0x0FB00 },
	{ "ffllig;", 0x0FB04 },
	{ "Ffr;", 0x1D509 },
	{ "ffr;", 0x1D523 },
	{ "filig;", 0x0FB01 },
	{ "FilledSmallSquare;", 0x025FC },
	{ "FilledVerySmallSquare;", 0x025AA },
	{ "flat;", 0x0266D },
	{ "fllig;", 0x0FB02 },
	{ "fltns;", 0x025B1 },
	{ "fnof;", 0x00192 },
	{ "Fopf;", 0x1D53D },
	{ "fopf;", 0x1D557 },
	{ "forall;", 0x02200 },
	{ "ForAll;", 0x02200 },
	{ "fork;", 0x022D4 },
	{ "forkv;", 0x02AD9 },
	{ "Fouriertrf;", 0x02131 },
	{ "fpartint;", 0x02A0D },
	{ "frac12;", 0x000BD },
	{ "frac12", 0x000BD },
	{ "frac13;", 0x02153 },
	{ "frac14;", 0x000BC },
	{ "frac14", 0x000BC },
	{ "frac15;", 0x02155 },
	{ "frac16;", 0x02159 },
	{ "frac18;", 0x0215B },
	{ "frac23;", 0x02154 },
	{ "frac25;", 0x02156 },
	{ "frac34;", 0x000BE },
	{ "frac34", 0x000BE },
	{ "frac35;", 0x02157 },
	{ "frac38;", 0x0215C },
	{ "frac45;", 0x02158 },
	{ "frac56;", 0x0215A },
	{ "frac58;", 0x0215D },
	{ "frac78;", 0x0215E },
	{ "frasl;", 0x02044 },
	{ "frown;", 0x02322 },
	{ "Fscr;", 0x02131 },
	{ "fscr;", 0x1D4BB },
	{ "gacute;", 0x001F5 },
	{ "Gamma;", 0x00393 },
	{ "gamma;", 0x003B3 },
	{ "Gammad;", 0x003DC },
	{ "gammad;", 0x003DD },
	{ "gap;", 0x02A86 },
	{ "Gbreve;", 0x0011E },
	{ "gbreve;", 0x0011F },
	{ "Gcedil;", 0x00122 },
	{ "Gcirc;", 0x0011C },
	{ "gcirc;", 0x0011D },
	{ "Gcy;", 0x00413 },
	{ "gcy;", 0x00433 },
	{ "Gdot;", 0x00120 },
	{ "gdot;", 0x00121 },
	{ "ge;", 0x02265 },
	{ "gE;", 0x02267 },
	{ "gel;", 0x022DB },
	{ "gEl;", 0x02A8C },
	{ "geq;", 0x02265 },
	{ "geqq;", 0x02267 },
	{ "geqslant;", 0x02A7E },
	{ "ges;", 0x02A7E },
	{ "gescc;", 0x02AA9 },
	{ "gesdot;", 0x02A80 },
	{ "gesdoto;", 0x02A82 },
	{ "gesdotol;", 0x02A84 },
	{ "gesles;", 0x02A94 },
	{ "Gfr;", 0x1D50A },
	{ "gfr;", 0x1D524 },
	{ "gg;", 0x0226B },
	{ "Gg;", 0x022D9 },
	{ "ggg;", 0x022D9 },
	{ "gimel;", 0x02137 },
	{ "GJcy;", 0x00403 },
	{ "gjcy;", 0x00453 },
	{ "gl;", 0x02277 },
	{ "gla;", 0x02AA5 },
	{ "glE;", 0x02A92 },
	{ "glj;", 0x02AA4 },
	{ "gnap;", 0x02A8A },
	{ "gnapprox;", 0x02A8A },
	{ "gnE;", 0x02269 },
	{ "gne;", 0x02A88 },
	{ "gneq;", 0x02A88 },
	{ "gneqq;", 0x02269 },
	{ "gnsim;", 0x022E7 },
	{ "Gopf;", 0x1D53E },
	{ "gopf;", 0x1D558 },
	{ "grave;", 0x00060 },
	{ "GreaterEqual;", 0x02265 },
	{ "GreaterEqualLess;", 0x022DB },
	{ "GreaterFullEqual;", 0x02267 },
	{ "GreaterGreater;", 0x02AA2 },
	{ "GreaterLess;", 0x02277 },
	{ "GreaterSlantEqual;", 0x02A7E },
	{ "GreaterTilde;", 0x02273 },
	{ "gscr;", 0x0210A },
	{ "Gscr;", 0x1D4A2 },
	{ "gsim;", 0x02273 },
	{ "gsime;", 0x02A8E },
	{ "gsiml;", 0x02A90 },
	{ "gt;", 0x0003E },
	{ "gt", 0x0003E },
	{ "GT;", 0x0003E },
	{ "GT", 0x0003E },
	{ "Gt;", 0x0226B },
	{ "gtcc;", 0x02AA7 },
	{ "gtcir;", 0x02A7A },
	{ "gtdot;", 0x022D7 },
	{ "gtlPar;", 0x02995 },
	{ "gtquest;", 0x02A7C },
	{ "gtrapprox;", 0x02A86 },
	{ "gtrarr;", 0x02978 },
	{ "gtrdot;", 0x022D7 },
	{ "gtreqless;", 0x022DB },
	{ "gtreqqless;", 0x02A8C },
	{ "gtrless;", 0x02277 },
	{ "gtrsim;", 0x02273 },
	{ "Hacek;", 0x002C7 },
	{ "hairsp;", 0x0200A },
	{ "half;", 0x000BD },
	{ "hamilt;", 0x0210B },
	{ "HARDcy;", 0x0042A },
	{ "hardcy;", 0x0044A },
	{ "harr;", 0x02194 },
	{ "hArr;", 0x021D4 },
	{ "harrcir;", 0x02948 },
	{ "harrw;", 0x021AD },
	{ "Hat;", 0x0005E },
	{ "hbar;", 0x0210F },
	{ "Hcirc;", 0x00124 },
	{ "hcirc;", 0x00125 },
	{ "hearts;", 0x02665 },
	{ "heartsuit;", 0x02665 },
	{ "hellip;", 0x02026 },
	{ "hercon;", 0x022B9 },
	{ "Hfr;", 0x0210C },
	{ "hfr;", 0x1D525 },
	{ "HilbertSpace;", 0x0210B },
	{ "hksearow;", 0x02925 },
	{ "hkswarow;", 0x02926 },
	{ "hoarr;", 0x021FF },
	{ "homtht;", 0x0223B },
	{ "hookleftarrow;", 0x021A9 },
	{ "hookrightarrow;", 0x021AA },
	{ "Hopf;", 0x0210D },
	{ "hopf;", 0x1D559 },
	{ "horbar;", 0x02015 },
	{ "HorizontalLine;", 0x02500 },
	{ "Hscr;", 0x0210B },
	{ "hscr;", 0x1D4BD },
	{ "hslash;", 0x0210F },
	{ "Hstrok;", 0x00126 },
	{ "hstrok;", 0x00127 },
	{ "HumpDownHump;", 0x0224E },
	{ "HumpEqual;", 0x0224F },
	{ "hybull;", 0x02043 },
	{ "hyphen;", 0x02010 },
	{ "Iacute;", 0x000CD },
	{ "Iacute", 0x000CD },
	{ "iacute;", 0x000ED },
	{ "iacute", 0x000ED },
	{ "ic;", 0x02063 },
	{ "Icirc;", 0x000CE },
	{ "Icirc", 0x000CE },
	{ "icirc;", 0x000EE },
	{ "icirc", 0x000EE },
	{ "Icy;", 0x00418 },
	{ "icy;", 0x00438 },
	{ "Idot;", 0x00130 },
	{ "IEcy;", 0x00415 },
	{ "iecy;", 0x00435 },
	{ "iexcl;", 0x000A1 },
	{ "iexcl", 0x000A1 },
	{ "iff;", 0x021D4 },
	{ "Ifr;", 0x02111 },
	{ "ifr;", 0x1D526 },
	{ "Igrave;", 0x000CC },
	{ "Igrave", 0x000CC },
	{ "igrave;", 0x000EC },
	{ "igrave", 0x000EC },
	{ "ii;", 0x02148 },
	{ "iiiint;", 0x02A0C },
	{ "iiint;", 0x0222D },
	{ "iinfin;", 0x029DC },
	{ "iiota;", 0x02129 },
	{ "IJlig;", 0x00132 },
	{ "ijlig;", 0x00133 },
	{ "Im;", 0x02111 },
	{ "Imacr;", 0x0012A },
	{ "imacr;", 0x0012B },
	{ "image;", 0x02111 },
	{ "ImaginaryI;", 0x02148 },
	{ "imagline;", 0x02110 },
	{ "imagpart;", 0x02111 },
	{ "imath;", 0x00131 },
	{ "imof;", 0x022B7 },
	{ "imped;", 0x001B5 },
	{ "Implies;", 0x021D2 },
	{ "in;", 0x02208 },
	{ "incare;", 0x02105 },
	{ "infin;", 0x0221E },
	{ "infintie;", 0x029DD },
	{ "inodot;", 0x00131 },
	{ "int;", 0x0222B },
	{ "Int;", 0x0222C },
	{ "intcal;", 0x022BA },
	{ "integers;", 0x02124 },
	{ "Integral;", 0x0222B },
	{ "intercal;", 0x022BA },
	{ "Intersection;", 0x022C2 },
	{ "intlarhk;", 0x02A17 },
	{ "intprod;", 0x02A3C },
	{ "InvisibleComma;", 0x02063 },
	{ "InvisibleTimes;", 0x02062 },
	{ "IOcy;", 0x00401 },
	{ "iocy;", 0x00451 },
	{ "Iogon;", 0x0012E },
	{ "iogon;", 0x0012F },
	{ "Iopf;", 0x1D540 },
	{ "iopf;", 0x1D55A },
	{ "Iota;", 0x00399 },
	{ "iota;", 0x003B9 },
	{ "iprod;", 0x02A3C },
	{ "iquest;", 0x000BF },
	{ "iquest", 0x000BF },
	{ "Iscr;", 0x02110 },
	{ "iscr;", 0x1D4BE },
	{ "isin;", 0x02208 },
	{ "isindot;", 0x022F5 },
	{ "isinE;", 0x022F9 },
	{ "isins;", 0x022F4 },
	{ "isinsv;", 0x022F3 },
	{ "isinv;", 0x02208 },
	{ "it;", 0x02062 },
	{ "Itilde;", 0x00128 },
	{ "itilde;", 0x00129 },
	{ "Iukcy;", 0x00406 },
	{ "iukcy;", 0x00456 },
	{ "Iuml;", 0x000CF },
	{ "Iuml", 0x000CF },
	{ "iuml;", 0x000EF },
	{ "iuml", 0x000EF },
	{ "Jcirc;", 0x00134 },
	{ "jcirc;", 0x00135 },
	{ "Jcy;", 0x00419 },
	{ "jcy;", 0x00439 },
	{ "Jfr;", 0x1D50D },
	{ "jfr;", 0x1D527 },
	{ "jmath;", 0x00237 },
	{ "Jopf;", 0x1D541 },
	{ "jopf;", 0x1D55B },
	{ "Jscr;", 0x1D4A5 },
	{ "jscr;", 0x1D4BF },
	{ "Jsercy;", 0x00408 },
	{ "jsercy;", 0x00458 },
	{ "Jukcy;", 0x00404 },
	{ "jukcy;", 0x00454 },
	{ "Kappa;", 0x0039A },
	{ "kappa;", 0x003BA },
	{ "kappav;", 0x003F0 },
	{ "Kcedil;", 0x00136 },
	{ "kcedil;", 0x00137 },
	{ "Kcy;", 0x0041A },
	{ "kcy;", 0x0043A },
	{ "Kfr;", 0x1D50E },
	{ "kfr;", 0x1D528 },
	{ "kgreen;", 0x00138 },
	{ "KHcy;", 0x00425 },
	{ "khcy;", 0x00445 },
	{ "KJcy;", 0x0040C },
	{ "kjcy;", 0x0045C },
	{ "Kopf;", 0x1D542 },
	{ "kopf;", 0x1D55C },
	{ "Kscr;", 0x1D4A6 },
	{ "kscr;", 0x1D4C0 },
	{ "lAarr;", 0x021DA },
	{ "Lacute;", 0x00139 },
	{ "lacute;", 0x0013A },
	{ "laemptyv;", 0x029B4 },
	{ "lagran;", 0x02112 },
	{ "Lambda;", 0x0039B },
	{ "lambda;", 0x003BB },
	{ "lang;", 0x027E8 },
	{ "Lang;", 0x027EA },
	{ "langd;", 0x02991 },
	{ "langle;", 0x027E8 },
	{ "lap;", 0x02A85 },
	{ "Laplacetrf;", 0x02112 },
	{ "laquo;", 0x000AB },
	{ "laquo", 0x000AB },
	{ "larr;", 0x02190 },
	{ "Larr;", 0x0219E },
	{ "lArr;", 0x021D0 },
	{ "larrb;", 0x021E4 },
	{ "larrbfs;", 0x0291F },
	{ "larrfs;", 0x0291D },
	{ "larrhk;", 0x021A9 },
	{ "larrlp;", 0x021AB },
	{ "larrpl;", 0x02939 },
	{ "larrsim;", 0x02973 },
	{ "larrtl;", 0x021A2 },
	{ "lat;", 0x02AAB },
	{ "latail;", 0x02919 },
	{ "lAtail;", 0x0291B },
	{ "late;", 0x02AAD },
	{ "lbarr;", 0x0290C },
	{ "lBarr;", 0x0290E },
	{ "lbbrk;", 0x02772 },
	{ "lbrace;", 0x0007B },
	{ "lbrack;", 0x0005B },
	{ "lbrke;", 0x0298B },
	{ "lbrksld;", 0x0298F },
	{ "lbrkslu;", 0x0298D },
	{ "Lcaron;", 0x0013D },
	{ "lcaron;", 0x0013E },
	{ "Lcedil;", 0x0013B },
	{ "lcedil;", 0x0013C },
	{ "lceil;", 0x02308 },
	{ "lcub;", 0x0007B },
	{ "Lcy;", 0x0041B },
	{ "lcy;", 0x0043B },
	{ "ldca;", 0x02936 },
	{ "ldquo;", 0x0201C },
	{ "ldquor;", 0x0201E },
	{ "ldrdhar;", 0x02967 },
	{ "ldrushar;", 0x0294B },
	{ "ldsh;", 0x021B2 },
	{ "le;", 0x02264 },
	{ "lE;", 0x02266 },
	{ "LeftAngleBracket;", 0x027E8 },
	{ "leftarrow;", 0x02190 },
	{ "LeftArrow;", 0x02190 },
	{ "Leftarrow;", 0x021D0 },
	{ "LeftArrowBar;", 0x021E4 },
	{ "LeftArrowRightArrow;", 0x021C6 },
	{ "leftarrowtail;", 0x021A2 },
	{ "LeftCeiling;", 0x02308 },
	{ "LeftDoubleBracket;", 0x027E6 },
	{ "LeftDownTeeVector;", 0x02961 },
	{ "LeftDownVector;", 0x021C3 },
	{ "LeftDownVectorBar;", 0x02959 },
	{ "LeftFloor;", 0x0230A },
	{ "leftharpoondown;", 0x021BD },
	{ "leftharpoonup;", 0x021BC },
	{ "leftleftarrows;", 0x021C7 },
	{ "leftrightarrow;", 0x02194 },
	{ "LeftRightArrow;", 0x02194 },
	{ "Leftrightarrow;", 0x021D4 },
	{ "leftrightarrows;", 0x021C6 },
	{ "leftrightharpoons;", 0x021CB },
	{ "leftrightsquigarrow;", 0x021AD },
	{ "LeftRightVector;", 0x0294E },
	{ "LeftTee;", 0x022A3 },
	{ "LeftTeeArrow;", 0x021A4 },
	{ "LeftTeeVector;", 0x0295A },
	{ "leftthreetimes;", 0x022CB },
	{ "LeftTriangle;", 0x022B2 },
	{ "LeftTriangleBar;", 0x029CF },
	{ "LeftTriangleEqual;", 0x022B4 },
	{ "LeftUpDownVector;", 0x02951 },
	{ "LeftUpTeeVector;", 0x02960 },
	{ "LeftUpVector;", 0x021BF },
	{ "LeftUpVectorBar;", 0x02958 },
	{ "LeftVector;", 0x021BC },
	{ "LeftVectorBar;", 0x02952 },
	{ "leg;", 0x022DA },
	{ "lEg;", 0x02A8B },
	{ "leq;", 0x02264 },
	{ "leqq;", 0x02266 },
	{ "leqslant;", 0x02A7D },
	{ "les;", 0x02A7D },
	{ "lescc;", 0x02AA8 },
	{ "lesdot;", 0x02A7F },
	{ "lesdoto;", 0x02A81 },
	{ "lesdotor;", 0x02A83 },
	{ "lesges;", 0x02A93 },
	{ "lessapprox;", 0x02A85 },
	{ "lessdot;", 0x022D6 },
	{ "lesseqgtr;", 0x022DA },
	{ "lesseqqgtr;", 0x02A8B },
	{ "LessEqualGreater;", 0x022DA },
	{ "LessFullEqual;", 0x02266 },
	{ "LessGreater;", 0x02276 },
	{ "lessgtr;", 0x02276 },
	{ "LessLess;", 0x02AA1 },
	{ "lesssim;", 0x02272 },
	{ "LessSlantEqual;", 0x02A7D },
	{ "LessTilde;", 0x02272 },
	{ "lfisht;", 0x0297C },
	{ "lfloor;", 0x0230A },
	{ "Lfr;", 0x1D50F },
	{ "lfr;", 0x1D529 },
	{ "lg;", 0x02276 },
	{ "lgE;", 0x02A91 },
	{ "lHar;", 0x02962 },
	{ "lhard;", 0x021BD },
	{ "lharu;", 0x021BC },
	{ "lharul;", 0x0296A },
	{ "lhblk;", 0x02584 },
	{ "LJcy;", 0x00409 },
	{ "ljcy;", 0x00459 },
	{ "ll;", 0x0226A },
	{ "Ll;", 0x022D8 },
	{ "llarr;", 0x021C7 },
	{ "llcorner;", 0x0231E },
	{ "Lleftarrow;", 0x021DA },
	{ "llhard;", 0x0296B },
	{ "lltri;", 0x025FA },
	{ "Lmidot;", 0x0013F },
	{ "lmidot;", 0x00140 },
	{ "lmoust;", 0x023B0 },
	{ "lmoustache;", 0x023B0 },
	{ "lnap;", 0x02A89 },
	{ "lnapprox;", 0x02A89 },
	{ "lnE;", 0x02268 },
	{ "lne;", 0x02A87 },
	{ "lneq;", 0x02A87 },
	{ "lneqq;", 0x02268 },
	{ "lnsim;", 0x022E6 },
	{ "loang;", 0x027EC },
	{ "loarr;", 0x021FD },
	{ "lobrk;", 0x027E6 },
	{ "longleftarrow;", 0x027F5 },
	{ "LongLeftArrow;", 0x027F5 },
	{ "Longleftarrow;", 0x027F8 },
	{ "longleftrightarrow;", 0x027F7 },
	{ "LongLeftRightArrow;", 0x027F7 },
	{ "Longleftrightarrow;", 0x027FA },
	{ "longmapsto;", 0x027FC },
	{ "longrightarrow;", 0x027F6 },
	{ "LongRightArrow;", 0x027F6 },
	{ "Longrightarrow;", 0x027F9 },
	{ "looparrowleft;", 0x021AB },
	{ "looparrowright;", 0x021AC },
	{ "lopar;", 0x02985 },
	{ "Lopf;", 0x1D543 },
	{ "lopf;", 0x1D55D },
	{ "loplus;", 0x02A2D },
	{ "lotimes;", 0x02A34 },
	{ "lowast;", 0x02217 },
	{ "lowbar;", 0x0005F },
	{ "LowerLeftArrow;", 0x02199 },
	{ "LowerRightArrow;", 0x02198 },
	{ "loz;", 0x025CA },
	{ "lozenge;", 0x025CA },
	{ "lozf;", 0x029EB },
	{ "lpar;", 0x00028 },
	{ "lparlt;", 0x02993 },
	{ "lrarr;", 0x021C6 },
	{ "lrcorner;", 0x0231F },
	{ "lrhar;", 0x021CB },
	{ "lrhard;", 0x0296D },
	{ "lrm;", 0x0200E },
	{ "lrtri;", 0x022BF },
	{ "lsaquo;", 0x02039 },
	{ "Lscr;", 0x02112 },
	{ "lscr;", 0x1D4C1 },
	{ "lsh;", 0x021B0 },
	{ "Lsh;", 0x021B0 },
	{ "lsim;", 0x02272 },
	{ "lsime;", 0x02A8D },
	{ "lsimg;", 0x02A8F },
	{ "lsqb;", 0x0005B },
	{ "lsquo;", 0x02018 },
	{ "lsquor;", 0x0201A },
	{ "Lstrok;", 0x00141 },
	{ "lstrok;", 0x00142 },
	{ "lt;", 0x0003C },
	{ "lt", 0x0003C },
	{ "LT;", 0x0003C },
	{ "LT", 0x0003C },
	{ "Lt;", 0x0226A },
	{ "ltcc;", 0x02AA6 },
	{ "ltcir;", 0x02A79 },
	{ "ltdot;", 0x022D6 },
	{ "lthree;", 0x022CB },
	{ "ltimes;", 0x022C9 },
	{ "ltlarr;", 0x02976 },
	{ "ltquest;", 0x02A7B },
	{ "ltri;", 0x025C3 },
	{ "ltrie;", 0x022B4 },
	{ "ltrif;", 0x025C2 },
	{ "ltrPar;", 0x02996 },
	{ "lurdshar;", 0x0294A },
	{ "luruhar;", 0x02966 },
	{ "macr;", 0x000AF },
	{ "macr", 0x000AF },
	{ "male;", 0x02642 },
	{ "malt;", 0x02720 },
	{ "maltese;", 0x02720 },
	{ "map;", 0x021A6 },
	{ "Map;", 0x02905 },
	{ "mapsto;", 0x021A6 },
	{ "mapstodown;", 0x021A7 },
	{ "mapstoleft;", 0x021A4 },
	{ "mapstoup;", 0x021A5 },
	{ "marker;", 0x025AE },
	{ "mcomma;", 0x02A29 },
	{ "Mcy;", 0x0041C },
	{ "mcy;", 0x0043C },
	{ "mdash;", 0x02014 },
	{ "mDDot;", 0x0223A },
	{ "measuredangle;", 0x02221 },
	{ "MediumSpace;", 0x0205F },
	{ "Mellintrf;", 0x02133 },
	{ "Mfr;", 0x1D510 },
	{ "mfr;", 0x1D52A },
	{ "mho;", 0x02127 },
	{ "micro;", 0x000B5 },
	{ "micro", 0x000B5 },
	{ "mid;", 0x02223 },
	{ "midast;", 0x0002A },
	{ "midcir;", 0x02AF0 },
	{ "middot;", 0x000B7 },
	{ "middot", 0x000B7 },
	{ "minus;", 0x02212 },
	{ "minusb;", 0x0229F },
	{ "minusd;", 0x02238 },
	{ "minusdu;", 0x02A2A },
	{ "MinusPlus;", 0x02213 },
	{ "mlcp;", 0x02ADB },
	{ "mldr;", 0x02026 },
	{ "mnplus;", 0x02213 },
	{ "models;", 0x022A7 },
	{ "Mopf;", 0x1D544 },
	{ "mopf;", 0x1D55E },
	{ "mp;", 0x02213 },
	{ "Mscr;", 0x02133 },
	{ "mscr;", 0x1D4C2 },
	{ "mstpos;", 0x0223E },
	{ "Mu;", 0x0039C },
	{ "mu;", 0x003BC },
	{ "multimap;", 0x022B8 },
	{ "mumap;", 0x022B8 },
	{ "nabla;", 0x02207 },
	{ "Nacute;", 0x00143 },
	{ "nacute;", 0x00144 },
	{ "nap;", 0x02249 },
	{ "napos;", 0x00149 },
	{ "napprox;", 0x02249 },
	{ "natur;", 0x0266E },
	{ "natural;", 0x0266E },
	{ "naturals;", 0x02115 },
	{ "nbsp;", 0x000A0 },
	{ "nbsp", 0x000A0 },
	{ "ncap;", 0x02A43 },
	{ "Ncaron;", 0x00147 },
	{ "ncaron;", 0x00148 },
	{ "Ncedil;", 0x00145 },
	{ "ncedil;", 0x00146 },
	{ "ncong;", 0x02247 },
	{ "ncup;", 0x02A42 },
	{ "Ncy;", 0x0041D },
	{ "ncy;", 0x0043D },
	{ "ndash;", 0x02013 },
	{ "ne;", 0x02260 },
	{ "nearhk;", 0x02924 },
	{ "nearr;", 0x02197 },
	{ "neArr;", 0x021D7 },
	{ "nearrow;", 0x02197 },
	{ "NegativeMediumSpace;", 0x0200B },
	{ "NegativeThickSpace;", 0x0200B },
	{ "NegativeThinSpace;", 0x0200B },
	{ "NegativeVeryThinSpace;", 0x0200B },
	{ "nequiv;", 0x02262 },
	{ "nesear;", 0x02928 },
	{ "NestedGreaterGreater;", 0x0226B },
	{ "NestedLessLess;", 0x0226A },
	{ "NewLine;", 0x0000A },
	{ "nexist;", 0x02204 },
	{ "nexists;", 0x02204 },
	{ "Nfr;", 0x1D511 },
	{ "nfr;", 0x1D52B },
	{ "nge;", 0x02271 },
	{ "ngeq;", 0x02271 },
	{ "ngsim;", 0x02275 },
	{ "ngt;", 0x0226F },
	{ "ngtr;", 0x0226F },
	{ "nharr;", 0x021AE },
	{ "nhArr;", 0x021CE },
	{ "nhpar;", 0x02AF2 },
	{ "ni;", 0x0220B },
	{ "nis;", 0x022FC },
	{ "nisd;", 0x022FA },
	{ "niv;", 0x0220B },
	{ "NJcy;", 0x0040A },
	{ "njcy;", 0x0045A },
	{ "nlarr;", 0x0219A },
	{ "nlArr;", 0x021CD },
	{ "nldr;", 0x02025 },
	{ "nle;", 0x02270 },
	{ "nleftarrow;", 0x0219A },
	{ "nLeftarrow;", 0x021CD },
	{ "nleftrightarrow;", 0x021AE },
	{ "nLeftrightarrow;", 0x021CE },
	{ "nleq;", 0x02270 },
	{ "nless;", 0x0226E },
	{ "nlsim;", 0x02274 },
	{ "nlt;", 0x0226E },
	{ "nltri;", 0x022EA },
	{ "nltrie;", 0x022EC },
	{ "nmid;", 0x02224 },
	{ "NoBreak;", 0x02060 },
	{ "NonBreakingSpace;", 0x000A0 },
	{ "Nopf;", 0x02115 },
	{ "nopf;", 0x1D55F },
	{ "not;", 0x000AC },
	{ "not", 0x000AC },
	{ "Not;", 0x02AEC },
	{ "NotCongruent;", 0x02262 },
	{ "NotCupCap;", 0x0226D },
	{ "NotDoubleVerticalBar;", 0x02226 },
	{ "NotElement;", 0x02209 },
	{ "NotEqual;", 0x02260 },
	{ "NotExists;", 0x02204 },
	{ "NotGreater;", 0x0226F },
	{ "NotGreaterEqual;", 0x02271 },
	{ "NotGreaterLess;", 0x02279 },
	{ "NotGreaterTilde;", 0x02275 },
	{ "notin;", 0x02209 },
	{ "notinva;", 0x02209 },
	{ "notinvb;", 0x022F7 },
	{ "notinvc;", 0x022F6 },
	{ "NotLeftTriangle;", 0x022EA },
	{ "NotLeftTriangleEqual;", 0x022EC },
	{ "NotLess;", 0x0226E },
	{ "NotLessEqual;", 0x02270 },
	{ "NotLessGreater;", 0x02278 },
	{ "NotLessTilde;", 0x02274 },
	{ "notni;", 0x0220C },
	{ "notniva;", 0x0220C },
	{ "notnivb;", 0x022FE },
	{ "notnivc;", 0x022FD },
	{ "NotPrecedes;", 0x02280 },
	{ "NotPrecedesSlantEqual;", 0x022E0 },
	{ "NotReverseElement;", 0x0220C },
	{ "NotRightTriangle;", 0x022EB },
	{ "NotRightTriangleEqual;", 0x022ED },
	{ "NotSquareSubsetEqual;", 0x022E2 },
	{ "NotSquareSupersetEqual;", 0x022E3 },
	{ "NotSubsetEqual;", 0x02288 },
	{ "NotSucceeds;", 0x02281 },
	{ "NotSucceedsSlantEqual;", 0x022E1 },
	{ "NotSupersetEqual;", 0x02289 },
	{ "NotTilde;", 0x02241 },
	{ "NotTildeEqual;", 0x02244 },
	{ "NotTildeFullEqual;", 0x02247 },
	{ "NotTildeTilde;", 0x02249 },
	{ "NotVerticalBar;", 0x02224 },
	{ "npar;", 0x02226 },
	{ "nparallel;", 0x02226 },
	{ "npolint;", 0x02A14 },
	{ "npr;", 0x02280 },
	{ "nprcue;", 0x022E0 },
	{ "nprec;", 0x02280 },
	{ "nrarr;", 0x0219B },
	{ "nrArr;", 0x021CF },
	{ "nrightarrow;", 0x0219B },
	{ "nRightarrow;", 0x021CF },
	{ "nrtri;", 0x022EB },
	{ "nrtrie;", 0x022ED },
	{ "nsc;", 0x02281 },
	{ "nsccue;", 0x022E1 },
	{ "Nscr;", 0x1D4A9 },
	{ "nscr;", 0x1D4C3 },
	{ "nshortmid;", 0x02224 },
	{ "nshortparallel;", 0x02226 },
	{ "nsim;", 0x02241 },
	{ "nsime;", 0x02244 },
	{ "nsimeq;", 0x02244 },
	{ "nsmid;", 0x02224 },
	{ "nspar;", 0x02226 },
	{ "nsqsube;", 0x022E2 },
	{ "nsqsupe;", 0x022E3 },
	{ "nsub;", 0x02284 },
	{ "nsube;", 0x02288 },
	{ "nsubseteq;", 0x02288 },
	{ "nsucc;", 0x02281 },
	{ "nsup;", 0x02285 },
	{ "nsupe;", 0x02289 },
	{ "nsupseteq;", 0x02289 },
	{ "ntgl;", 0x02279 },
	{ "Ntilde;", 0x000D1 },
	{ "Ntilde", 0x000D1 },
	{ "ntilde;", 0x000F1 },
	{ "ntilde", 0x000F1 },
	{ "ntlg;", 0x02278 },
	{ "ntriangleleft;", 0x022EA },
	{ "ntrianglelefteq;", 0x022EC },
	{ "ntriangleright;", 0x022EB },
	{ "ntrianglerighteq;", 0x022ED },
	{ "Nu;", 0x0039D },
	{ "nu;", 0x003BD },
	{ "num;", 0x00023 },
	{ "numero;", 0x02116 },
	{ "numsp;", 0x02007 },
	{ "nvdash;", 0x022AC },
	{ "nvDash;", 0x022AD },
	{ "nVdash;", 0x022AE },
	{ "nVDash;", 0x022AF },
	{ "nvHarr;", 0x02904 },
	{ "nvinfin;", 0x029DE },
	{ "nvlArr;", 0x02902 },
	{ "nvrArr;", 0x02903 },
	{ "nwarhk;", 0x02923 },
	{ "nwarr;", 0x02196 },
	{ "nwArr;", 0x021D6 },
	{ "nwarrow;", 0x02196 },
	{ "nwnear;", 0x02927 },
	{ "Oacute;", 0x000D3 },
	{ "Oacute", 0x000D3 },
	{ "oacute;", 0x000F3 },
	{ "oacute", 0x000F3 },
	{ "oast;", 0x0229B },
	{ "ocir;", 0x0229A },
	{ "Ocirc;", 0x000D4 },
	{ "Ocirc", 0x000D4 },
	{ "ocirc;", 0x000F4 },
	{ "ocirc", 0x000F4 },
	{ "Ocy;", 0x0041E },
	{ "ocy;", 0x0043E },
	{ "odash;", 0x0229D },
	{ "Odblac;", 0x00150 },
	{ "odblac;", 0x00151 },
	{ "odiv;", 0x02A38 },
	{ "odot;", 0x02299 },
	{ "odsold;", 0x029BC },
	{ "OElig;", 0x00152 },
	{ "oelig;", 0x00153 },
	{ "ofcir;", 0x029BF },
	{ "Ofr;", 0x1D512 },
	{ "ofr;", 0x1D52C },
	{ "ogon;", 0x002DB },
	{ "Ograve;", 0x000D2 },
	{ "Ograve", 0x000D2 },
	{ "ograve;", 0x000F2 },
	{ "ograve", 0x000F2 },
	{ "ogt;", 0x029C1 },
	{ "ohbar;", 0x029B5 },
	{ "ohm;", 0x02126 },
	{ "oint;", 0x0222E },
	{ "olarr;", 0x021BA },
	{ "olcir;", 0x029BE },
	{ "olcross;", 0x029BB },
	{ "oline;", 0x0203E },
	{ "olt;", 0x029C0 },
	{ "Omacr;", 0x0014C },
	{ "omacr;", 0x0014D },
	{ "Omega;", 0x003A9 },
	{ "omega;", 0x003C9 },
	{ "Omicron;", 0x0039F },
	{ "omicron;", 0x003BF },
	{ "omid;", 0x029B6 },
	{ "ominus;", 0x02296 },
	{ "Oopf;", 0x1D546 },
	{ "oopf;", 0x1D560 },
	{ "opar;", 0x029B7 },
	{ "OpenCurlyDoubleQuote;", 0x0201C },
	{ "OpenCurlyQuote;", 0x02018 },
	{ "operp;", 0x029B9 },
	{ "oplus;", 0x02295 },
	{ "or;", 0x02228 },
	{ "Or;", 0x02A54 },
	{ "orarr;", 0x021BB },
	{ "ord;", 0x02A5D },
	{ "order;", 0x02134 },
	{ "orderof;", 0x02134 },
	{ "ordf;", 0x000AA },
	{ "ordf", 0x000AA },
	{ "ordm;", 0x000BA },
	{ "ordm", 0x000BA },
	{ "origof;", 0x022B6 },
	{ "oror;", 0x02A56 },
	{ "orslope;", 0x02A57 },
	{ "orv;", 0x02A5B },
	{ "oS;", 0x024C8 },
	{ "oscr;", 0x02134 },
	{ "Oscr;", 0x1D4AA },
	{ "Oslash;", 0x000D8 },
	{ "Oslash", 0x000D8 },
	{ "oslash;", 0x000F8 },
	{ "oslash", 0x000F8 },
	{ "osol;", 0x02298 },
	{ "Otilde;", 0x000D5 },
	{ "Otilde", 0x000D5 },
	{ "otilde;", 0x000F5 },
	{ "otilde", 0x000F5 },
	{ "otimes;", 0x02297 },
	{ "Otimes;", 0x02A37 },
	{ "otimesas;", 0x02A36 },
	{ "Ouml;", 0x000D6 },
	{ "Ouml", 0x000D6 },
	{ "ouml;", 0x000F6 },
	{ "ouml", 0x000F6 },
	{ "ovbar;", 0x0233D },
	{ "OverBar;", 0x000AF },
	{ "OverBrace;", 0x023DE },
	{ "OverBracket;", 0x023B4 },
	{ "OverParenthesis;", 0x023DC },
	{ "par;", 0x02225 },
	{ "para;", 0x000B6 },
	{ "para", 0x000B6 },
	{ "parallel;", 0x02225 },
	{ "parsim;", 0x02AF3 },
	{ "parsl;", 0x02AFD },
	{ "part;", 0x02202 },
	{ "PartialD;", 0x02202 },
	{ "Pcy;", 0x0041F },
	{ "pcy;", 0x0043F },
	{ "percnt;", 0x00025 },
	{ "period;", 0x0002E },
	{ "permil;", 0x02030 },
	{ "perp;", 0x022A5 },
	{ "pertenk;", 0x02031 },
	{ "Pfr;", 0x1D513 },
	{ "pfr;", 0x1D52D },
	{ "Phi;", 0x003A6 },
	{ "phi;", 0x003C6 },
	{ "phiv;", 0x003C6 },
	{ "phmmat;", 0x02133 },
	{ "phone;", 0x0260E },
	{ "Pi;", 0x003A0 },
	{ "pi;", 0x003C0 },
	{ "pitchfork;", 0x022D4 },
	{ "piv;", 0x003D6 },
	{ "planck;", 0x0210F },
	{ "planckh;", 0x0210E },
	{ "plankv;", 0x0210F },
	{ "plus;", 0x0002B },
	{ "plusacir;", 0x02A23 },
	{ "plusb;", 0x0229E },
	{ "pluscir;", 0x02A22 },
	{ "plusdo;", 0x02214 },
	{ "plusdu;", 0x02A25 },
	{ "pluse;", 0x02A72 },
	{ "PlusMinus;", 0x000B1 },
	{ "plusmn;", 0x000B1 },
	{ "plusmn", 0x000B1 },
	{ "plussim;", 0x02A26 },
	{ "plustwo;", 0x02A27 },
	{ "pm;", 0x000B1 },
	{ "Poincareplane;", 0x0210C },
	{ "pointint;", 0x02A15 },
	{ "Popf;", 0x02119 },
	{ "popf;", 0x1D561 },
	{ "pound;", 0x000A3 },
	{ "pound", 0x000A3 },
	{ "pr;", 0x0227A },
	{ "Pr;", 0x02ABB },
	{ "prap;", 0x02AB7 },
	{ "prcue;", 0x0227C },
	{ "pre;", 0x02AAF },
	{ "prE;", 0x02AB3 },
	{ "prec;", 0x0227A },
	{ "precapprox;", 0x02AB7 },
	{ "preccurlyeq;", 0x0227C },
	{ "Precedes;", 0x0227A },
	{ "PrecedesEqual;", 0x02AAF },
	{ "PrecedesSlantEqual;", 0x0227C },
	{ "PrecedesTilde;", 0x0227E },
	{ "preceq;", 0x02AAF },
	{ "precnapprox;", 0x02AB9 },
	{ "precneqq;", 0x02AB5 },
	{ "precnsim;", 0x022E8 },
	{ "precsim;", 0x0227E },
	{ "prime;", 0x02032 },
	{ "Prime;", 0x02033 },
	{ "primes;", 0x02119 },
	{ "prnap;", 0x02AB9 },
	{ "prnE;", 0x02AB5 },
	{ "prnsim;", 0x022E8 },
	{ "prod;", 0x0220F },
	{ "Product;", 0x0220F },
	{ "profalar;", 0x0232E },
	{ "profline;", 0x02312 },
	{ "profsurf;", 0x02313 },
	{ "prop;", 0x0221D },
	{ "Proportion;", 0x02237 },
	{ "Proportional;", 0x0221D },
	{ "propto;", 0x0221D },
	{ "prsim;", 0x0227E },
	{ "prurel;", 0x022B0 },
	{ "Pscr;", 0x1D4AB },
	{ "pscr;", 0x1D4C5 },
	{ "Psi;", 0x003A8 },
	{ "psi;", 0x003C8 },
	{ "puncsp;", 0x02008 },
	{ "Qfr;", 0x1D514 },
	{ "qfr;", 0x1D52E },
	{ "qint;", 0x02A0C },
	{ "Qopf;", 0x0211A },
	{ "qopf;", 0x1D562 },
	{ "qprime;", 0x02057 },
	{ "Qscr;", 0x1D4AC },
	{ "qscr;", 0x1D4C6 },
	{ "quaternions;", 0x0210D },
	{ "quatint;", 0x02A16 },
	{ "quest;", 0x0003F },
	{ "questeq;", 0x0225F },
	{ "quot;", 0x00022 },
	{ "quot", 0x00022 },
	{ "QUOT;", 0x00022 },
	{ "QUOT", 0x00022 },
	{ "rAarr;", 0x021DB },
	{ "race;", 0x029DA },
	{ "Racute;", 0x00154 },
	{ "racute;", 0x00155 },
	{ "radic;", 0x0221A },
	{ "raemptyv;", 0x029B3 },
	{ "rang;", 0x027E9 },
	{ "Rang;", 0x027EB },
	{ "rangd;", 0x02992 },
	{ "range;", 0x029A5 },
	{ "rangle;", 0x027E9 },
	{ "raquo;", 0x000BB },
	{ "raquo", 0x000BB },
	{ "rarr;", 0x02192 },
	{ "Rarr;", 0x021A0 },
	{ "rArr;", 0x021D2 },
	{ "rarrap;", 0x02975 },
	{ "rarrb;", 0x021E5 },
	{ "rarrbfs;", 0x02920 },
	{ "rarrc;", 0x02933 },
	{ "rarrfs;", 0x0291E },
	{ "rarrhk;", 0x021AA },
	{ "rarrlp;", 0x021AC },
	{ "rarrpl;", 0x02945 },
	{ "rarrsim;", 0x02974 },
	{ "rarrtl;", 0x021A3 },
	{ "Rarrtl;", 0x02916 },
	{ "rarrw;", 0x0219D },
	{ "ratail;", 0x0291A },
	{ "rAtail;", 0x0291C },
	{ "ratio;", 0x02236 },
	{ "rationals;", 0x0211A },
	{ "rbarr;", 0x0290D },
	{ "rBarr;", 0x0290F },
	{ "RBarr;", 0x02910 },
	{ "rbbrk;", 0x02773 },
	{ "rbrace;", 0x0007D },
	{ "rbrack;", 0x0005D },
	{ "rbrke;", 0x0298C },
	{ "rbrksld;", 0x0298E },
	{ "rbrkslu;", 0x02990 },
	{ "Rcaron;", 0x00158 },
	{ "rcaron;", 0x00159 },
	{ "Rcedil;", 0x00156 },
	{ "rcedil;", 0x00157 },
	{ "rceil;", 0x02309 },
	{ "rcub;", 0x0007D },
	{ "Rcy;", 0x00420 },
	{ "rcy;", 0x00440 },
	{ "rdca;", 0x02937 },
	{ "rdldhar;", 0x02969 },
	{ "rdquo;", 0x0201D },
	{ "rdquor;", 0x0201D },
	{ "rdsh;", 0x021B3 },
	{ "Re;", 0x0211C },
	{ "real;", 0x0211C },
	{ "realine;", 0x0211B },
	{ "realpart;", 0x0211C },
	{ "reals;", 0x0211D },
	{ "rect;", 0x025AD },
	{ "reg;", 0x000AE },
	{ "reg", 0x000AE },
	{ "REG;", 0x000AE },
	{ "REG", 0x000AE },
	{ "ReverseElement;", 0x0220B },
	{ "ReverseEquilibrium;", 0x021CB },
	{ "ReverseUpEquilibrium;", 0x0296F },
	{ "rfisht;", 0x0297D },
	{ "rfloor;", 0x0230B },
	{ "Rfr;", 0x0211C },
	{ "rfr;", 0x1D52F },
	{ "rHar;", 0x02964 },
	{ "rhard;", 0x021C1 },
	{ "rharu;", 0x021C0 },
	{ "rharul;", 0x0296C },
	{ "Rho;", 0x003A1 },
	{ "rho;", 0x003C1 },
	{ "rhov;", 0x003F1 },
	{ "RightAngleBracket;", 0x027E9 },
	{ "rightarrow;", 0x02192 },
	{ "RightArrow;", 0x02192 },
	{ "Rightarrow;", 0x021D2 },
	{ "RightArrowBar;", 0x021E5 },
	{ "RightArrowLeftArrow;", 0x021C4 },
	{ "rightarrowtail;", 0x021A3 },
	{ "RightCeiling;", 0x02309 },
	{ "RightDoubleBracket;", 0x027E7 },
	{ "RightDownTeeVector;", 0x0295D },
	{ "RightDownVector;", 0x021C2 },
	{ "RightDownVectorBar;", 0x02955 },
	{ "RightFloor;", 0x0230B },
	{ "rightharpoondown;", 0x021C1 },
	{ "rightharpoonup;", 0x021C0 },
	{ "rightleftarrows;", 0x021C4 },
	{ "rightleftharpoons;", 0x021CC },
	{ "rightrightarrows;", 0x021C9 },
	{ "rightsquigarrow;", 0x0219D },
	{ "RightTee;", 0x022A2 },
	{ "RightTeeArrow;", 0x021A6 },
	{ "RightTeeVector;", 0x0295B },
	{ "rightthreetimes;", 0x022CC },
	{ "RightTriangle;", 0x022B3 },
	{ "RightTriangleBar;", 0x029D0 },
	{ "RightTriangleEqual;", 0x022B5 },
	{ "RightUpDownVector;", 0x0294F },
	{ "RightUpTeeVector;", 0x0295C },
	{ "RightUpVector;", 0x021BE },
	{ "RightUpVectorBar;", 0x02954 },
	{ "RightVector;", 0x021C0 },
	{ "RightVectorBar;", 0x02953 },
	{ "ring;", 0x002DA },
	{ "risingdotseq;", 0x02253 },
	{ "rlarr;", 0x021C4 },
	{ "rlhar;", 0x021CC },
	{ "rlm;", 0x0200F },
	{ "rmoust;", 0x023B1 },
	{ "rmoustache;", 0x023B1 },
	{ "rnmid;", 0x02AEE },
	{ "roang;", 0x027ED },
	{ "roarr;", 0x021FE },
	{ "robrk;", 0x027E7 },
	{ "ropar;", 0x02986 },
	{ "Ropf;", 0x0211D },
	{ "ropf;", 0x1D563 },
	{ "roplus;", 0x02A2E },
	{ "rotimes;", 0x02A35 },
	{ "RoundImplies;", 0x02970 },
	{ "rpar;", 0x00029 },
	{ "rpargt;", 0x02994 },
	{ "rppolint;", 0x02A12 },
	{ "rrarr;", 0x021C9 },
	{ "Rrightarrow;", 0x021DB },
	{ "rsaquo;", 0x0203A },
	{ "Rscr;", 0x0211B },
	{ "rscr;", 0x1D4C7 },
	{ "rsh;", 0x021B1 },
	{ "Rsh;", 0x021B1 },
	{ "rsqb;", 0x0005D },
	{ "rsquo;", 0x02019 },
	{ "rsquor;", 0x02019 },
	{ "rthree;", 0x022CC },
	{ "rtimes;", 0x022CA },
	{ "rtri;", 0x025B9 },
	{ "rtrie;", 0x022B5 },
	{ "rtrif;", 0x025B8 },
	{ "rtriltri;", 0x029CE },
	{ "RuleDelayed;", 0x029F4 },
	{ "ruluhar;", 0x02968 },
	{ "rx;", 0x0211E },
	{ "Sacute;", 0x0015A },
	{ "sacute;", 0x0015B },
	{ "sbquo;", 0x0201A },
	{ "sc;", 0x0227B },
	{ "Sc;", 0x02ABC },
	{ "scap;", 0x02AB8 },
	{ "Scaron;", 0x00160 },
	{ "scaron;", 0x00161 },
	{ "sccue;", 0x0227D },
	{ "sce;", 0x02AB0 },
	{ "scE;", 0x02AB4 },
	{ "Scedil;", 0x0015E },
	{ "scedil;", 0x0015F },
	{ "Scirc;", 0x0015C },
	{ "scirc;", 0x0015D },
	{ "scnap;", 0x02ABA },
	{ "scnE;", 0x02AB6 },
	{ "scnsim;", 0x022E9 },
	{ "scpolint;", 0x02A13 },
	{ "scsim;", 0x0227F },
	{ "Scy;", 0x00421 },
	{ "scy;", 0x00441 },
	{ "sdot;", 0x022C5 },
	{ "sdotb;", 0x022A1 },
	{ "sdote;", 0x02A66 },
	{ "searhk;", 0x02925 },
	{ "searr;", 0x02198 },
	{ "seArr;", 0x021D8 },
	{ "searrow;", 0x02198 },
	{ "sect;", 0x000A7 },
	{ "sect", 0x000A7 },
	{ "semi;", 0x0003B },
	{ "seswar;", 0x02929 },
	{ "setminus;", 0x02216 },
	{ "setmn;", 0x02216 },
	{ "sext;", 0x02736 },
	{ "Sfr;", 0x1D516 },
	{ "sfr;", 0x1D530 },
	{ "sfrown;", 0x02322 },
	{ "sharp;", 0x0266F },
	{ "SHCHcy;", 0x00429 },
	{ "shchcy;", 0x00449 },
	{ "SHcy;", 0x00428 },
	{ "shcy;", 0x00448 },
	{ "ShortDownArrow;", 0x02193 },
	{ "ShortLeftArrow;", 0x02190 },
	{ "shortmid;", 0x02223 },
	{ "shortparallel;", 0x02225 },
	{ "ShortRightArrow;", 0x02192 },
	{ "ShortUpArrow;", 0x02191 },
	{ "shy;", 0x000AD },
	{ "shy", 0x000AD },
	{ "Sigma;", 0x003A3 },
	{ "sigma;", 0x003C3 },
	{ "sigmaf;", 0x003C2 },
	{ "sigmav;", 0x003C2 },
	{ "sim;", 0x0223C },
	{ "simdot;", 0x02A6A },
	{ "sime;", 0x02243 },
	{ "simeq;", 0x02243 },
	{ "simg;", 0x02A9E },
	{ "simgE;", 0x02AA0 },
	{ "siml;", 0x02A9D },
	{ "simlE;", 0x02A9F },
	{ "simne;", 0x02246 },
	{ "simplus;", 0x02A24 },
	{ "simrarr;", 0x02972 },
	{ "slarr;", 0x02190 },
	{ "SmallCircle;", 0x02218 },
	{ "smallsetminus;", 0x02216 },
	{ "smashp;", 0x02A33 },
	{ "smeparsl;", 0x029E4 },
	{ "smid;", 0x02223 },
	{ "smile;", 0x02323 },
	{ "smt;", 0x02AAA },
	{ "smte;", 0x02AAC },
	{ "SOFTcy;", 0x0042C },
	{ "softcy;", 0x0044C },
	{ "sol;", 0x0002F },
	{ "solb;", 0x029C4 },
	{ "solbar;", 0x0233F },
	{ "Sopf;", 0x1D54A },
	{ "sopf;", 0x1D564 },
	{ "spades;", 0x02660 },
	{ "spadesuit;", 0x02660 },
	{ "spar;", 0x02225 },
	{ "sqcap;", 0x02293 },
	{ "sqcup;", 0x02294 },
	{ "Sqrt;", 0x0221A },
	{ "sqsub;", 0x0228F },
	{ "sqsube;", 0x02291 },
	{ "sqsubset;", 0x0228F },
	{ "sqsubseteq;", 0x02291 },
	{ "sqsup;", 0x02290 },
	{ "sqsupe;", 0x02292 },
	{ "sqsupset;", 0x02290 },
	{ "sqsupseteq;", 0x02292 },
	{ "squ;", 0x025A1 },
	{ "square;", 0x025A1 },
	{ "Square;", 0x025A1 },
	{ "SquareIntersection;", 0x02293 },
	{ "SquareSubset;", 0x0228F },
	{ "SquareSubsetEqual;", 0x02291 },
	{ "SquareSuperset;", 0x02290 },
	{ "SquareSupersetEqual;", 0x02292 },
	{ "SquareUnion;", 0x02294 },
	{ "squarf;", 0x025AA },
	{ "squf;", 0x025AA },
	{ "srarr;", 0x02192 },
	{ "Sscr;", 0x1D4AE },
	{ "sscr;", 0x1D4C8 },
	{ "ssetmn;", 0x02216 },
	{ "ssmile;", 0x02323 },
	{ "sstarf;", 0x022C6 },
	{ "Star;", 0x022C6 },
	{ "star;", 0x02606 },
	{ "starf;", 0x02605 },
	{ "straightepsilon;", 0x003F5 },
	{ "straightphi;", 0x003D5 },
	{ "strns;", 0x000AF },
	{ "sub;", 0x02282 },
	{ "Sub;", 0x022D0 },
	{ "subdot;", 0x02ABD },
	{ "sube;", 0x02286 },
	{ "subE;", 0x02AC5 },
	{ "subedot;", 0x02AC3 },
	{ "submult;", 0x02AC1 },
	{ "subne;", 0x0228A },
	{ "subnE;", 0x02ACB },
	{ "subplus;", 0x02ABF },
	{ "subrarr;", 0x02979 },
	{ "subset;", 0x02282 },
	{ "Subset;", 0x022D0 },
	{ "subseteq;", 0x02286 },
	{ "subseteqq;", 0x02AC5 },
	{ "SubsetEqual;", 0x02286 },
	{ "subsetneq;", 0x0228A },
	{ "subsetneqq;", 0x02ACB },
	{ "subsim;", 0x02AC7 },
	{ "subsub;", 0x02AD5 },
	{ "subsup;", 0x02AD3 },
	{ "succ;", 0x0227B },
	{ "succapprox;", 0x02AB8 },
	{ "succcurlyeq;", 0x0227D },
	{ "Succeeds;", 0x0227B },
	{ "SucceedsEqual;", 0x02AB0 },
	{ "SucceedsSlantEqual;", 0x0227D },
	{ "SucceedsTilde;", 0x0227F },
	{ "succeq;", 0x02AB0 },
	{ "succnapprox;", 0x02ABA },
	{ "succneqq;", 0x02AB6 },
	{ "succnsim;", 0x022E9 },
	{ "succsim;", 0x0227F },
	{ "SuchThat;", 0x0220B },
	{ "sum;", 0x02211 },
	{ "Sum;", 0x02211 },
	{ "sung;", 0x0266A },
	{ "sup;", 0x02283 },
	{ "Sup;", 0x022D1 },
	{ "sup1;", 0x000B9 },
	{ "sup1", 0x000B9 },
	{ "sup2;", 0x000B2 },
	{ "sup2", 0x000B2 },
	{ "sup3;", 0x000B3 },
	{ "sup3", 0x000B3 },
	{ "supdot;", 0x02ABE },
	{ "supdsub;", 0x02AD8 },
	{ "supe;", 0x02287 },
	{ "supE;", 0x02AC6 },
	{ "supedot;", 0x02AC4 },
	{ "Superset;", 0x02283 },
	{ "SupersetEqual;", 0x02287 },
	{ "suphsub;", 0x02AD7 },
	{ "suplarr;", 0x0297B },
	{ "supmult;", 0x02AC2 },
	{ "supne;", 0x0228B },
	{ "supnE;", 0x02ACC },
	{ "supplus;", 0x02AC0 },
	{ "supset;", 0x02283 },
	{ "Supset;", 0x022D1 },
	{ "supseteq;", 0x02287 },
	{ "supseteqq;", 0x02AC6 },
	{ "supsetneq;", 0x0228B },
	{ "supsetneqq;", 0x02ACC },
	{ "supsim;", 0x02AC8 },
	{ "supsub;", 0x02AD4 },
	{ "supsup;", 0x02AD6 },
	{ "swarhk;", 0x02926 },
	{ "swarr;", 0x02199 },
	{ "swArr;", 0x021D9 },
	{ "swarrow;", 0x02199 },
	{ "swnwar;", 0x0292A },
	{ "szlig;", 0x000DF },
	{ "szlig", 0x000DF },
	{ "Tab;", 0x00009 },
	{ "target;", 0x02316 },
	{ "Tau;", 0x003A4 },
	{ "tau;", 0x003C4 },
	{ "tbrk;", 0x023B4 },
	{ "Tcaron;", 0x00164 },
	{ "tcaron;", 0x00165 },
	{ "Tcedil;", 0x00162 },
	{ "tcedil;", 0x00163 },
	{ "Tcy;", 0x00422 },
	{ "tcy;", 0x00442 },
	{ "tdot;", 0x020DB },
	{ "telrec;", 0x02315 },
	{ "Tfr;", 0x1D517 },
	{ "tfr;", 0x1D531 },
	{ "there4;", 0x02234 },
	{ "therefore;", 0x02234 },
	{ "Therefore;", 0x02234 },
	{ "Theta;", 0x00398 },
	{ "theta;", 0x003B8 },
	{ "thetasym;", 0x003D1 },
	{ "thetav;", 0x003D1 },
	{ "thickapprox;", 0x02248 },
	{ "thicksim;", 0x0223C },
	{ "thinsp;", 0x02009 },
	{ "ThinSpace;", 0x02009 },
	{ "thkap;", 0x02248 },
	{ "thksim;", 0x0223C },
	{ "THORN;", 0x000DE },
	{ "THORN", 0x000DE },
	{ "thorn;", 0x000FE },
	{ "thorn", 0x000FE },
	{ "tilde;", 0x002DC },
	{ "Tilde;", 0x0223C },
	{ "TildeEqual;", 0x02243 },
	{ "TildeFullEqual;", 0x02245 },
	{ "TildeTilde;", 0x02248 },
	{ "times;", 0x000D7 },
	{ "times", 0x000D7 },
	{ "timesb;", 0x022A0 },
	{ "timesbar;", 0x02A31 },
	{ "timesd;", 0x02A30 },
	{ "tint;", 0x0222D },
	{ "toea;", 0x02928 },
	{ "top;", 0x022A4 },
	{ "topbot;", 0x02336 },
	{ "topcir;", 0x02AF1 },
	{ "Topf;", 0x1D54B },
	{ "topf;", 0x1D565 },
	{ "topfork;", 0x02ADA },
	{ "tosa;", 0x02929 },
	{ "tprime;", 0x02034 },
	{ "trade;", 0x02122 },
	{ "TRADE;", 0x02122 },
	{ "triangle;", 0x025B5 },
	{ "triangledown;", 0x025BF },
	{ "triangleleft;", 0x025C3 },
	{ "trianglelefteq;", 0x022B4 },
	{ "triangleq;", 0x0225C },
	{ "triangleright;", 0x025B9 },
	{ "trianglerighteq;", 0x022B5 },
	{ "tridot;", 0x025EC },
	{ "trie;", 0x0225C },
	{ "triminus;", 0x02A3A },
	{ "TripleDot;", 0x020DB },
	{ "triplus;", 0x02A39 },
	{ "trisb;", 0x029CD },
	{ "tritime;", 0x02A3B },
	{ "trpezium;", 0x023E2 },
	{ "Tscr;", 0x1D4AF },
	{ "tscr;", 0x1D4C9 },
	{ "TScy;", 0x00426 },
	{ "tscy;", 0x00446 },
	{ "TSHcy;", 0x0040B },
	{ "tshcy;", 0x0045B },
	{ "Tstrok;", 0x00166 },
	{ "tstrok;", 0x00167 },
	{ "twixt;", 0x0226C },
	{ "twoheadleftarrow;", 0x0219E },
	{ "twoheadrightarrow;", 0x021A0 },
	{ "Uacute;", 0x000DA },
	{ "Uacute", 0x000DA },
	{ "uacute;", 0x000FA },
	{ "uacute", 0x000FA },
	{ "uarr;", 0x02191 },
	{ "Uarr;", 0x0219F },
	{ "uArr;", 0x021D1 },
	{ "Uarrocir;", 0x02949 },
	{ "Ubrcy;", 0x0040E },
	{ "ubrcy;", 0x0045E },
	{ "Ubreve;", 0x0016C },
	{ "ubreve;", 0x0016D },
	{ "Ucirc;", 0x000DB },
	{ "Ucirc", 0x000DB },
	{ "ucirc;", 0x000FB },
	{ "ucirc", 0x000FB },
	{ "Ucy;", 0x00423 },
	{ "ucy;", 0x00443 },
	{ "udarr;", 0x021C5 },
	{ "Udblac;", 0x00170 },
	{ "udblac;", 0x00171 },
	{ "udhar;", 0x0296E },
	{ "ufisht;", 0x0297E },
	{ "Ufr;", 0x1D518 },
	{ "ufr;", 0x1D532 },
	{ "Ugrave;", 0x000D9 },
	{ "Ugrave", 0x000D9 },
	{ "ugrave;", 0x000F9 },
	{ "ugrave", 0x000F9 },
	{ "uHar;", 0x02963 },
	{ "uharl;", 0x021BF },
	{ "uharr;", 0x021BE },
	{ "uhblk;", 0x02580 },
	{ "ulcorn;", 0x0231C },
	{ "ulcorner;", 0x0231C },
	{ "ulcrop;", 0x0230F },
	{ "ultri;", 0x025F8 },
	{ "Umacr;", 0x0016A },
	{ "umacr;", 0x0016B },
	{ "uml;", 0x000A8 },
	{ "uml", 0x000A8 },
	{ "UnderBar;", 0x00332 },
	{ "UnderBrace;", 0x023DF },
	{ "UnderBracket;", 0x023B5 },
	{ "UnderParenthesis;", 0x023DD },
	{ "Union;", 0x022C3 },
	{ "UnionPlus;", 0x0228E },
	{ "Uogon;", 0x00172 },
	{ "uogon;", 0x00173 },
	{ "Uopf;", 0x1D54C },
	{ "uopf;", 0x1D566 },
	{ "uparrow;", 0x02191 },
	{ "UpArrow;", 0x02191 },
	{ "Uparrow;", 0x021D1 },
	{ "UpArrowBar;", 0x02912 },
	{ "UpArrowDownArrow;", 0x021C5 },
	{ "updownarrow;", 0x02195 },
	{ "UpDownArrow;", 0x02195 },
	{ "Updownarrow;", 0x021D5 },
	{ "UpEquilibrium;", 0x0296E },
	{ "upharpoonleft;", 0x021BF },
	{ "upharpoonright;", 0x021BE },
	{ "uplus;", 0x0228E },
	{ "UpperLeftArrow;", 0x02196 },
	{ "UpperRightArrow;", 0x02197 },
	{ "upsi;", 0x003C5 },
	{ "Upsi;", 0x003D2 },
	{ "upsih;", 0x003D2 },
	{ "Upsilon;", 0x003A5 },
	{ "upsilon;", 0x003C5 },
	{ "UpTee;", 0x022A5 },
	{ "UpTeeArrow;", 0x021A5 },
	{ "upuparrows;", 0x021C8 },
	{ "urcorn;", 0x0231D },
	{ "urcorner;", 0x0231D },
	{ "urcrop;", 0x0230E },
	{ "Uring;", 0x0016E },
	{ "uring;", 0x0016F },
	{ "urtri;", 0x025F9 },
	{ "Uscr;", 0x1D4B0 },
	{ "uscr;", 0x1D4CA },
	{ "utdot;", 0x022F0 },
	{ "Utilde;", 0x00168 },
	{ "utilde;", 0x00169 },
	{ "utri;", 0x025B5 },
	{ "utrif;", 0x025B4 },
	{ "uuarr;", 0x021C8 },
	{ "Uuml;", 0x000DC },
	{ "Uuml", 0x000DC },
	{ "uuml;", 0x000FC },
	{ "uuml", 0x000FC },
	{ "uwangle;", 0x029A7 },
	{ "vangrt;", 0x0299C },
	{ "varepsilon;", 0x003B5 },
	{ "varkappa;", 0x003F0 },
	{ "varnothing;", 0x02205 },
	{ "varphi;", 0x003C6 },
	{ "varpi;", 0x003D6 },
	{ "varpropto;", 0x0221D },
	{ "varr;", 0x02195 },
	{ "vArr;", 0x021D5 },
	{ "varrho;", 0x003F1 },
	{ "varsigma;", 0x003C2 },
	{ "vartheta;", 0x003D1 },
	{ "vartriangleleft;", 0x022B2 },
	{ "vartriangleright;", 0x022B3 },
	{ "vBar;", 0x02AE8 },
	{ "Vbar;", 0x02AEB },
	{ "vBarv;", 0x02AE9 },
	{ "Vcy;", 0x00412 },
	{ "vcy;", 0x00432 },
	{ "vdash;", 0x022A2 },
	{ "vDash;", 0x022A8 },
	{ "Vdash;", 0x022A9 },
	{ "VDash;", 0x022AB },
	{ "Vdashl;", 0x02AE6 },
	{ "vee;", 0x02228 },
	{ "Vee;", 0x022C1 },
	{ "veebar;", 0x022BB },
	{ "veeeq;", 0x0225A },
	{ "vellip;", 0x022EE },
	{ "verbar;", 0x0007C },
	{ "Verbar;", 0x02016 },
	{ "vert;", 0x0007C },
	{ "Vert;", 0x02016 },
	{ "VerticalBar;", 0x02223 },
	{ "VerticalLine;", 0x0007C },
	{ "VerticalSeparator;", 0x02758 },
	{ "VerticalTilde;", 0x02240 },
	{ "VeryThinSpace;", 0x0200A },
	{ "Vfr;", 0x1D519 },
	{ "vfr;", 0x1D533 },
	{ "vltri;", 0x022B2 },
	{ "Vopf;", 0x1D54D },
	{ "vopf;", 0x1D567 },
	{ "vprop;", 0x0221D },
	{ "vrtri;", 0x022B3 },
	{ "Vscr;", 0x1D4B1 },
	{ "vscr;", 0x1D4CB },
	{ "Vvdash;", 0x022AA },
	{ "vzigzag;", 0x0299A },
	{ "Wcirc;", 0x00174 },
	{ "wcirc;", 0x00175 },
	{ "wedbar;", 0x02A5F },
	{ "wedge;", 0x02227 },
	{ "Wedge;", 0x022C0 },
	{ "wedgeq;", 0x02259 },
	{ "weierp;", 0x02118 },
	{ "Wfr;", 0x1D51A },
	{ "wfr;", 0x1D534 },
	{ "Wopf;", 0x1D54E },
	{ "wopf;", 0x1D568 },
	{ "wp;", 0x02118 },
	{ "wr;", 0x02240 },
	{ "wreath;", 0x02240 },
	{ "Wscr;", 0x1D4B2 },
	{ "wscr;", 0x1D4CC },
	{ "xcap;", 0x022C2 },
	{ "xcirc;", 0x025EF },
	{ "xcup;", 0x022C3 },
	{ "xdtri;", 0x025BD },
	{ "Xfr;", 0x1D51B },
	{ "xfr;", 0x1D535 },
	{ "xharr;", 0x027F7 },
	{ "xhArr;", 0x027FA },
	{ "Xi;", 0x0039E },
	{ "xi;", 0x003BE },
	{ "xlarr;", 0x027F5 },
	{ "xlArr;", 0x027F8 },
	{ "xmap;", 0x027FC },
	{ "xnis;", 0x022FB },
	{ "xodot;", 0x02A00 },
	{ "Xopf;", 0x1D54F },
	{ "xopf;", 0x1D569 },
	{ "xoplus;", 0x02A01 },
	{ "xotime;", 0x02A02 },
	{ "xrarr;", 0x027F6 },
	{ "xrArr;", 0x027F9 },
	{ "Xscr;", 0x1D4B3 },
	{ "xscr;", 0x1D4CD },
	{ "xsqcup;", 0x02A06 },
	{ "xuplus;", 0x02A04 },
	{ "xutri;", 0x025B3 },
	{ "xvee;", 0x022C1 },
	{ "xwedge;", 0x022C0 },
	{ "Yacute;", 0x000DD },
	{ "Yacute", 0x000DD },
	{ "yacute;", 0x000FD },
	{ "yacute", 0x000FD },
	{ "YAcy;", 0x0042F },
	{ "yacy;", 0x0044F },
	{ "Ycirc;", 0x00176 },
	{ "ycirc;", 0x00177 },
	{ "Ycy;", 0x0042B },
	{ "ycy;", 0x0044B },
	{ "yen;", 0x000A5 },
	{ "yen", 0x000A5 },
	{ "Yfr;", 0x1D51C },
	{ "yfr;", 0x1D536 },
	{ "YIcy;", 0x00407 },
	{ "yicy;", 0x00457 },
	{ "Yopf;", 0x1D550 },
	{ "yopf;", 0x1D56A },
	{ "Yscr;", 0x1D4B4 },
	{ "yscr;", 0x1D4CE },
	{ "YUcy;", 0x0042E },
	{ "yucy;", 0x0044E },
	{ "yuml;", 0x000FF },
	{ "yuml", 0x000FF },
	{ "Yuml;", 0x00178 },
	{ "Zacute;", 0x00179 },
	{ "zacute;", 0x0017A },
	{ "Zcaron;", 0x0017D },
	{ "zcaron;", 0x0017E },
	{ "Zcy;", 0x00417 },
	{ "zcy;", 0x00437 },
	{ "Zdot;", 0x0017B },
	{ "zdot;", 0x0017C },
	{ "zeetrf;", 0x02128 },
	{ "ZeroWidthSpace;", 0x0200B },
	{ "Zeta;", 0x00396 },
	{ "zeta;", 0x003B6 },
	{ "Zfr;", 0x02128 },
	{ "zfr;", 0x1D537 },
	{ "ZHcy;", 0x00416 },
	{ "zhcy;", 0x00436 },
	{ "zigrarr;", 0x021DD },
	{ "Zopf;", 0x02124 },
	{ "zopf;", 0x1D56B },
	{ "Zscr;", 0x1D4B5 },
	{ "zscr;", 0x1D4CF },
	{ "zwj;", 0x0200D },
	{ "zwnj;", 0x0200C },
};

static hubbub_dict *dict;

/**
 * Create the entities dictionary
 *
 * \param alloc  Memory (de)allocation function
 * \param pw     Pointer to client-specific private data (may be NULL)
 * \return HUBBUB_OK on success, appropriate error otherwise
 */
hubbub_error hubbub_entities_create(hubbub_allocator_fn alloc, void *pw)
{
	hubbub_error error;
	size_t i;

	if (alloc == NULL)
		return HUBBUB_BADPARM;

	error = hubbub_dict_create(alloc, pw, &dict);
	if (error != HUBBUB_OK)
		return error;

	for (i = 0; i < sizeof(entities) / sizeof(entities[0]); i++) {
		error = hubbub_dict_insert(dict, entities[i].name,
				&entities[i]);
		if (error != HUBBUB_OK) {
			hubbub_dict_destroy(dict);
			return error;
		}
	}

	return HUBBUB_OK;
}

/**
 * Destroy the entities dictionary
 *
 * \param alloc  Memory (de)allocation function
 * \param pw     Pointer to client-specific private data (may be NULL)
 */
void hubbub_entities_destroy(hubbub_allocator_fn alloc, void *pw)
{
	UNUSED(alloc);
	UNUSED(pw);

	hubbub_dict_destroy(dict);
}

/**
 * Step-wise search for an entity in the dictionary
 *
 * \param c        Character to look for
 * \param result   Pointer to location for result
 * \param context  Pointer to location for search context
 * \return HUBBUB_OK if key found,
 *         HUBBUB_NEEDDATA if more steps are required
 *         HUBBUB_INVALID if nothing matches
 *
 * The value pointed to by ::context should be NULL for the first call.
 * Thereafter, pass in the same value as returned by the previous call.
 * The context is opaque to the caller and should not be inspected.
 *
 * The location pointed to by ::result will be set to U+FFFD unless a match
 * is found.
 */
hubbub_error hubbub_entities_search_step(uint8_t c, uint32_t *result,
		void **context)
{
	const hubbub_entity *e;
	hubbub_error error;

	if (result == NULL || context == NULL)
		return HUBBUB_BADPARM;

	error = hubbub_dict_search_step(dict, c,
			(const void **) (const void *) &e,
			context);
	if (error != HUBBUB_OK) {
		*result = 0xFFFD;
		return error;
	}

	*result = e->ucs4;

	return HUBBUB_OK;
}
