///////
   //    HtmlStatement.h
   //    HtmlStatement Class declaration
   //
   //    Class for HtmlStatement storage
   //
   //    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 1995-2000 The ht://Dig Group <www.htdig.org>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmlStatement.h,v 1.6 2002/02/18 10:44:59 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifndef _HTMLSTATEMENT_H
#define _HTMLSTATEMENT_H

#include <Object.h>
#include <htString.h>


class HtmlStatement : public Object
{

   // Write the object to the output
   friend ostream& operator<<(ostream&, const HtmlStatement& );
   
   public:
   
      // Construction / Destruction
      HtmlStatement();
      virtual ~HtmlStatement();

///////
   //    Public Interface
///////

      inline void Reset();

      void SetIDUrl        (unsigned int id) { IDUrl = id; }
      void SetTagPosition  (unsigned int tp) { TagPosition = tp; }
      void SetTag          (const String &t) { Tag = t; }
      void SetStatement    (const String &s) { Statement = s; }

      unsigned int GetIDUrl() const          { return IDUrl; }
      unsigned int GetTagPosition() const    { return TagPosition; }
      const String &GetTag() const           { return Tag; }
      const String &GetStatement() const     { return Statement; }

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}

///////
   //    Protected attributes
///////

   protected:

      unsigned int   IDUrl;
      unsigned int   TagPosition;
      String         Tag;
      String         Statement;
      
///////
   //    Static attributes
///////

      static int debug;    // Run-time debugging level

};

#endif
