// mlcd.h

/* Copyright (C) 2000-2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

/* Original author: David Paschal */

#ifndef MLCD_H
#define MLCD_H

#define MLCD_SOCKET_PREFIX "/dev/ptal-mlcd/"

/* Status codes. */
enum {
	MLCD_STATUS_SUCCESSFUL=0,
	MLCD_STATUS_CHAN_CLOSING,
	MLCD_STATUS_CHAN_CLOSE_HAD_NO_EFFECT,
	MLCD_STATUS_SERVICE_LOOKUP_FAILED,
	MLCD_STATUS_LOOKUP_NOT_SUPPORTED,
	MLCD_STATUS_SOCKET_TABLE_FULL,
	MLCD_STATUS_CONNECTION_REFUSED,
	MLCD_STATUS_INSUFFICIENT_RESOURCES,
	MLCD_STATUS_UNKNOWN_ERROR,
	MLCD_STATUS_UNSUPPORTED_SOCKET,
	MLCD_STATUS_CLOSED_BY_PERIPHERAL,
	MLCD_STATUS_PERIPHERAL_ERROR,
	MLCD_STATUS_TOO_MANY_SESSIONS,
	MLCD_STATUS_FAILED_TO_ACTIVATE,
	MLCD_STATUS_NO_DEVICE_ID_STRING,
	MLCD_STATUS_CONSOLE_DEACTIVATE,
	MLCD_STATUS_READ_ERROR,
	MLCD_STATUS_WRITE_ERROR,
	MLCD_STATUS_NO_CONSOLE
};

enum {
	MLCD_CMD_GET_STATUS=0,
	MLCD_CMD_GET_DEVICE_ID,
	MLCD_CMD_LOOKUP,
	MLCD_CMD_REVERSE_LOOKUP,
	MLCD_CMD_OPEN
};

#define MLCD_MAX_DEVICE_ID_LEN 1024
#define MLCD_MAX_SERVICE_NAME_LEN 40
#define MLCD_SERVICE_NAME_PML "HP-MESSAGE"
#define MLCD_SERVICE_NAME_PRINT "PRINT"
#define MLCD_SERVICE_NAME_SCAN "HP-SCAN"

struct MlcdCmdRequest {
	int command;
};
struct MlcdCmdReply {
	int status;
};

struct MlcdCmdGetStatus {
	int command;
};
struct MlcdCmdGetStatusReply {
	int status;
	int exState;
	/* TODO: Return other info, such as a revision string? */
};

struct MlcdCmdGetDeviceID {
	int command;
};
struct MlcdCmdGetDeviceIDReply {
	int status;
	char deviceID[MLCD_MAX_DEVICE_ID_LEN+1];
};

struct MlcdCmdLookup {
	int command;
	char serviceName[MLCD_MAX_SERVICE_NAME_LEN+1];
};
struct MlcdCmdLookupReply {
	int status;
	int socketID;
};

struct MlcdCmdReverseLookup {
	int command;
	int socketID;
};
struct MlcdCmdReverseLookupReply {
	int status;
	char serviceName[MLCD_MAX_SERVICE_NAME_LEN+1];
};

struct MlcdCmdOpen {
	int command;
	int socketID;
	int maxForwardDatalen;
	int maxReverseDatalen;
	/* int mode; // stream or datagram. */
};
struct MlcdCmdOpenReply {
	int status;
	int maxForwardDatalen;
	int maxReverseDatalen;
};

union MlcdCmdUnion {
	struct MlcdCmdRequest request;
	struct MlcdCmdReply reply;
	struct MlcdCmdGetStatus getStatus;
	struct MlcdCmdGetStatusReply getStatusReply;
	struct MlcdCmdGetDeviceID getDeviceID;
	struct MlcdCmdGetDeviceIDReply getDeviceIDReply;
	struct MlcdCmdLookup lookup;
	struct MlcdCmdLookupReply lookupReply;
	struct MlcdCmdReverseLookup reverseLookup;
	struct MlcdCmdReverseLookupReply reverseLookupReply;
	struct MlcdCmdOpen open;
	struct MlcdCmdOpenReply openReply;
};

#endif
