/* ptal-pml -- PTAL command-line PML client */

/* Copyright (C) 2000-2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

/* Original author: David Paschal */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ptal.h"


/* TODO: Finish implementing CMD_GETNEXT and CMD_TRAP. */
#define CMD_NONE	0
#define CMD_DEV		1
#define CMD_GET		2
/* #define CMD_GETNEXT	3 */
#define CMD_SET_OID	4
#define CMD_SET_TYPE	5
#define CMD_SET_VALUE	6
/* #define CMD_TRAP	7 */

int strLooksLike(char *argv,char *str) {
	return strstr(str,argv)==str;
}

char *printType(int type) {
	switch (type) {
	   case PTAL_PML_TYPE_ENUMERATION:
		return "enumeration";
	   case PTAL_PML_TYPE_SIGNED_INTEGER:
		return "integer";
	   case PTAL_PML_TYPE_STRING:
		return "string";
	   case PTAL_PML_TYPE_BINARY:
		return "binary";
	   case PTAL_PML_TYPE_NULL_VALUE:
		return "null";
	   case PTAL_PML_TYPE_COLLECTION:
		return "collection";
	   default:
		return "?";
	}
}

int printObject(ptalPmlObject_t obj,int status) {
	int type,symbolSet,i,len,ivalue;
	char oid[PTAL_PML_MAX_OID_LEN];
	char svalue[PTAL_PML_MAX_VALUE_LEN+1];

	if (ptalPmlGetID(obj,oid,PTAL_PML_MAX_OID_LEN)==PTAL_ERROR) {

		return PTAL_ERROR;
	}
	for (i=0;oid[i];i++) {
		printf("%s%d",i?".":"",oid[i]);
	}
	printf("  ");

	if (status==PTAL_ERROR) {
		printf("failed (status=0x%2.2X)!\n",ptalPmlGetStatus(obj));

	} else if (ptalPmlGetIntegerValue(obj,&type,&ivalue)!=PTAL_ERROR) {
		printf("%s  %d (0x%8.8X)\n",
			printType(type),ivalue,ivalue);

	} else if (type==PTAL_PML_TYPE_STRING) {
		len=ptalPmlGetStringValue(obj,&symbolSet,svalue,
			PTAL_PML_MAX_VALUE_LEN);
		printf("%s(symbolSet=0x%4.4X,len=%d)  \"%s\"\n",
			printType(type),symbolSet,len,svalue);

	} else {
		len=ptalPmlGetValue(obj,&type,svalue,PTAL_PML_MAX_VALUE_LEN);
		if (type==PTAL_PML_TYPE_BINARY) {
			printf("%s(len=%d) ",printType(type),len);
		} else {
			printf("%s(type=0x%2.2X,len=%d) ",
				printType(type),type,len);
		}
		for (i=0;i<len;i++) {
			printf(" %2.2X",(unsigned char)svalue[i]);
		}
		printf("\n");
	}

	return PTAL_OK;
}

int main(int argc,char **argv) {
	int cmd=CMD_DEV,type=-1,r;
#ifdef CMD_TRAP
	int trapRequested=0
#endif
	ptalDevice_t dev=0;
	ptalPmlObject_t obj=0,next;

	if (ptalInit()==PTAL_ERROR) {
		PTAL_LOG_ERROR("ptal-pml: ptalInit() failed!\n");
		return 2;
	}

	while (42) {
		argc--; argv++; if (argc<=0) break;

		if (cmd==CMD_DEV) {
			if (!(dev=ptalDeviceOpen(*argv))) {
				PTAL_LOG_ERROR("ptal-pml: "
					"invalid device \"%s\"!\n",*argv);
				return 3;
			}
			if (ptalPmlOpen(dev)==PTAL_ERROR) {
				PTAL_LOG_ERROR("ptal-pml: error opening PML "
					"for device \"%s\"!\n",*argv);
				return 4;
			}
			cmd=CMD_NONE;

		} else if (cmd==CMD_SET_TYPE) {
			if (strLooksLike(*argv,"enumeration")) {
				type=PTAL_PML_TYPE_ENUMERATION;

			} else if (strLooksLike(*argv,"integer")) {
				type=PTAL_PML_TYPE_SIGNED_INTEGER;

			} else if (strLooksLike(*argv,"string")) {
				type=PTAL_PML_TYPE_STRING;

			} else if (strLooksLike(*argv,"binary")) {
				type=PTAL_PML_TYPE_BINARY;

			} else if (strLooksLike(*argv,"null")) {
				type=PTAL_PML_TYPE_NULL_VALUE;

			} else if (strLooksLike(*argv,"collection")) {
				type=PTAL_PML_TYPE_COLLECTION;

			} else {
				goto syntaxError;
			}
			cmd=CMD_SET_VALUE;

		} else if (cmd==CMD_SET_VALUE) {
			if (ptalPmlTypeIsInteger(type)) {
				ptalPmlSetIntegerValue(obj,type,
					strtol(*argv,0,0));

			} else if (type==PTAL_PML_TYPE_STRING) {
				ptalPmlSetStringValue(obj,0,*argv,
					strlen(*argv));

			} else {
				goto syntaxError;
			}

			r=ptalPmlRequestSet(obj);
			/* ptalPmlRequestGet(obj); */
			printObject(obj,r);

			cmd=CMD_SET_OID;

		} else if (!strcmp(*argv,"dev")) {
			cmd=CMD_DEV;

		} else if (!strcmp(*argv,"get")) {
			cmd=CMD_GET;

#ifdef CMD_GETNEXT
		} else if (!strcmp(*argv,"getnext")) {
			cmd=CMD_GETNEXT;
#endif

		} else if (!strcmp(*argv,"set")) {
			cmd=CMD_SET_OID;

#ifdef CMD_TRAP
		} else if (!strcmp(*argv,"trap")) {
			cmd=CMD_TRAP;
#endif

		} else {
			if (cmd==CMD_NONE) {
				goto syntaxError;
			}

			if (!(obj=ptalPmlAllocate(dev))) {
				PTAL_LOG_ERROR("ptal-pml: error allocating "
					"PML object for \"%s\"!\n",*argv);
				return 5;
			}
			if (ptalPmlSetAsciiID(obj,*argv)==PTAL_ERROR) {
				PTAL_LOG_ERROR("ptal-pml: error parsing PML "
					"object ID \"%s\"!\n",*argv);
				goto syntaxError;
			}

#ifdef CMD_GETNEXT
			if (cmd==CMD_GETNEXT) {
				next=obj;
				goto doGet;
			}
#endif
			if (cmd==CMD_GET) {
				next=0;
#ifdef CMD_GETNEXT
doGet:
#endif
				printObject(obj,ptalPmlRequestGet(obj,next));

#ifdef CMD_TRAP
			} else if (cmd==CMD_TRAP) {
				trapRequested=1;
				if (ptalPmlRequestSetTrap(obj,1)==PTAL_ERROR) {

				}
#endif

			} else if (cmd==CMD_SET_OID) {
				cmd=CMD_SET_TYPE;
			}
		}
	}

	if (cmd==CMD_DEV || cmd==CMD_SET_TYPE || cmd==CMD_SET_VALUE) {
syntaxError:
		PTAL_LOG_ERROR(
			"Syntax: ptal-pml <dev> [<cmd> [<cmd>]...]\n"
			"Where <cmd> is one of:\n"
				"\tdev <dev>\n"
				"\tget [<oid>]...\n"
				/* "\tgetnext [<oid>]...\n" */ /* CMD_GETNEXT */
				"\tset [<oid> <type> <value>]...\n"
				/* "\ttrap [<oid>]...\n" */ /* CMD_TRAP */
				/* TODO: list? */
			"<oid> is a dotted-decimal PML object ID "
			    "(for example, \"1.1.3.2\")\n"
			"<type> is one of:\n"
				"\tinteger\n"
				"\tstring\n"
			);
		return 1;
	}

#ifdef CMD_TRAP
	if (trapRequested) {



	}
#endif

	return 0;
}
