#ifndef __HRN_TEXTURE_CACHE_H__
#define __HRN_TEXTURE_CACHE_H__

#include <glib-object.h>
#include <bickley/bkl-item.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_TEXTURE_CACHE                                          \
   (hrn_texture_cache_get_type())
#define HRN_TEXTURE_CACHE(obj)                                          \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_TEXTURE_CACHE,                 \
                                HrnTextureCache))
#define HRN_TEXTURE_CACHE_CLASS(klass)                                  \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_TEXTURE_CACHE,                    \
                             HrnTextureCacheClass))
#define IS_HRN_TEXTURE_CACHE(obj)                                       \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_TEXTURE_CACHE))
#define IS_HRN_TEXTURE_CACHE_CLASS(klass)                               \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_TEXTURE_CACHE))
#define HRN_TEXTURE_CACHE_GET_CLASS(obj)                                \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_TEXTURE_CACHE,                  \
                               HrnTextureCacheClass))

typedef struct _HrnTextureCachePrivate HrnTextureCachePrivate;
typedef struct _HrnTextureCache      HrnTextureCache;
typedef struct _HrnTextureCacheClass HrnTextureCacheClass;

struct _HrnTextureCache
{
    GObject parent;

    HrnTextureCachePrivate *priv;
};

struct _HrnTextureCacheClass
{
    GObjectClass parent_class;
};

GType hrn_texture_cache_get_type (void) G_GNUC_CONST;
HrnTextureCache *hrn_texture_cache_get_default (void);
ClutterActor *hrn_texture_cache_get_texture (HrnTextureCache *cache,
                                             const char      *uri);
ClutterActor *hrn_texture_cache_get_default_texture (HrnTextureCache *cache,
                                                     BklItemType      type);

G_END_DECLS

#endif /* __HRN_TEXTURE_CACHE_H__ */
