/* $Id: board_init.cc 683 2005-06-16 15:22:57Z holger $
 *
 * HoiChess/board_init.cc
 *
 * Copyright (C) 2004, 2005 Holger Ruckdeschel <holger@hoicher.de>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

#include "common.h"
#include "board.h"
#include "util.h"


Hashkey Board::hashkeys[2][6][64];
Hashkey Board::hash_side;
Hashkey Board::hash_ep[64];
Hashkey Board::hash_wk;
Hashkey Board::hash_wq;
Hashkey Board::hash_bk;
Hashkey Board::hash_bq;

/* To share an opening book between different architectures
 * (which are likely to have different rand() implementations),
 * we need some static random numbers for use as hash keys. */
const Hashkey hashkey_table[] = {
	0xac5372998e7fa920ULL,
	0x8b9287c4f3be1092ULL,
	0x8014fbf5e78fe2b3ULL,
	0xfa00a57c1c8aa786ULL,
	0x2ec1e9271c282cf5ULL,
	0xd0a5c7546ea8bdcULL,
	0x5462e59e577c3634ULL,
	0x12954a162eb91797ULL,
	0xd479ab5d8e694519ULL,
	0xadc24340b231f6e2ULL,
	0x953eaeda3647dbcULL,
	0xd7c3408ed070eddfULL,
	0x9b8a6322dc2b47c3ULL,
	0xd0faf849bbaf3ed7ULL,
	0xe4b3b3d0db51a818ULL,
	0x2929215c946aa57bULL,
	0xe689ed10cf0a3682ULL,
	0xc0266e6d28141f95ULL,
	0x6a9d9698f2e1e3a5ULL,
	0x156293e0e6cfa24bULL,
	0xe88d11dfe0762192ULL,
	0x46ddcd630e88d4a1ULL,
	0x692affd61496e17aULL,
	0x4880cb52b4de0cd4ULL,
	0x7b501aa47553f74eULL,
	0x44f0dc817329bdb9ULL,
	0x789eb9a76a04ac28ULL,
	0xb66d6eaad1873443ULL,
	0x4ff15e00d076527aULL,
	0x40eca4bd9f5476abULL,
	0xdbe1157b7243817eULL,
	0xa424656aa44ff5f4ULL,
	0xf5ab0087f3e0d020ULL,
	0xa6ea55f0b818e805ULL,
	0x7757f048b0dde69fULL,
	0xe54c56a0c373c950ULL,
	0x51e6dd7a2bf4d640ULL,
	0x676e30d7dc599a2ULL,
	0x3ff443601c101e1cULL,
	0x2fee07585e805df2ULL,
	0x71ffed2c655f55d4ULL,
	0xb4587bcc3515768ULL,
	0x9627841b7983d776ULL,
	0x7dac7bb5879a4953ULL,
	0x9da7e26a91519edeULL,
	0x9b8bea01d11f6188ULL,
	0x6ecfd4e75e39d4a8ULL,
	0xb7403b2f32e1a32cULL,
	0x237077c3afc87cbcULL,
	0x46662d01d11bffa9ULL,
	0x3940fa7c7c607dc0ULL,
	0x2cda89b83a2b12d6ULL,
	0xf5ec34ebdb8fb2d9ULL,
	0xa78c48a4bc354e99ULL,
	0x8fc7ba0b3bae7103ULL,
	0xf04f9f4eba78adedULL,
	0xa67856c082f7a10fULL,
	0x71b30fb68d4b40c6ULL,
	0xebda4f499a6d81b1ULL,
	0x6ec85b0295f417fcULL,
	0x7d5aad9c012bb65eULL,
	0x546f62fcd1cd878cULL,
	0x78f1ed06a6211484ULL,
	0xb9aa20022f23a096ULL,
	0x904600857b312733ULL,
	0x54be945cbb9948f2ULL,
	0x382e4fd7cd98fe9cULL,
	0x2b76d9ebdd96afb1ULL,
	0x6c20755ea5762b87ULL,
	0x8d4e08e5a29284e7ULL,
	0xd1fc8727e81b1bf1ULL,
	0xf3b73ea4238dfe6aULL,
	0xe1766208e21d609aULL,
	0xa73a10e4d18cabedULL,
	0x276ab3784ffcaeb4ULL,
	0xdde2ac3f5efaba83ULL,
	0x15b7cc684e390f57ULL,
	0xa12031d1aaaefd1eULL,
	0x23b9a267790b86f2ULL,
	0x518404a0f1a37b0aULL,
	0xf7a8d936733e791ULL,
	0x6e64a5587965373ULL,
	0x377322483db142f1ULL,
	0xc1773cfdd040fe59ULL,
	0xafc8768c0922cc86ULL,
	0xcf0a22358da7adb0ULL,
	0xc0dad99e4579bd83ULL,
	0x64574f8bf13a4869ULL,
	0x9c7d25fc5c850002ULL,
	0x2237d12ab2aec1faULL,
	0x80245d918e361e76ULL,
	0x8a4ba3afd343df65ULL,
	0xf3318982d45f5e30ULL,
	0x14d2bc98598ec56fULL,
	0x67d1385c9458fc6bULL,
	0x1efde9ef5061cff5ULL,
	0x5a7fdebbc82c5bf6ULL,
	0xf33860cbfbd1651fULL,
	0x82c1f18828cdc96cULL,
	0xed309940526f7b03ULL,
	0xf6af35974429d13eULL,
	0x9c4ea24dc2dbaebaULL,
	0xcbf656810b7ce5d5ULL,
	0x6cbb77cacf3c87b0ULL,
	0xce402b39b8d0a2d9ULL,
	0xdc60d993aa019d2aULL,
	0xed074c495fdb83eULL,
	0x1bee7560b4e0f620ULL,
	0xd749bb5053d2a8f4ULL,
	0x1a8f5d3d14c0b173ULL,
	0xca58481cf84c1714ULL,
	0x8dc5c5498189f293ULL,
	0xc60575763e94e795ULL,
	0xc71898b84b4cf409ULL,
	0x84ea3ce6ff5d145fULL,
	0x89c009ff5aa0fcfaULL,
	0xa78213689da359b5ULL,
	0xf2546df550101db8ULL,
	0xe374b642c8780521ULL,
	0x8d1591597f9441c5ULL,
	0xb4ab5568b9a7c5c0ULL,
	0xcc5e6ab793c413eeULL,
	0xd7aba1d174f85de9ULL,
	0xc49323a91f5167bcULL,
	0xe6ea45b184b8e834ULL,
	0xcd7988f6fde8a037ULL,
	0xb694a954c9c0aa23ULL,
	0x1c4a0e3097294621ULL,
	0x4d390d2752044d1bULL,
	0xb553e53b17f539edULL,
	0x9f025cf6a7cc4e78ULL,
	0x50b48ab5c2d2df18ULL,
	0xc62e3dd8e1dc9dacULL,
	0x2f5d9e66b46b113cULL,
	0xdc87db0eeb7b38eaULL,
	0x777a8fefc19c99edULL,
	0x5349d507847cc330ULL,
	0x5a5174c6f67a52faULL,
	0x56f5181e718f7e8cULL,
	0x7cc3c1e98a04df76ULL,
	0xce561b50fc20c342ULL,
	0x558b5af060363aa8ULL,
	0x5f8fae3fa1aa8fddULL,
	0xbc443e60955ca5dcULL,
	0x462f8bb6bf8c6040ULL,
	0x9f968a4920fe1f7fULL,
	0x4e174f12f0bd0c07ULL,
	0x44b134bdc8d40aa5ULL,
	0xdff2c70c7fdb7a90ULL,
	0x51593b600334649dULL,
	0x42586047653e96c0ULL,
	0x8f39d2b91ea503b2ULL,
	0x4b4755a6d95bb573ULL,
	0xbb156584e55f592eULL,
	0x37e4ae4b627c239bULL,
	0x6895b7bdcf5e58f9ULL,
	0x60bdf1ddc0890c09ULL,
	0x638aa6907b9d46bULL,
	0x194e07cab079d67fULL,
	0x805fcf22353aa59bULL,
	0x6d20de966d6f2c51ULL,
	0x7041f49502ab2aa0ULL,
	0x8fea5a1d6a348286ULL,
	0xc56ae110d28ca6d7ULL,
	0x614b5a25c5fbd2d4ULL,
	0xfa7be347bee59b70ULL,
	0x6a1176d3254f89c4ULL,
	0x12508b7e7d8ac8e6ULL,
	0xd6f09ea3fe98c1efULL,
	0xdf679e6f7f691d95ULL,
	0xca4f526560531e9eULL,
	0xfc77cf81d4313f65ULL,
	0x58ee36071cfbd2cdULL,
	0x70d845734d41cbb2ULL,
	0x2ce8c74d1be9edf4ULL,
	0x27e1deb972584f64ULL,
	0xc570744e53994474ULL,
	0x572e19946cf59c49ULL,
	0x47b9f852d4c355ddULL,
	0xb9c5edbde6176769ULL,
	0x7f28a822f0a6a08fULL,
	0x78dd86f04ca32625ULL,
	0xa910d0a06545aa06ULL,
	0x4a95cdc43a11f482ULL,
	0x69809de2707a9e15ULL,
	0xf41652fb4aba4120ULL,
	0x5c9b9cfdd670459dULL,
	0x8646a487380a3489ULL,
	0x18155e2a4377fb3dULL,
	0xa2a4b3233eff191aULL,
	0xc0447e16847589daULL,
	0x188d8cee0d7cc7a6ULL,
	0xfe192bf6dfb0bb1cULL,
	0x43b68f131dcbe766ULL,
	0x1a2d2c6ca017eb12ULL,
	0x69acb746fdcb01b4ULL,
	0xc4426a325ac99471ULL,
	0xfa5c3eacc862516aULL,
	0xe84906f63550ba7cULL,
	0x7cc0c6d909d26fecULL,
	0xdfeffbebba05a9cfULL,
	0xa10d2049c938c77bULL,
	0xe33a35b98ca36d81ULL,
	0xfe584a1ea656c141ULL,
	0xf1bbe2e08e390f2dULL,
	0x157d3f77c77faa5cULL,
	0xb78e46ebe2ee274ULL,
	0xf8d3cfbd1f68e506ULL,
	0x71201edc326d5d5bULL,
	0x6ee560b118473262ULL,
	0x579d848438e2ccfdULL,
	0xd75a0d640ff7a49cULL,
	0xdad0e72689756e75ULL,
	0xce85335de8c1fe07ULL,
	0x7508c8f73f72c32eULL,
	0xad5fd0defcf13fdaULL,
	0x35eebe90270c8547ULL,
	0x7f26dd0af55fe16fULL,
	0x65464e6ddbbb0fc2ULL,
	0x1a06f26eda5f8068ULL,
	0x24bb634a3034df62ULL,
	0x15e86c3b93eea116ULL,
	0x50360c40ab3ed857ULL,
	0xdaeeb8ce1a5f53dULL,
	0xfe00c9bfab0d9772ULL,
	0xbf6d05cca57a6977ULL,
	0xad1f7fd49f89492cULL,
	0xdd810eaff5550b41ULL,
	0x58f1865dc1fecaeULL,
	0xf02fbe30f9218527ULL,
	0xcee6b5a99d52cf56ULL,
	0xc238fb521926b09bULL,
	0xcf80be8634e03790ULL,
	0xe27027580c5b8b9dULL,
	0x714b23e0da4f9038ULL,
	0xa434d1dc1afcb047ULL,
	0x6df2c9e3d7e4170bULL,
	0x9feadea12e8820f4ULL,
	0xde8cd3f8a8c1550eULL,
	0xafc379aa6bada279ULL,
	0x37891e56f9e19baULL,
	0x704dce81e4ce8d5cULL,
	0xfc9e3a27ba433e2ULL,
	0xf54c8a1d22b3295bULL,
	0xdf4b813571d87c0dULL,
	0xb6bfe2be971c6939ULL,
	0x5cc5c839a9098b54ULL,
	0x183c32115359eca7ULL,
	0xcbbc2b6f7197152cULL,
	0x48a2ef572ce10ea8ULL,
	0x9d03358be067e1f9ULL,
	0xbf27d64d700ce911ULL,
	0xcd0acecb2ad09666ULL,
	0x8c034ed1213b9cfULL,
	0x9a8b3df72916c3b3ULL,
	0xfc65f0528bf31a13ULL,
	0x52c8a29bd3d636caULL,
	0xc724cfcd7dd126aeULL,
	0xda05a3cadbfd5485ULL,
	0x3891ba98672d4cbaULL,
	0x65df7426c0774156ULL,
	0xea11d614ed8f25a4ULL,
	0xd7e082172ca89522ULL,
	0x290d1124991f9ea1ULL,
	0x2b7ded73d5cdabaaULL,
	0x116f3d073e1d17bULL,
	0xe77bfdc15d54c98cULL,
	0x83f23aea6ec772cfULL,
	0x62c69efdf790a255ULL,
	0x57eca62a5f00dddbULL,
	0xcd36e014a182c623ULL,
	0x5991a87514e7c7a2ULL,
	0x9bd843d50bdab9abULL,
	0x710fdcb2320fc812ULL,
	0xb507793258cfb99bULL,
	0xe4519f0b2ee94368ULL,
	0xfa7553b0dd3e2b41ULL,
	0x8bbabba53f4360d1ULL,
	0x8cbe9f7e079b84aULL,
	0x9a7af6406ff8bb8ULL,
	0xcbe0efea9067fa2ULL,
	0x4e85f238e0645a49ULL,
	0xb51cd20c9b93225eULL,
	0xeac67e570dbfd22ULL,
	0x95ee95437fa1bf73ULL,
	0x12eee6b0eef0d96aULL,
	0xe5df3143746e1ca1ULL,
	0xe0b527e7bd540510ULL,
	0x4890d509351903fbULL,
	0x8a6d9d699ed8cdc2ULL,
	0x3df8ec2c8a1a4877ULL,
	0xebd57d743b7bc001ULL,
	0x848e91bb52d74ca7ULL,
	0xff08fe8ba93b43b0ULL,
	0xd7fe00434ad5d955ULL,
	0xda10233ff485c8e0ULL,
	0x4b84ea86d5e767e4ULL,
	0x3df62d7979100d04ULL,
	0x5e9b29f250b29a7fULL,
	0x2e8bdc935509fb8eULL,
	0x4457b1fd150ba7c7ULL,
	0x70b8be19230ec317ULL,
	0xb82a8e0f12a5d74bULL,
	0xb5521c9aacf4c3a4ULL,
	0xf882708ade85a47eULL,
	0xc8d37a43e0505433ULL,
	0xa01f0e81780c94cdULL,
	0x89a4e129d06cff31ULL,
	0x3a2adac6ec8c8979ULL,
	0x3e8873d1857f9a06ULL,
	0x43df20ad884cb226ULL,
	0x5b43a8365a19dd0cULL,
	0x1f03cffabb6126fdULL,
	0x317d9a43820a9c03ULL,
	0x3404c29e0ebc3d80ULL,
	0xd10afc9cc494f53dULL,
	0x24ee469b9185fcb0ULL,
	0x948c2b2abf8f2481ULL,
	0xa5ac078824b9bf2eULL,
	0xbafc1548247cda19ULL,
	0x54b2bc1fdddd8465ULL,
	0x5e4dd3ca925a59f2ULL,
	0x48d02066d4c9b82fULL,
	0x15b40b34d1fba5bbULL,
	0x57f0228bc6aaf8ceULL,
	0xf5beb656c47c7776ULL,
	0xdbd23c22758c9faULL,
	0x262048e8a011c252ULL,
	0xa1a097c7d4f8f7acULL,
	0xb067992c60963d05ULL,
	0x23d98b493a5bfe53ULL,
	0xfbc0491433c12b78ULL,
	0x7f7ae08d01d8453bULL,
	0xe78a94ec33b6c19dULL,
	0x36b7447546202034ULL,
	0x3bd73878b576ccb2ULL,
	0x53608d86c5c89181ULL,
	0x62b15038544c9b20ULL,
	0x261e5292f752e46aULL,
	0xb085f1c2962b24c2ULL,
	0xaa76d33850431304ULL,
	0xac7b179a1b5bf3fdULL,
	0xd9ec2a08c51f1b48ULL,
	0x61816237703e98b0ULL,
	0x858bcbb988f03cd7ULL,
	0x66900f7154977533ULL,
	0x1f101d8c14dd6ffULL,
	0x1c686be9e24d5569ULL,
	0x1d6c4ca5c05114ffULL,
	0x79c7932206b0359cULL,
	0xde706d6b0ef5d259ULL,
	0xaced509304bcee2dULL,
	0x96bdeae496f3f089ULL,
	0x5ebc8cf8946cf5beULL,
	0x98c3eec0246770adULL,
	0x22560e48f2b938f2ULL,
	0x73e3d0aa24470c58ULL,
	0xab7ae4b24089c5f7ULL,
	0x9cd95b5b976c97ceULL,
	0xe81cc49fa710d96ULL,
	0xfcf334d5d693db37ULL,
	0xd1968eed815d61e1ULL,
	0x13e136dd35edf1c6ULL,
	0x80b74eeba4e012aaULL,
	0xe10dc820c52f891ULL,
	0x52afb6bb931de98cULL,
	0x2b13420ffc17b735ULL,
	0x3f4524ccc0aab286ULL,
	0x5fc5d9d588b9b421ULL,
	0x694f632e3785eab1ULL,
	0xfbde92fbdc2ee74fULL,
	0x42298b48100c7500ULL,
	0xc6faf190029fd483ULL,
	0xd0d1d9d63d58cd23ULL,
	0x209dbb6254575aecULL,
	0xbf6c54fc62aa12f1ULL,
	0x65a6d550db8bd612ULL,
	0xd89347d629f42afbULL,
	0x15839983dc6f75d4ULL,
	0xcfcbba737a45d0d4ULL,
	0x638e620403504c1aULL,
	0xdbb0cd4984d08132ULL,
	0x72ae7e8fdf0dd3faULL,
	0x9973363a972d20b7ULL,
	0x24a5f2776b8a8bfULL,
	0xcedf0e4886c52f9dULL,
	0xb2dff5e397904d71ULL,
	0x6cf6077837120f00ULL,
	0x2a1e8f7b105f8325ULL,
	0xd591eaf7a5793977ULL,
	0x5b06d6a06dbb0d72ULL,
	0xf107bb2584eaec26ULL,
	0xb89df019a6bceb3eULL,
	0xdce57e686e532063ULL,
	0xaf368c26c039bc9cULL,
	0x7d1cbe311f6bdec1ULL,
	0x56c8f331486d6bf4ULL,
	0xf3eecc086ad92a05ULL,
	0xaf747706d8db2b1eULL,
	0xab2cc59b7efd6329ULL,
	0x3f877b2d260a565cULL,
	0x9acc7249130b192eULL,
	0xcce7c75d7ccb6f1bULL,
	0xa43a825759387427ULL,
	0xfe5016b46711681cULL,
	0xde2ecfa9b46e960cULL,
	0x35cad61235738b8aULL,
	0x148c5dd914505a88ULL,
	0x3448caef18556250ULL,
	0xf34cc4fb7c4b5b7aULL,
	0x1fbf650c882296deULL,
	0x2d70b17cafc5d742ULL,
	0x81afc73b91618d24ULL,
	0x63aaed2a8f9db34eULL,
	0x196747956ff5a98dULL,
	0xe1d0c20e901e444eULL,
	0x959d226339b41fddULL,
	0x3324fb92775aa6f3ULL,
	0x68ce442973d7acdcULL,
	0x4e6fe37fedf9d420ULL,
	0xd717e466fa3348b8ULL,
	0xe216008fe1ee07e0ULL,
	0x5ce336d755730c3aULL,
	0x29e76dbda77ecb44ULL,
	0x8f104ffac3fbb30eULL,
	0xc4ea79b0a60265fcULL,
	0x9c181fc5c944e1eULL,
	0x5ebb203c1ab4bac9ULL,
	0xff07ea0138e61950ULL,
	0x9b9fc36fef46bf2eULL,
	0x13f5a20dd9bd7f3bULL,
	0xace7ac67178a99eeULL,
	0x1b6bfe4ca854fc17ULL,
	0x56ee7accc3abaea5ULL,
	0x659464c0beb308c8ULL,
	0xd517614dd1878232ULL,
	0xb041a2008efbc35fULL,
	0xec0fbcff749d6bf2ULL,
	0x7093b6127db841dULL,
	0xc06094314f1875a3ULL,
	0xca89db8b3249b895ULL,
	0x6a34bb296849bee9ULL,
	0xedcf69eb31bb40eeULL,
	0x54b0386c69314eeULL,
	0xef7e27bf75b3ad92ULL,
	0x38618eca6f874dffULL,
	0x64fddacec1a8afe6ULL,
	0xcbbddfb7ef82100aULL,
	0x89a45a81117763e0ULL,
	0x15704e2cb44d116cULL,
	0xf21b0ebc6b17da46ULL,
	0xede09452e6ac033cULL,
	0xd2815c4f50ab4e20ULL,
	0x76edc034345f1357ULL,
	0x9d5e227b47e55c4bULL,
	0x99fa8badd111e2dfULL,
	0x110937dcdb387acdULL,
	0x4eeb64641f1b60e8ULL,
	0x9eea2b2b9fb32bf8ULL,
	0x1260840127e42721ULL,
	0xbeb159607b23bc30ULL,
	0x543b2528ce5e0692ULL,
	0xbe665dd5ca5095b7ULL,
	0xfb14a3cecb5a9a42ULL,
	0x9fb2e52a32005750ULL,
	0xc08f992a63a9ecc8ULL,
	0x9d6a6358f4a7b027ULL,
	0x4389aaacf41e1a2cULL,
	0x37f9598a151fc84fULL,
	0x7068c3147c814c2fULL,
	0xed7745ddd836afb0ULL,
	0x90b5ffc7f548aebcULL,
	0x9756f0a4372cdf36ULL,
	0xa266c189e7000163ULL,
	0x7343c4caef2c18cULL,
	0xe7cc2d32f61a0fd3ULL,
	0xc2d6f38ac8d54492ULL,
	0x7742a4a71c97647aULL,
	0x424a7b15b13adcb3ULL,
	0x572360cf22943204ULL,
	0x61b0592d3d9d89eaULL,
	0x680c2e306724d49cULL,
	0x40904c57d8d52122ULL,
	0x6dadc11cc6f1a900ULL,
	0xa6af42b44f43e475ULL,
	0x95e3693de303cbe6ULL,
	0x919238a4ae5e8ce3ULL,
	0x28ae5934d4b690e7ULL,
	0x3aac433cb3bfcf56ULL,
	0x6402042baabcb117ULL,
	0x9265156370256db3ULL,
	0xccf8d7b53f8ed7ffULL,
	0x3440f4fed4d04d15ULL,
	0x665074af8486502fULL,
	0x356f97c5ed153e56ULL,
	0x85ef72d012a11a76ULL,
	0xda6c645247ce8e51ULL,
	0xd4c417422f9f317cULL,
	0x4e24a86bbbc776e9ULL,
	0x3e4809f531a7a889ULL,
	0x3aa3f4c71f82026ULL,
	0xc8be58ad47215f21ULL,
	0xdec7fdda1619b97ULL,
	0x6b34034e6aa5262fULL,
	0xf023e2c54904504fULL,
	0x5afd94be7bafedf3ULL,
	0x5f65ae812aaef59fULL,
	0x3d20a9be1ebe9b83ULL,
	0x6e60fc77ec7959b8ULL,
	0xc9310a1734813400ULL,
	0xa9a1f8cabb9bd6bbULL,
	0x7c48821ad003e5cULL,
	0xe1f90ca1009f4882ULL,
	0xffd2952f29d6beecULL,
	0xfb3d9ee314f51662ULL,
	0x68ce6c67774c154ULL,
	0xf276616e7f331928ULL,
	0x4e6dcf36a9edad19ULL,
	0xb283670f18a5a74dULL,
	0x7a923872d08df0e8ULL,
	0x30a0a4bce4adbb71ULL,
	0xfb2b4b8ca85a2128ULL,
	0x434062716432b39fULL,
	0x6038f71158be3875ULL,
	0x3024bead8c9f2c57ULL,
	0x7e86380bd86c5f0aULL,
	0xfbd85377688239bfULL,
	0xcffc3bc92f7cfa32ULL,
	0x2c3d873fd4624670ULL,
	0xba94dfdb8108ec4ULL,
	0x7348c7f753f6c468ULL,
	0x618ecbedb3c36902ULL,
	0x66b344c4911501caULL,
	0xa9cf60162d8cd208ULL,
	0x1ba51e7663bac544ULL,
	0xd402f03d7bac91a5ULL,
	0xc82fce8de56af66dULL,
	0x94e5ee9a05e96a60ULL,
	0x28f3ffd60321e59dULL,
	0x954f7aab66cf2770ULL,
	0x6e2eec9636238ca1ULL,
	0x71bb9a3d3d0bb853ULL,
	0x484916d034e4d092ULL,
	0xdce2ab728c64c40cULL,
	0x355c7692cc13bef7ULL,
	0xc02619da4fbb4cc0ULL,
	0x6b27683910011290ULL,
	0x9cb802d6a3cc33f1ULL,
	0xd68ba38036117ebeULL,
	0x56c5f84f8b0d46abULL,
	0xb04fb89d3dfd6dc8ULL,
	0x3b99d87d1e48cf75ULL,
	0x4fb4551a21db540fULL,
	0x1023f83ceab22775ULL,
	0xa5d2198311c1a217ULL,
	0x4b2be37cf6e76da3ULL,
	0xa94aba6a11f00ab1ULL,
	0xc1ac6604c9e7b248ULL,
	0x4f5c5218a0aaddbeULL,
	0x65ea82f5619e8a9aULL,
	0x68243ab1a9a5d1ebULL,
	0x67d92cd6ecd6b209ULL,
	0x26b0cb1750411c26ULL,
	0x76896ecb1bee6214ULL,
	0xdc0611f945bb66f1ULL,
	0x5d5e3190cb24befbULL,
	0xfa689761051dec82ULL,
	0x60f37c6c45fc27eULL,
	0x82d77ff56d946f83ULL,
	0xb0ec47ba81df1435ULL,
	0xd9e78f07494fac37ULL,
	0x91440890a2470447ULL,
	0x73aa0d596c2c4db5ULL,
	0x649103de5893c612ULL,
	0x2286226838db36f5ULL,
	0xa5d33881c6c457d9ULL,
	0xfbd887f56d301158ULL,
	0x2d88c8d236a150e5ULL,
	0x891c8a6153e98fa1ULL,
	0xe8fd92d135398638ULL,
	0xc4e680098855a34dULL,
	0xe401ed7874452701ULL,
	0x329839241b7463ebULL,
	0xc72e66c49a2b2ea1ULL,
	0xe48a630a638f34c1ULL,
	0x56c8cd3b2a2d991aULL,
	0xef75007d29ea4ULL,
	0x4696f43eed8ce0a8ULL,
	0x2aff68c100c0a343ULL,
	0x7f2eb441561f9456ULL,
	0x3f39d06fafe5908aULL,
	0x81d167a8dd00bf0aULL,
	0xede4f75a2b649511ULL,
	0x243017ad74f1bf91ULL,
	0xa36493b837cff4e1ULL,
	0x77a6a2b0c7d7e68aULL,
	0x7c0294600740001cULL,
	0xe5bd2f850a207f4ULL,
	0x95eea0bde4eeb0c7ULL,
	0xfbda5b998acaae3fULL,
	0x84ab389d2ce8cb34ULL,
	0x37cddfd659260c42ULL,
	0xf43c7dde09d9d0c4ULL,
	0x953384abf3f84622ULL,
	0x62c008e2fd3b913aULL,
	0x3fa59b3935d8b28cULL,
	0x3306408570db576cULL,
	0x14f46859d0f9b059ULL,
	0x991cb4e3ec67fb9dULL,
	0xa6de6fa5e75f1c1bULL,
	0xd076014cdfbb8bdbULL,
	0x8c4bf8bcdde1deffULL,
	0xc02b8c0c56bb0b7aULL,
	0xcdf92d27ef36615bULL,
	0x3d0bf84913b179e8ULL,
	0xe8345c241a26160ULL,
	0x9a6bc6c73191f59eULL,
	0x78428cd060c08701ULL,
	0xe8a09de627ed5c95ULL,
	0x600c110d2902504dULL,
	0x8edf57c268be3425ULL,
	0xbe05e0e5fa030226ULL,
	0xed85c2cf1a1c1c5fULL,
	0xffcc194cc7cc8974ULL,
	0xa03e85dcec55b633ULL,
	0x2948ae3f7b51911fULL,
	0x729666617d8055cULL,
	0x727c5f92dd27d942ULL,
	0x247267a64348d379ULL,
	0xc85757294d5ab800ULL,
	0xc7e247edd10f598fULL,
	0x27f8d82651de24dfULL,
	0xaf77a7c2397b6ad5ULL,
	0xf1075c2637c11263ULL,
	0x820db4715a2d50aeULL,
	0xa78b712be7c97debULL,
	0xed0c94fe16855d33ULL,
	0xa9247a5cb34b1908ULL,
	0x69e2281a6f315e27ULL,
	0xb4c2fa5dc8f21fc0ULL,
	0x1c18d4a516ae7ed3ULL,
	0x5144fe3bf5006c5ULL,
	0xa6db907ac13195daULL,
	0x347b83cd6864c63eULL,
	0x1b1be627e4a3ce73ULL,
	0xc89e67970f0dd049ULL,
	0xeca6db5fc9cd578dULL,
	0x1b3bc14d1077658eULL,
	0x3a383d471cde44c5ULL,
	0xea684ef8bd63ddafULL,
	0x5f26abb2190bb2eaULL,
	0xc12f7d090b8d609ULL,
	0x1e92b60d6e808c01ULL,
	0x3b2aa7b501aed19eULL,
	0xea0f366c12d042f6ULL,
	0xa07669e03d57c1beULL,
	0x4c8a9b08f08895a8ULL,
	0xde264a416fb70d58ULL,
	0x9b1fc7e60276c5a0ULL,
	0xa13ad0bc3fc2a2d5ULL,
	0xd0f327a295570ebdULL,
	0x53d344deddd3ee07ULL,
	0xb932ac93e34cce81ULL,
	0xbbea4eebd5716769ULL,
	0x8b356f293b55b7aULL,
	0x6747db884a1f176eULL,
	0xbc8025ff69e7264cULL,
	0x47b18ba858ddcb12ULL,
	0x61ef9e0fe8fbe954ULL,
	0x3282f040e760a95aULL,
	0xe7fa2c60a4e770baULL,
	0xd9e83eacc5994329ULL,
	0xa0b5f8217be958a6ULL,
	0x80538d8f5574bccbULL,
	0xa5e23a1356fb03a5ULL,
	0x6b8b81717d08c6b8ULL,
	0x19784f6928d15435ULL,
	0x4dd883c1de3fecb7ULL,
	0xe03a37af4b7eb438ULL,
	0x141395327aacca7ULL,
	0xbbb06e8ba95c3e95ULL,
	0xee04035456ddf2e3ULL,
	0x3af3a205524cc23bULL,
	0x7b1c19e599593f5aULL,
	0xb9099a6e35b67d6aULL,
	0xbb0b7f122fe12859ULL,
	0x5628095cfcf7dd6cULL,
	0x91212d3737da35b4ULL,
	0x85da0e439e485e61ULL,
	0x195cdc84bdb9546cULL,
	0x80f30462eb81520eULL,
	0x14b57009e9488e31ULL,
	0x218de98a5cfe0a18ULL,
	0x6e515d0a33437434ULL,
	0x8b592d3ba009b8feULL,
	0xdafe055636a88e17ULL,
	0x55b7cc52b756d680ULL,
	0x9f4312b048b9f6b6ULL,
	0xc4f8498f6a47e4d0ULL,
	0x38792d2f4ae85b0eULL,
	0x979f9c5b37c03132ULL,
	0xeb17263cf26d5a6aULL,
	0xd39ed5af554ab88fULL,
	0x9e6a16a8ef52802aULL,
	0x7ef7116d4c375633ULL,
	0xc01e0fb3ea6c0256ULL,
	0x83d769562d0c7c66ULL,
	0x6a8dfe02b1531eacULL,
	0xb1345cb90b3e8e01ULL,
	0x671ba54bbf449b7fULL,
	0xb5fc71e5a2de26e8ULL,
	0x86197e1cb3a51367ULL,
	0x45ea015872784286ULL,
	0xdcf7ea97cfae1e0ULL,
	0x4f96095f161db49aULL,
	0x5bb361e9996a8f83ULL,
	0x8565093f3783458dULL,
	0x4ca84f5ff15b22b2ULL,
	0xdad770b145ccdbf0ULL,
	0xdb4e91da3b075631ULL,
	0xbbf05db5184fb818ULL,
	0xa9524f006827e5d7ULL,
	0xa46d33b23bf486c6ULL,
	0xc784365020a80502ULL,
	0xaaf6d6eb8222cfbcULL,
	0xa481efa18c724e7eULL,
	0x3c28f50e91c817b1ULL,
	0x4ffa6044c13753bdULL,
	0x5165a99115131fc6ULL,
	0x1df23586c4371867ULL,
	0xb0adc11dd316941ULL,
	0xb77fa479abb0c1e2ULL,
	0xf84102ee7d34936eULL,
	0xa4601d3246f243f2ULL,
	0x83645176f9da4be2ULL,
	0xda31cb15a7dc864ULL,
	0x59892a3cf0dfe3a1ULL,
	0x553376822529d662ULL,
	0x183e80f4202c609eULL,
	0x62961c853f642216ULL,
	0x812963b6c01101a2ULL,
	0xcd458124e25483f6ULL,
	0x1183099325603964ULL,
	0xd881bf090a7ccc53ULL,
	0xb9e4b5831470fa07ULL,
	0x7524ecc616c5d46ULL,
	0xd9b1ae5a3757e142ULL,
	0xbbf2b0f065a18812ULL,
	0xd89d7456270bae2aULL,
	0x6efd05a6708d4d8eULL,
	0xbce2427f7e16033cULL,
	0xed805ea3027b95cULL,
	0x11de12df42b4dc2aULL,
	0x4ccd718fe4979d6fULL,
	0x2276c70c6b1efdf2ULL,
	0x63a71827ac90f3efULL,
	0xa6d23ed200978046ULL,
	0x9f83ff8b2a227281ULL,
	0x520a4c28d55e0aabULL,
	0x9208f49a68af1d1dULL,
	0x994046c8192cfd2ULL,
	0xf0b84444b489fe83ULL,
	0x8853cb95fe70464cULL,
	0x4cdf6ba744c3f663ULL,
	0xb97e0e290a5744a2ULL,
	0xa3e38be2345e2581ULL,
	0x569632d926151cf9ULL,
	0xf950d266137b0b57ULL,
	0x295162e91db30ea4ULL,
	0xd3735f5fe43a9adeULL,
	0x16103228f4d8e7daULL,
	0x1acc2e6cbbfa2012ULL,
	0x11b8e1fe0d530bc7ULL,
	0x3c67d6325990507ULL,
	0x88d0029f8f1da1ceULL,
	0x2c34dee21d103585ULL,
	0x827dc7643c331e7ULL,
	0xc061afa87606fd37ULL,
	0x945af6563190233eULL,
	0x1aaae1598030f02dULL,
	0xa00643e6538d0020ULL,
	0xfab775db41f4599bULL,
	0xc7b100d10ba897cdULL,
	0x1e9ba05edf116aa7ULL,
	0xad57b91ca3f6033cULL,
	0xff2be2216e5f2340ULL,
	0xed46027f12571dbfULL,
	0xf11a6c6572cf2f3aULL,
	0xe19dfeebdcb75017ULL,
	0x54ff2f5ddc36b157ULL,
	0x1b1ec099ce08e7a5ULL,
	0x6e2c13c9261bf9ccULL,
	0x1bb910ceaaa50e3aULL,
	0xe49c82fee0833250ULL,
	0xfd34c291aeba6ed6ULL,
	0x88d3c964a7981c34ULL,
	0x58e62c1ade2c516aULL,
	0x8e3da38d2092872bULL,
	0xe5a384a5eed000b7ULL,
	0x31113c7ccde35296ULL,
	0xe1e99889fb40cd41ULL,
	0xa9ac662be5e781aULL,
	0x52d6166b2719948dULL,
	0x61ec0fda38934694ULL,
	0x7b52c1d14a7fedd6ULL,
	0x459b9dbb8be22a3eULL,
	0xe208090155112bc3ULL,
	0x5c48aafc21400d7eULL,
	0x5f026ffdac39c927ULL,
	0x1463f00c55a05409ULL,
	0xfcbe1153ea53b7c2ULL,
	0xde6d5dd612df0a77ULL,
	0x4c584ef5e4acef1eULL,
	0x50175571762f0e72ULL,
	0x2b14ea3a7a7c696eULL,
	0xaee1a5c2c3478afeULL,
	0x30907fc495fe1da2ULL,
	0xbdd853c1a88c9998ULL,
	0x73a8888da79ad29fULL,
	0x7b0158f8d0f4758dULL,
	0x3332a586ddf6d623ULL,
	0xc577eb29630c9bdeULL,
	0x9f16a4ab47580a0aULL,
	0xf60998a69332d184ULL,
	0xb7ee92ec64025d2eULL,
	0x65b7c21ae267bdb3ULL,
	0xd4fd7a8e38685665ULL,
	0x1cdd56d07daadc2eULL,
	0x19ada51ef41839f4ULL,
	0xf4bd6402ed39e817ULL,
	0xf6944066d6d705fULL,
	0xbfccfb1cbd1a86fbULL,
	0x796dd971ef4c646fULL,
	0xbc9aa06f9800cc5bULL,
	0x2eacc9a4bbbe6a1eULL,
	0x229bd658d433d0abULL,
	0x9cb5ae758c128651ULL
};

void Board::init()
{
	unsigned int k = 0;
	
	/* Generate hash keys */
	for (int c=0; c<2; c++) {
		for (int p=0; p<6; p++) {
			for (int s=0; s<64; s++) {
				//hashkeys[c][p][s] = random64();
				hashkeys[c][p][s] = hashkey_table[k++];
			}
		}
	}
	
	for (int s=0; s<64; s++) {
		//hash_ep[s] = random64();
		hash_ep[s] = hashkey_table[k++];
	}
	
	//hash_side = random64();
	//hash_wk = random64();
	//hash_wq = random64();
	//hash_bk = random64();
	//hash_bq = random64();
	hash_side = hashkey_table[k++];
	hash_wk = hashkey_table[k++];
	hash_wq = hashkey_table[k++];
	hash_bk = hashkey_table[k++];
	hash_bq = hashkey_table[k++];

	/* hashkey_table should have contained as many hashkeys as we needed */
	ASSERT(k == sizeof(hashkey_table) / sizeof(Hashkey));
}
