{- This module was generated from data in the Kate syntax
   highlighting file lua.xml, version 1.06, by  -}

module Text.Highlighting.Kate.Syntax.Lua
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygenlua
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Lua"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.lua"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Lua","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Lua","Normal") -> return ()
      ("Lua","Comment") -> (popContext) >> pEndLine
      ("Lua","Block Comment") -> return ()
      ("Lua","String_single") -> pushContext ("Lua","Error") >> return ()
      ("Lua","String_double") -> pushContext ("Lua","Error") >> return ()
      ("Lua","String_block") -> return ()
      ("Lua","Error") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "and function in local not or"
list_control = Set.fromList $ words $ "break do else elseif end for if repeat return then until while"
list_pseudo'2dvariables = Set.fromList $ words $ "nil false true"
list_basefunc = Set.fromList $ words $ "string.byte string.char string.find string.len string.lower string.rep string.sub string.upper string.format string.gfind string.gsub table.concat table.getn table.sort table.insert table.remove table.setn math.abs math.sin math.cos math.tan math.asin math.acos math.atan math.atan2 math.ceil math.floor math.mod math.frexp math.ldexp math.squrt math.min math.max math.log math.log10 math.exp math.deg math.rad math.random math.randomseed io.close io.flush io.input io.lines io.open io.output io.read io.stderr io.stdin io.stdout io.tmpfile io.write os.clock os.date os.difftime os.execute os.exit os.getenv os.remove os.rename os.setlocale os.time os.tmpname debug.getinfo debug.getlocal debug.setlocal debug.sethook debug.gethook assert collectgarbage dofile error next print rawget rawset tonumber tostring type _ALERT _ERRORMESSAGE call getmetatable gcinfo ipairs loadfile loadstring pairs pcall require LUA_PATH setmetatable _LOADED _VERSION gettagmethod globals newtag setglobal settag settagmethod setlinehook getglobals copytagmethods dostring getglobal tag setglobals unpack exit readfrom writeto appendto read write getinfo getlocal setlocal setcallhook tinsert tremove flush seek setlocale execute remove rename tmpname getenv getn sort table.foreach table.foreachi foreach foreachi abs sin cos tan asin acos atan atan2 ceil floor mod frexp ldexp squrt min max log log10 exp deg rad random randomseed strlen strsub strlower strupper strchar strrep ascii strbyte format strfind gsub openfile closefile date clock cgilua cgilua.lp.translate cgilua.contentheader cgilua.script_file cgilua.header cgilua.script_path cgilua.htmlheader cgilua.script_pdir cgilua.redirect cgilua.script_vdir cgilua.mkabsoluteurl cgilua.script_vpath cgilua.mkurlpath cgilua.servervariable cgilua.put cgilua.urlpath cgilua.handlelp cgilua.errorlog cgilua.lp.compile cgilua.seterrorhandler cgilua.lp.include cgilua.seterroroutput cgilua.lp.setcompatmode cgilua.addclosefunction cgilua.lp.setoutfunc cgilua.addopenfunction cgilua.addscripthandler cgilua.addscripthandler cgilua.buildprocesshandler cgilua.setmaxfilesize cgilua.setmaxinput cgilua.urlcode.encodetable cgilua.urlcode.escape cgilua.urlcode.parsequery cgilua.urlcode.unescape cgilua.urlcode.insertfield cgilua.setoutfunc cgilua.addopenfunction cgilua.doif cgilua.doscript cgilua.pack cgilua.splitpath cgilua.cookies.get cgilua.cookies.set cgilua.cookies.sethtml cgilua.cookies.delete cgilua.serialize cgilua.session.close cgilua.session.data cgilua.session.load cgilua.session.new cgilua.session.open cgilua.session.save cgilua.session.setsessiondir cgilua.session.delete cgilua.session cgilua.cookies numrows connect close fetch getcolnames getcoltypes commit rollback setautocommit lfs lfs.attributes lfs.chdir lfs.currentdir lfs.dir lfs.lock lfs.mkdir lfs.rmdir lfs.touch lfs.unlock zip zip.open zip.openfile files seek close lines"
list_attention = Set.fromList $ words $ "TODO FIXME NOTE"
list_deprecated = Set.fromList $ words $ "table.foreach table.foreachi foreach foreachi"

regex_'5cbfunction'5cb = compileRegex True "\\bfunction\\b"
regex_'5cbelse'5cb = compileRegex True "\\belse\\b"
regex_'5cbelseif'5cb = compileRegex True "\\belseif\\b"
regex_'5cbdo'5cb = compileRegex True "\\bdo\\b"
regex_'5cbif'5cb = compileRegex True "\\bif\\b"
regex_'5cbend'5cb = compileRegex True "\\bend\\b"
regex_'5cb'5cd'2a'5c'2e'3f'5cd'2a'28e'7ce'5c'2d'7ce'5c'2b'29'3f'5cd'2b'5cb = compileRegex True "\\b\\d*\\.?\\d*(e|e\\-|e\\+)?\\d+\\b"
regex_'5cb'2d'3f0'5bxX'5d'5b0'2d9a'2dfA'2dF'5d'2b'5cb = compileRegex True "\\b-?0[xX][0-9a-fA-F]+\\b"
regex_'5cb'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'28'3f'3d'5cs'2a'28'5b'28'7b'27'22'5d'7c'5c'5b'5c'5b'29'29'5cb = compileRegex True "\\b[a-zA-Z_][a-zA-Z0-9_]*(?=\\s*([({'\"]|\\[\\[))\\b"
regex_'5cb'5bA'2dZ'5f'5d'5bA'2dZ0'2d9'5f'5d'2a'5cb = compileRegex True "\\b[A-Z_][A-Z0-9_]*\\b"
regex_'5cb'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5cb = compileRegex True "\\b[a-zA-Z_][a-zA-Z0-9_]*\\b"
regex_'5c'5c'28a'7cb'7cf'7cn'7cr'7ct'7cv'7c'5c'5c'7c'22'7c'5c'27'7c'5b'7c'5d'29 = compileRegex True "\\\\(a|b|f|n|r|t|v|\\\\|\"|\\'|[|])"
regex_'5c'5c'5babfnrtv'27'22'5c'5c'5c'5b'5c'5d'5d = compileRegex True "\\\\[abfnrtv'\"\\\\\\[\\]]"

parseRules ("Lua","Normal") =
  (((Text.Highlighting.Kate.Syntax.Doxygenlua.parseExpression (Just ("DoxygenLua",""))))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_deprecated >>= withAttribute ErrorTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExprDynamic "--\\[(=*)\\[" >>= withAttribute CommentTok) >>~ pushContext ("Lua","Block Comment"))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext ("Lua","Comment"))
   <|>
   ((pRegExprDynamic "\\[(=*)\\[" >>= withAttribute StringTok) >>~ pushContext ("Lua","String_block"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Lua","String_single"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Lua","String_double"))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_basefunc >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5cbfunction'5cb >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_pseudo'2dvariables >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbelse'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbelseif'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbdo'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbif'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbend'5cb >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_control >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5cb'5cd'2a'5c'2e'3f'5cd'2a'28e'7ce'5c'2d'7ce'5c'2b'29'3f'5cd'2b'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cb'2d'3f0'5bxX'5d'5b0'2d9a'2dfA'2dF'5d'2b'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cb'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'28'3f'3d'5cs'2a'28'5b'28'7b'27'22'5d'7c'5c'5b'5c'5b'29'29'5cb >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZ'5f'5d'5bA'2dZ0'2d9'5f'5d'2a'5cb >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5cb >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '!' '=' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '-' '=' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '+' '=' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '+' '+' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '.' '=' >>= withAttribute ErrorTok))
   <|>
   ((pAnyChar "[]().,=~+-*/^><#;" >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Lua","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Lua","Comment") =
  (((pDetect2Chars False '-' '-' >>= withAttribute AlertTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_attention >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Lua","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Lua","Block Comment") =
  (((pRegExprDynamic "\\]%1\\]" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute AlertTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_attention >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Lua","Block Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Lua","String_single") =
  (((pRegExpr regex_'5c'5c'28a'7cb'7cf'7cn'7cr'7ct'7cv'7c'5c'5c'7c'22'7c'5c'27'7c'5b'7c'5d'29 >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Lua","String_single")) >> pDefault >>= withAttribute StringTok))

parseRules ("Lua","String_double") =
  (((pRegExpr regex_'5c'5c'5babfnrtv'27'22'5c'5c'5c'5b'5c'5d'5d >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Lua","String_double")) >> pDefault >>= withAttribute StringTok))

parseRules ("Lua","String_block") =
  (((pRegExpr regex_'5c'5c'28a'7cb'7cf'7cn'7cr'7ct'7cv'7c'5c'5c'7c'22'7c'5c'27'7c'5b'7c'5d'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExprDynamic "\\]%1\\]" >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Lua","String_block")) >> pDefault >>= withAttribute StringTok))

parseRules ("Lua","Error") =
  (currentContext >>= \x -> guard (x == ("Lua","Error")) >> pDefault >>= withAttribute ErrorTok)

parseRules ("DoxygenLua", _) = Text.Highlighting.Kate.Syntax.Doxygenlua.parseExpression Nothing

parseRules x = parseRules ("Lua","Normal") <|> fail ("Unknown context" ++ show x)
