/*
 * Hexxagon board game.
 * Copyright (C) 2001 Erik Jonsson.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Email erik@nesqi.homeip.net
 * 
 */

#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

guchar *convert_xpm_to_rgb(char **xpm)
{
	int x = atoi(*xpm);
	int y = atoi(strchr(*xpm, ' ') + 1);

	guchar *data = (guchar*) malloc(x * y * 3);
	
	int nr_colors = atoi(strchr(strchr(*xpm, ' ') + 1, ' ') + 1);
	guchar color_tab[65536 * 3];
	
	int size = (*xpm)[strlen(*xpm)-1] - '0';

	int index = (' ' + (size == 2 ? ' ' << 8 : 0)) * 3;
	color_tab[index + 0] = 255;
	color_tab[index + 1] = 0;
	color_tab[index + 2] = 255;

	for(int i = 2; i <= nr_colors; i++)
	{
		index = (xpm[i][0] + (size == 2 ? (xpm[i][1] << 8) : 0)) * 3;
		char color[3];
		color[2] = 0;
		
		char *cp = xpm[i] + 4 + size; //strchr(xpm[i] + size, '#') + 1;
		
		color[0] = *cp++; color[1] = *cp++;
		color_tab[index + 0] = strtol(color, 0, 16);

		color[0] = *cp++; color[1] = *cp++;
		color_tab[index + 1] = strtol(color, 0, 16);

		color[0] = *cp++; color[1] = *cp++;
		color_tab[index + 2] = strtol(color, 0, 16);
	}

	guchar *dp = data;
	for(int i = 0; i < y; i++)
	{
		char *cp = xpm[i + nr_colors + 1];
	
		while(*cp)
		{
			int index = (cp[0] + (size == 2 ? cp[1] << 8 : 0)) * 3;
			cp += size;

			*dp++ = color_tab[index + 0];
			*dp++ = color_tab[index + 1];
			*dp++ = color_tab[index + 2];
		}
	}

	return data;
}
