/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: visuals.cpp,v 1.1.1.1.42.2 2004/07/09 12:48:45 pankajgupta Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include <stdio.h>
#include <stdlib.h>

#include "visuals.h"

#if defined(_AIX)
#include <stdlib.h>
#endif


// local helpers 
#ifdef _DEBUG
void PrintVisualInfo(XVisualInfo info);
#endif


#ifdef _DEBUG
//#define PRINTVISUAL 0
int print_visual = 0;
#endif

Visual* GetBestVisual(Display* display)
{
    Visual* vis = NULL;
    XVisualInfo vinfo_template;
    long mask;


#ifdef _DEBUG
#ifdef PRINTVISUAL
    // Print out the display visuals.
    if(print_visual == 0)
    {
        int nused, nmaps = MaxCmapsOfScreen(XDefaultScreenOfDisplay(display));

	 XLockDisplay(display);
        Colormap* pMaps = XListInstalledColormaps(display, 
                                     XDefaultRootWindow(display), &nused);
	 XUnlockDisplay(display);
        XFree(pMaps);

        printf("This screen supports %d colormaps. (%d are used)\n", nmaps, nused);

        int items;

	XVisualInfo* vinfo_list;
	XLockDisplay(display);
	vinfo_list = XGetVisualInfo(display, 0, &vinfo_template, &items);
	XUnlockDisplay(display);
	if (items > 0)
	  {
            for(int i = 0; i < items; i++)
	      {
		PrintVisualInfo(vinfo_list[i]);
	      }
	  }

	XFree(vinfo_list);

	print_visual = 1;
    }
#endif
#endif


    // Search for a visual on the display that will support our images.
    memset(&vinfo_template, 0, sizeof(XVisualInfo));

    vinfo_template.depth      = 24;
    vinfo_template.c_class    = TrueColor;
    vinfo_template.blue_mask  = 0x0000ff;
    vinfo_template.green_mask = 0x00ff00;
    vinfo_template.red_mask   = 0xff0000;
    mask = VisualDepthMask|VisualClassMask|VisualRedMaskMask|
           VisualGreenMaskMask|VisualBlueMaskMask;
    vis = GetVisual(display, mask, &vinfo_template);


    if (!vis)
    {
      vinfo_template.depth      = 24;
      vinfo_template.c_class    = TrueColor;
      vinfo_template.blue_mask  = 0xff0000;
      vinfo_template.green_mask = 0x00ff00;
      vinfo_template.red_mask   = 0x0000ff;
      mask = VisualDepthMask|VisualClassMask|VisualRedMaskMask|
	     VisualGreenMaskMask|VisualBlueMaskMask;
      vis = GetVisual(display, mask, &vinfo_template);
    }


    if (!vis)
    {
      vinfo_template.depth      = 16;
      vinfo_template.c_class    = TrueColor;
      vinfo_template.blue_mask  = 0x001f;
      vinfo_template.green_mask = 0x07e0;
      vinfo_template.red_mask   = 0xf800;
      mask = VisualDepthMask|VisualClassMask;
      vis = GetVisual(display, mask, &vinfo_template);
    }

    if (!vis)
    {
      vinfo_template.depth      = 15;
      vinfo_template.c_class    = TrueColor;
      vinfo_template.blue_mask  = 0x001f;
      vinfo_template.green_mask = 0x03e0;
      vinfo_template.red_mask   = 0x7c00;
      mask = VisualDepthMask|VisualClassMask;
      vis = GetVisual(display, mask, &vinfo_template);
    }

    if (!vis)
    {
      vinfo_template.depth      = 8;
      vinfo_template.c_class    = PseudoColor;
      mask = VisualDepthMask|VisualClassMask;
      vis = GetVisual(display, mask, &vinfo_template);
    }

    if (!vis)
    {
      vinfo_template.depth      = 32;
      vinfo_template.c_class    = TrueColor;
      vinfo_template.blue_mask  = 0xff0000;
      vinfo_template.green_mask = 0x00ff00;
      vinfo_template.red_mask   = 0x0000ff;
      mask = VisualDepthMask|VisualClassMask;
      vis = GetVisual(display, mask, &vinfo_template);
    }
    if (!vis)
    {
      vinfo_template.depth      = 32;
      vinfo_template.c_class    = TrueColor;
      vinfo_template.blue_mask  = 0xff000000;
      vinfo_template.green_mask = 0x00ff0000;
      vinfo_template.red_mask   = 0x0000ff00;
      mask = VisualDepthMask|VisualClassMask;
      vis = GetVisual(display, mask, &vinfo_template);
    }
    if (!vis)
    {
      vinfo_template.depth      = 32;
      vinfo_template.c_class    = TrueColor;
      vinfo_template.blue_mask  = 0x0000ff;
      vinfo_template.green_mask = 0x00ff00;
      vinfo_template.red_mask   = 0xff0000;
      mask = VisualDepthMask|VisualClassMask;
      vis = GetVisual(display, mask, &vinfo_template);
    }
    if (!vis)
    {
      vinfo_template.depth      = 32;
      vinfo_template.c_class    = TrueColor;
      vinfo_template.blue_mask  = 0x0000ff00;
      vinfo_template.green_mask = 0x00ff0000;
      vinfo_template.red_mask   = 0xff000000;
      mask = VisualDepthMask|VisualClassMask;
      vis = GetVisual(display, mask, &vinfo_template);
    }

    if (!vis)
    {
      // No valid visual found.
      printf("G2 Core: Requires  15/16/24/32 bit TrueColor or PseudoColor Visual display.\n");
      exit(1);
    }

    return vis;
}


Visual* GetVisual(Display* display, long mask, XVisualInfo* templ)
{
    int items;
    XVisualInfo* vinfo_list;

    Visual* res = NULL;

    XLockDisplay(display);
    vinfo_list = XGetVisualInfo(display, mask, templ, &items);
    XUnlockDisplay(display);
    if (items > 0)
    {
        for(int i = 0; i < items; i++)
        {
            if((vinfo_list[i].c_class == templ->c_class) &&
               (vinfo_list[i].depth == templ->depth))
            {
#ifdef _DEBUG
	        //printf("GetVisual: Found best visual.\n");
	        PrintVisualInfo(vinfo_list[i]);
#endif
                res  = vinfo_list[i].visual;
                break;
            }
        }
    }
    if (vinfo_list)
	    XFree(vinfo_list);

    return res;
}


#ifdef _DEBUG
void PrintVisualInfo(XVisualInfo info)
{
    char* pClass;


    switch(info.c_class)
    {
        case GrayScale:   pClass = "GrayScale";   break;
        case StaticGray:  pClass = "StaticGray";  break;
        case TrueColor:   pClass = "TrueColor";   break;
        case DirectColor: pClass = "DirectColor"; break;
        case PseudoColor: pClass = "PseudoColor"; break;
        case StaticColor: pClass = "StaticColor"; break;
    }
    printf("Class = %s, Depth = %d\n", pClass, info.depth);
}
#endif



