/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: fontdefs.h,v 1.1.2.1 2004/07/09 01:50:15 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  fontdefs.h
//
//  font-related #defines.
//


#if !defined(_FONTDEFS_H_)
#define _FONTDEFS_H_


#define FONT_SIZE_MINUS3	10L /* for plain-text user pref sizing only,*/
#define FONT_SIZE_MINUS2	12L
#define FONT_SIZE_MINUS1	14L
#define FONT_SIZE_0		16L
#define FONT_SIZE_PLUS1		20L
#define FONT_SIZE_PLUS2		24L
#define FONT_SIZE_PLUS3		36L
#define FONT_SIZE_PLUS4		48L

#define FONT_SIZEFACTOR_SMALLER_PCT	83
#define FONT_SIZEFACTOR_LARGER_PCT	120
  
//Added this so Windows & Mac could use same font:
//this is what Netscape and IE use as default font (face):
#define DEFAULT_FONT_STR		"TIMES" //"times new roman" works too

#define TIMES_FONT_FACE_INDX		20L
#define DEFAULT_FONT_FACE_INDX		TIMES_FONT_FACE_INDX
#define COURIERTT_FONT_FACE_INDX	22L
#define SYSTEM_FONT_FACE_INDX		3L
#define GENEVA_FONT_FACE_INDX		SYSTEM_FONT_FACE_INDX
#define ARIAL_FONT_FACE_INDX		21L
#define USES_ARIAL_SPACING		0x1000
#define USES_TIMES_SPACING		0x2000
#define USES_COURIER_SPACING		0x4000
#define USES_SYSTEM_SPACING		0x8000
#define ARIAL_DERIVATIVE_FONT		0x10000

//This tells us we're using a CJK (Chinese, Japanes, Korean) or other DBCS:
#define CJK_FONT_INDEX			0x100000L
//This tells us we are using the wrong # (on the Mac) until we know more:
#define INVALID_FONT_INDEX		0x1000000L

#define ARIAL_BLACK_FONT_FACE_INDX		(ARIAL_DERIVATIVE_FONT | \
						USES_ARIAL_SPACING | 1L)
#define ARIAL_NARROW_FONT_FACE_INDX		(ARIAL_DERIVATIVE_FONT | \
						USES_ARIAL_SPACING | 2L)
#define ARIAL_ROUNDED_MT_BOLD_FONT_FACE_INDX	(ARIAL_DERIVATIVE_FONT | \
						USES_ARIAL_SPACING | 3L)
#define ALGERIAN_FONT_FACE_INDX			(USES_COURIER_SPACING + 4L)
#define BOOK_ANTIQUA_FONT_FACE_INDX		(USES_ARIAL_SPACING + 5L)
#define BOOKMAN_OLD_STYLE_FONT_FACE_INDX	(USES_ARIAL_SPACING + 6L)
#define BRAGGADOCIO_FONT_FACE_INDX		(USES_ARIAL_SPACING + 7L)
#define BRITANNIC_BOLD_FONT_FACE_INDX		(USES_ARIAL_SPACING + 8L)
#define BRUSH_SCRIPT_FONT_FACE_INDX		(USES_TIMES_SPACING + 9L)
#define CENTURY_GOTHIC_FONT_FACE_INDX		(USES_ARIAL_SPACING + 10L)
#define CENTURY_SCHOOLBOOK_FONT_FACE_INDX	(USES_ARIAL_SPACING + 11L)
#define COLONNA_MT_FONT_FACE_INDX		(USES_TIMES_SPACING + 12L)
#define DESDEMONA_FONT_FACE_INDX		(USES_ARIAL_SPACING + 13L)
#define FOOTLIGHT_MT_LIGHT_FONT_FACE_INDX	(USES_ARIAL_SPACING + 14L)
#define GARAMOND_FONT_FACE_INDX			(USES_TIMES_SPACING + 15L)
#define HAETTENSCHWEILER_FONT_FACE_INDX		(USES_ARIAL_SPACING + 16L)
#define IMPACT_FONT_FACE_INDX			(USES_ARIAL_SPACING + 17L)
#define KINO_MT_FONT_FACE_INDX			(USES_TIMES_SPACING + 18L)
#define MATURA_MT_SCRIPT_CAPITALS_FONT_FACE_INDX    (USES_TIMES_SPACING + 19L)
#define MODERN_FONT_FACE_INDX			(USES_ARIAL_SPACING + 20L)
#define MS_DIALOG_FONT_FACE_INDX		(USES_TIMES_SPACING + 21L)
#define MS_DIALOG_LIGHT_FONT_FACE_INDX		(USES_TIMES_SPACING + 22L)
#define MS_LINEDRAW_FONT_FACE_INDX		(USES_ARIAL_SPACING + 23L)
#define MS_SANS_SERIF_FONT_FACE_INDX		(USES_ARIAL_SPACING + 24L)
#define MS_SERIF_FONT_FACE_INDX			(USES_ARIAL_SPACING + 25L)
#define MS_SYSTEMEX_FONT_FACE_INDX		(USES_TIMES_SPACING + 26L)
#define PLAYBILL_FONT_FACE_INDX			(USES_TIMES_SPACING + 27L)
#define SMALL_FONTS_FONT_FACE_INDX		(USES_TIMES_SPACING + 28L)
#define VERDANA_FONT_FACE_INDX			(USES_ARIAL_SPACING + 29L)
#define WIDE_LATIN_FONT_FACE_INDX		(USES_ARIAL_SPACING + 30L)
#define COMIC_SANS_MS_FONT_FACE_INDX		(USES_TIMES_SPACING + 31L)
#define FIXEDSYS_FONT_FACE_INDX			(USES_COURIER_SPACING + 32L)
#define TERMINAL_FONT_FACE_INDX			(USES_SYSTEM_SPACING + 33L)
#define HELVETICA_FONT_FACE_INDX		(USES_ARIAL_SPACING + 34L)
//DBCS fonts:
#define OSAKA_FONT_FACE_INDX			(CJK_FONT_INDEX+1L)
#define SIMPLECHINESE_FONT_FACE_INDX		(CJK_FONT_INDEX+2L)
#define TRADITIONALCHINESE_FONT_FACE_INDX	(CJK_FONT_INDEX+3L)
//KOREAN!
#define SEOUL_FONT_FACE_INDX			(CJK_FONT_INDEX+4L)
//KOREAN!
#define BATANG_FONT_FACE_INDX			(CJK_FONT_INDEX+5L)
//KOREAN!
#define BATANGCHE_FONT_FACE_INDX		(CJK_FONT_INDEX+6L)
//KOREAN!
#define GULIM_FONT_FACE_INDX			(CJK_FONT_INDEX+7L)
//KOREAN!
#define GULIMCHE_FONT_FACE_INDX			(CJK_FONT_INDEX+8L)
//KOREAN!
#define GOTHIC_FONT_FACE_INDX			(CJK_FONT_INDEX+9L)
//KOREAN!
#define APPLEGOTHIC_FONT_FACE_INDX		(CJK_FONT_INDEX+10L)

#define TIMES_FONT_FACE_STR		"TIMES"
#define TIMES_FONT_FACE_STRLEN		5
#define TIMES_FONT_FACE_STR2		"TIMES NEW ROMAN"
#define TIMES_FONT_FACE_STR2LEN		15
#define COURIERTT_FONT_FACE_STR		"COURIER"
#define COURIERTT_FONT_FACE_STRLEN	7
#define COURIERTT_FONT_FACE_STR2	"COURIER NEW"
#define COURIERTT_FONT_FACE_STR2LEN	11
#define SYSTEM_FONT_FACE_STR		"SYSTEM"
#define SYSTEM_FONT_FACE_STRLEN		6
//These are Mac-specific fonts that are default installed on all Macs
// (and Mac also has "Times", "Times New Roman", "Courier", "Courier New",
// and "Impact" installed out of the box):
#define HELVETICA_FONT_FACE_STR		"HELVETICA"
#define HELVETICA_FONT_FACE_STRLEN	9
#define GENEVA_FONT_FACE_STR		"GENEVA"
#define GENEVA_FONT_FACE_STRLEN		6
/*XXXXXEH- add these in when we're ready to support these on non-Macs:
 * #define CHARCOAL_FONT_FACE_STR	"CHARCOAL"
 * #define CHARCOAL_FONT_FACE_STRLEN	8
 * #define CHICAGO_FONT_FACE_STR	"CHICAGO"
 * #define CHICAGO_FONT_FACE_STRLEN	7
 * #define GADGET_FONT_FACE_STR		"GADGET"
 * #define GADGET_FONT_FACE_STRLEN	6
 * #define MONACO_FONT_FACE_STR		"MONACO"
 * #define MONACO_FONT_FACE_STRLEN	6
 * #define NEW_YORK_FONT_FACE_STR	"NEW YORK"
 * #define NEW_YORK_FONT_FACE_STRLEN	8
 * #define PALATINO_FONT_FACE_STR	"PALATINO"
 * #define PALATINO_FONT_FACE_STRLEN	9
 */
#define ARIAL_FONT_FACE_STR		"ARIAL"
#define ARIAL_FONT_FACE_STRLEN		5
#define ARIAL_BLACK_FONT_FACE_STR	"ARIAL BLACK"
#define ARIAL_BLACK_FONT_FACE_STRLEN	11
#define ARIAL_NARROW_FONT_FACE_STR	"ARIAL NARROW"
#define ARIAL_NARROW_FONT_FACE_STRLEN	12
#define ARIAL_ROUNDED_MT_BOLD_FONT_FACE_STR	"ARIAL ROUNDED MT BOLD"
#define ARIAL_ROUNDED_MT_BOLD_FONT_FACE_STRLEN	21
#define BOOK_ANTIQUA_FONT_FACE_STR	"BOOK ANTIQUA"
#define BOOK_ANTIQUA_FONT_FACE_STRLEN	12
#define BOOKMAN_OLD_STYLE_FONT_FACE_STR	    "BOOKMAN OLD STYLE"
#define BOOKMAN_OLD_STYLE_FONT_FACE_STRLEN  17
#define BRAGGADOCIO_FONT_FACE_STR	"BRAGGADOCIO"
#define BRAGGADOCIO_FONT_FACE_STRLEN	11
#define BRITANNIC_BOLD_FONT_FACE_STR	"BRITANNIC BOLD"
#define BRITANNIC_BOLD_FONT_FACE_STRLEN	14
#define BRUSH_SCRIPT_FONT_FACE_STR	"BRUSH SCRIPT"
#define BRUSH_SCRIPT_FONT_FACE_STRLEN	12
#define CENTURY_GOTHIC_FONT_FACE_STR	"CENTURY GOTHIC"
#define CENTURY_GOTHIC_FONT_FACE_STRLEN	14
#define CENTURY_SCHOOLBOOK_FONT_FACE_STR	"CENTURY SCHOOLBOOK"
#define CENTURY_SCHOOLBOOK_FONT_FACE_STRLEN	18
#define COLONNA_MT_FONT_FACE_STR	"COLONNA MT"
#define COLONNA_MT_FONT_FACE_STRLEN	10
#define COMIC_SANS_MS_FONT_FACE_STR	"COMIC SANS MS"
#define COMIC_SANS_MS_FONT_FACE_STRLEN	13
#define DESDEMONA_FONT_FACE_STR		"DESDEMONA"
#define DESDEMONA_FONT_FACE_STRLEN	9
#define FIXEDSYS_FONT_FACE_STR		"FIXEDSYS"
#define FIXEDSYS_FONT_FACE_STRLEN	8
#define FOOTLIGHT_MT_LIGHT_FONT_FACE_STR	"FOOTLIGHT MT LIGHT"
#define FOOTLIGHT_MT_LIGHT_FONT_FACE_STRLEN	18
#define GARAMOND_FONT_FACE_STR		"GARAMOND"
#define GARAMOND_FONT_FACE_STRLEN	8
#define HAETTENSCHWEILER_FONT_FACE_STR	    "HAETTENSCHWEILER"
#define HAETTENSCHWEILER_FONT_FACE_STRLEN   16
#define IMPACT_FONT_FACE_STR		"IMPACT"
#define IMPACT_FONT_FACE_STRLEN		6
#define KINO_MT_FONT_FACE_STR		"KINO MT"
#define KINO_MT_FONT_FACE_STRLEN	7
#define MATURA_MT_SCRIPT_CAPITALS_FONT_FACE_STR	"MATURA MT SCRIPT CAPITALS"
#define MATURA_MT_SCRIPT_CAPITALS_FONT_FACE_STRLEN	25
#define MODERN_FONT_FACE_STR		"MODERN"
#define MODERN_FONT_FACE_STRLEN		6
#define MS_DIALOG_FONT_FACE_STR		"MS DIALOG"
#define MS_DIALOG_FONT_FACE_STRLEN	9
#define MS_DIALOG_LIGHT_FONT_FACE_STR	    "MS DIALOG LIGHT"
#define MS_DIALOG_LIGHT_FONT_FACE_STRLEN   15
#define MS_LINEDRAW_FONT_FACE_STR	"MS LINEDRAW"
#define MS_LINEDRAW_FONT_FACE_STRLEN	11
#define MS_SANS_SERIF_FONT_FACE_STR	"MS SANS SERIF"
#define MS_SANS_SERIF_FONT_FACE_STRLEN	13
#define MS_SERIF_FONT_FACE_STR		"MS SERIF"
#define MS_SERIF_FONT_FACE_STRLEN	8
#define MS_SYSTEMEX_FONT_FACE_STR	"MS SYSTEMEX"
#define MS_SYSTEMEX_FONT_FACE_STRLEN	11
#define PLAYBILL_FONT_FACE_STR		"PLAYBILL"
#define PLAYBILL_FONT_FACE_STRLEN	8
#define SMALL_FONTS_FONT_FACE_STR	"SMALL FONTS"
#define SMALL_FONTS_FONT_FACE_STRLEN	0
#define TERMINAL_FONT_FACE_STR		"TERMINAL"
#define TERMINAL_FONT_FACE_STRLEN	8
#define VERDANA_FONT_FACE_STR		"VERDANA"
#define VERDANA_FONT_FACE_STRLEN	7
#define WIDE_LATIN_FONT_FACE_STR	"WIDE LATIN"
#define WIDE_LATIN_FONT_FACE_STRLEN	10
#define ALGERIAN_FONT_FACE_STR		"ALGERIAN"
#define ALGERIAN_FONT_FACE_STRLEN	8
//--------DBCS FONT FACES:---------------------
#define OSAKA_FONT_FACE_STR			"OSAKA"
#define OSAKA_FONT_FACE_STRLEN			5
#define SIMPLECHINESE_FONT_FACE_STR		"\x27\xCB\xCE\xCC\xE5"
#define SIMPLECHINESE_FONT_FACE_STRLEN		5
#define TRADITIONALCHINESE_FONT_FACE_STR	"\xB2\xD3\xA9\xFA\xC5\xE9"
#define TRADITIONALCHINESE_FONT_FACE_STRLEN	6
//KOREAN!
#define SEOUL_FONT_FACE_STR			"SEOUL"
#define SEOUL_FONT_FACE_STRLEN			5
//KOREAN!
#define BATANG_FONT_FACE_STR			"BATANG"
#define BATANG_FONT_FACE_STRLEN			6
//KOREAN!
#define BATANGCHE_FONT_FACE_STR			"BATANGCHE"
#define BATANGCHE_FONT_FACE_STRLEN		9
//KOREAN!
#define GULIM_FONT_FACE_STR			"GULIM"
#define GULIM_FONT_FACE_STRLEN			5
//KOREAN!
#define GULIMCHE_FONT_FACE_STR			"GULIMCHE"
#define GULIMCHE_FONT_FACE_STRLEN		8
//KOREAN!
#define GOTHIC_FONT_FACE_STR			"GOTHIC"
#define GOTHIC_FONT_FACE_STRLEN			6
//KOREAN!
#define APPLEGOTHIC_FONT_FACE_STR		"APPLEGOTHIC"
#define APPLEGOTHIC_FONT_FACE_STRLEN		11

#define INVALID_CHARSET		0x00000000

#ifdef _WIN16
#define HX_GB2312_CHARSET	134
#endif

#define HX_WEST_EUROPE_CHARSET	0x00010000
#define HX_EAST_EUROPE_CHARSET	0x00020000
#define HX_JAPANESE_CHARSET	0x00040000
#define HX_KOREAN_CHARSET	0x00080000
#define HX_CHINESE_CHARSET	0x00100000
#define HX_MISCL_CHARSET	0x00200000
#define HX_ARABIC_CHARSET	0x00400000
#define HX_GREEK_CHARSET	0x00800000
#define HX_HEBREW_CHARSET	0x01000000
#define HX_TURKISH_CHARSET	0x02000000
#define HX_THAI_CHARSET		0x04000000
#define HX_MISCLANGUAGE_CHARSET	0x08000000
#define HX_SBCS_CHARSET		0x10000000
#define HX_DBCS_CHARSET		0x20000000
#define HX_UNICODE_CHARSET	0x40000000
#define HX_UBCS_CHARSET		0x80000000 //'U'="Unresearched / not-yet-known"

#define CHARSET__us_ascii	(HX_SBCS_CHARSET|HX_WEST_EUROPE_CHARSET	|0x0000000A)
#define CHARSET__iso_8859_1	(HX_SBCS_CHARSET|HX_WEST_EUROPE_CHARSET	|0x00000001)
#define CHARSET__x_mac_roman	(HX_SBCS_CHARSET|HX_WEST_EUROPE_CHARSET	|0x0000000B)
#define CHARSET__iso_8859_2	(HX_SBCS_CHARSET|HX_EAST_EUROPE_CHARSET	|0x00000002)
// /x-mac-ce is same as iso-8859-2:
#define CHARSET__x_mac_ce	(HX_SBCS_CHARSET|HX_EAST_EUROPE_CHARSET	|0x00000003)
// /This requires translation table for Windows from iso-8859-5 to
// windows-1251 and from iso-8859-5 to x-ru-mac, on a macintosh:
#define CHARSET__iso_8859_5	(HX_SBCS_CHARSET|HX_EAST_EUROPE_CHARSET	|0x00000005)
// /Arabic:
#define CHARSET__iso_8859_6	(HX_SBCS_CHARSET|HX_ARABIC_CHARSET	|0x00000006)
// /Greek:
#define CHARSET__iso_8859_7	(HX_SBCS_CHARSET|HX_GREEK_CHARSET	|0x00000007)
// /Hebrew:
#define CHARSET__iso_8859_8	(HX_SBCS_CHARSET|HX_HEBREW_CHARSET	|0x00000008)
// /Turkish:
#define CHARSET__iso_8859_9	(HX_SBCS_CHARSET|HX_TURKISH_CHARSET	|0x00000009)
// /Thai:
#define CHARSET__iso_ir_166	(HX_SBCS_CHARSET|HX_THAI_CHARSET	|0x000007A1)
#define CHARSET__iso_8859_11	(HX_SBCS_CHARSET|HX_THAI_CHARSET	|0x00000011)
// /Baltic (Latvian, Estonian, ...etc.):
#define CHARSET__iso_8859_13	(HX_SBCS_CHARSET|HX_EAST_EUROPE_CHARSET	|0x00000013)
// /Another Cyrillic (Russian, Bulgarian, ...etc.):
#define CHARSET__windows_1251	(HX_SBCS_CHARSET|HX_EAST_EUROPE_CHARSET	|0x0000000A)
// /This requires translation table for Windows from iso-8859-5 to
// windows-1251 and from iso-8859-5 to x-ru-mac, on a macintosh:
#define CHARSET__koi8_r		(HX_SBCS_CHARSET|HX_EAST_EUROPE_CHARSET	|0x0000000B)

// /Japanese:
#define CHARSET__iso_2022_jp	(HX_DBCS_CHARSET|HX_JAPANESE_CHARSET	|0x00000001)
#define CHARSET__x_sjis		(HX_DBCS_CHARSET|HX_JAPANESE_CHARSET	|0x00000002)
#define CHARSET__x_euc_jap	(HX_DBCS_CHARSET|HX_JAPANESE_CHARSET	|0x00000003)
// /Korean:
#define CHARSET__euc_kr		(HX_DBCS_CHARSET|HX_KOREAN_CHARSET	|0x00000001)
#define CHARSET__iso_2022_kr	(HX_DBCS_CHARSET|HX_KOREAN_CHARSET	|0x00000002)
// /The following two are what we should have used all along in Windows Korean:
#define CHARSET__hangeul	(HX_DBCS_CHARSET|HX_KOREAN_CHARSET	|0x00000003)
#define CHARSET__ksc5601	CHARSET__hangeul
// /Johab Korean:
#define CHARSET__johab		(HX_DBCS_CHARSET|HX_KOREAN_CHARSET	|0x00000004)

// /Chinese:
#define CHARSET__big5		(HX_DBCS_CHARSET|HX_CHINESE_CHARSET	|0x00000001)
#define CHARSET__gb2312		(HX_DBCS_CHARSET|HX_CHINESE_CHARSET	|0x00000002)
#define CHARSET__gb_2312_80	(HX_DBCS_CHARSET|HX_CHINESE_CHARSET	|0x00000003)
// /x-euc-tw is same as big5:
#define CHARSET__x_euc_tw	(HX_DBCS_CHARSET|HX_CHINESE_CHARSET	|0x00000004)
#define CHARSET__x_cns11643_1	(HX_DBCS_CHARSET|HX_CHINESE_CHARSET	|0x00000005)
#define CHARSET__x_cns11643_2	(HX_DBCS_CHARSET|HX_CHINESE_CHARSET	|0x00000006)

#define CHARSET__default	CHARSET__us_ascii


#endif
