/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: find_eof_strategy.h,v 1.1.4.1 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef FIND_EOF_STRATEGY_H
#define FIND_EOF_STRATEGY_H

#include "page_strategy.h"

class COggFindEOFStrategy : public COggPageStrategy
{
public:
    COggFindEOFStrategy();
    virtual ~COggFindEOFStrategy();

    // COggPageStrategy methods    
    virtual HX_RESULT ReadNextPageDone(HX_RESULT status,
                                       ULONG32 ulFileOffset,
                                       UINT32 ulPageSize,
                                       ogg_page* pPage);
    virtual BOOL Done() const;
    virtual void Close();

    // COggFindEOFStrategy methods
    HX_RESULT Init(COggPageReader* pPageReader);

    HX_RESULT LastPageOffset(ULONG32& ulOffset) const;
    HX_RESULT LastPageSize(UINT32& uPageSize) const;
    HX_RESULT LastPageSerialNum(int& serialNum) const;

private:
    typedef enum {
        ssStart,
        ssInitialized,
        ssDone,
    } StrategyState;

    void changeState(StrategyState newState);
    HX_RESULT seekBackMore();

    COggPageReader* m_pPageReader;
    StrategyState m_state;

    ULONG32 m_ulLastSeekOffset;
    UINT32 m_uSeekBackTotal;
    BOOL m_bLastPageInfoValid;
    ULONG32 m_ulLastPageOffset;
    UINT32 m_uLastPageSize;
    int m_lastPageSerialNum;
};
#endif /* FIND_EOF_STRATEGY_H */
