
#include "Viewer.h"
#include "Parser.h"
#include "parser-hooks.h"
#include "../util/debug.h"
#include "../util/error.h"
#include <stdio.h>

extern int viewParse(const char* filename);

int runViewer()
{
 Collection<ViewObject> col;
 char* background;
 Parser p(&col, &background, 640);
 docParser = &p;
 VPRINTF("<view> inited\n");

 if(viewParse("test.trilby"))
  {
   setError("Parsing documentation failed: %s", errStr);
   nonFatal("%s\n", errStr);
   return 1;
  }
 VPRINTF("<doc> parsed\n");

 Viewer v(&col, "backgrounds/bubbles.spr.gz", 0, 0, vgaW, vgaH);
 v.init();

 v.run();
 VPRINTF("<doc> finished");

 return 0;
}




